/**
 * Gestion des events de la modale de prise de RDV
 */

var jquery = jQuery.noConflict();// Permettre le non conflit avec la librairie standard SuiteCRM
//Gestion entrypoint php
var resultat = "";
var actualisation = "";

// Gestion Rdv modale
var modification_hors_plage = false;
var lieu_final = "";
var user_default_index = "";

// Gestion Rdv TMP
var date_rdv_tmp = "";
var differenceMin = -1;
var rdv_modif = false;
var rdv_action = "creation";

jquery(document).ready(function () {


	if (document.getElementById('user_id') != null) {
		user_default_index = document.getElementById('user_id').selectedIndex;
	}


	// Event CLick sur Date dans la modale de rdv
	document.getElementById("date_debut").onclick = function () {

		jquery("#calendrier").fullCalendar("removeEvents");
		jquery("#calendrier").fullCalendar("refetchEvents");
		suppression_rdv_tmp();

		if (document.getElementById("crea_lieu_autre") != null && document.getElementById("crea_lieu_autre_input").text != "") {
			lieu_final = document.getElementById("crea_lieu_autre_input").value;
		} else {
			lieu_final = document.getElementById("crea_lieu").value;
		}

		jQuery("#filtre_calendrier_lieu").val(
			document.getElementById("crea_lieu").options[document.getElementById("crea_lieu").selectedIndex].value
		);

		document.querySelector('#filtre_calendrier_lieu option[value="autre"]').style.display = 'none';


		if (type_rdv != "hors_plage") {

			jQuery("#filtre_calendrier_motif").val(
				document.getElementById("crea_motif").options[document.getElementById("crea_motif").selectedIndex].value
			);

			document.getElementById("date_debut").value = "";
			show_tab_agenda("calendar");

		} else {
			modifier_rdv_hors_plage();
		}
	};

	jquery(document).keydown(function(event) { 
		if (event.keyCode == 27) { 
			jquery('#modale_creation').hide();
		}
	});

	// Tris des listboxs dans la modale de création
	sort_list("crea_lieu");
	sort_list("crea_motif");
	sort_list("crea_ressource");


	jquery("a.btn_agenda_tab").off().on("click", function (e) {
		e.preventDefault();
		fiedset_target = jquery(e.target).attr("rel");
		show_tab_agenda(fiedset_target);
	});

	show_tab_agenda("details");

	jquery("#tel").mask("99.99.99.99.99");
	jquery("#date_naissance_recherche").mask("99/99/9999");

	// Synchronise les selecteurs de motifs entre la vue détail et dans la vue Calendrier
	jquery("#crea_motif").on("change", function () {
		jQuery("#filtre_calendrier_motif").val(
			document.getElementById("crea_motif").options[document.getElementById("crea_motif").selectedIndex].value
		);

		//document.getElementById("date_debut").value = "";
		jquery("#calendrier").fullCalendar("removeEvents");
		jquery("#calendrier").fullCalendar("refetchEvents");
	});

	jquery("#filtre_calendrier_motif").on("change", function () {
		jQuery("#crea_motif").val(
			document.getElementById("filtre_calendrier_motif").options[document.getElementById("filtre_calendrier_motif").selectedIndex].value
		);
		//document.getElementById("date_debut").value = "";
		jquery("#calendrier").fullCalendar("removeEvents");
		jquery("#calendrier").fullCalendar("refetchEvents");
	});


	// Synchronise les selecteurs de lieu entre la vue détail et dans la vue Calendrier
	jquery("#crea_lieu").on("change", function () {
		if (type_rdv != "hors_plage") {
			jQuery("#filtre_calendrier_lieu").val(
				document.getElementById("crea_lieu").options[document.getElementById("crea_lieu").selectedIndex].value
			);
			//document.getElementById("date_debut").value = "";
			jquery("#calendrier").fullCalendar("removeEvents");
			jquery("#calendrier").fullCalendar("refetchEvents");
		}
	});

	jquery("#filtre_calendrier_lieu").on("change", function () {
		jQuery("#crea_lieu").val(
			document.getElementById("filtre_calendrier_lieu").options[document.getElementById("filtre_calendrier_lieu").selectedIndex].value
		);
		//document.getElementById("date_debut").value = "";
		jquery("#calendrier").fullCalendar("removeEvents");
		jquery("#calendrier").fullCalendar("refetchEvents");
	});


	document.getElementById("annuler_modale").onclick = function () {
		suppression_rdv_tmp();
		jquery("#calendar").fullCalendar("refetchEvents");
		document.getElementById("modale_creation").style.display = "none";
		reset();
	};

	document.getElementById("annuler").onclick = function () {
		suppression_rdv_tmp();
		jquery("#calendar").fullCalendar("refetchEvents");
		document.getElementById("modale_creation").style.display = "none";
		reset();
	};


	document.getElementById("sauvegarder").onclick = function () {
		save_rdv();
	};



	if (document.getElementById("supprimer") != null) {
		document.getElementById("supprimer").onclick = function () {
			var r = confirm("Voulez-vous réellement supprimer ce rendez-vous ?");
			if (r == true) {
				var user_id = document.getElementById("current_user").value;
				//var params ="methode=rdv_suppr&meeting_id=" + document.getElementById("meeting_id").value + "&user_id=" + user_id;
				var params = "methode=rdv_suppr&methode_btn=annulation&meeting_id=" + document.getElementById("meeting_id").value + "&user_id=" + user_id;

				mise_a_jour(params);

				if (resultat != "") {
					setTimeout(function () {
						window.location.reload();
					}, 0);
				} else {
					alert("Une erreur s'est produite. (5)");
				}

				document.getElementById("modale_creation").style.display = "none";
			}
		};
	}


	///
	/// Calendar modale
	jquery("#calendrier").fullCalendar({
		slotDuration: "00:" + affichage_duration + ":00",
		slotLabelInterval: "01:00",
		slotLabelFormat: "HH:mm",
		minTime: affichage_min_time,
		maxTime: affichage_max_time,

		weekends: week, // Masquer des jours dans la semaine
		locale: "fr",  // Initialisation du français
		buttonIcons: true,  // Utilisation des icones prec/suiv
		weekNumbers: false, // Afficher les numéros de semaines
		navLinks: true,
		businessHours: false, // display business hours
		editable: false,
		eventLimit: true, // allow "more" link when too many events
		defaultView: affichage_gestion,
		height: 450,
		aspectRatio: 15,
		timezone: Intl.DateTimeFormat().resolvedOptions().timeZone,
		timeFormat: "HH:mm",

		// Masquer des jours dans la semaine
		views: {
			basicWeek: {
				buttonText: "Semaine",
			},
			month: {
				buttonText: "Mois",
				eventLimit: 3,
			},
		},

		// Création d'un bouton custom pour la création d'un rdv
		customButtons: {
			refresh: {
				text: "Rafraîchir",
				click: function () {
					jquery("#calendrier").fullCalendar("refetchEvents");
				},
			},
			firstDispo: {
				text: "1ère disponibilité",
				click: function () {
					document.getElementById("patiente").innerText = "Veuillez patientez pendant le chargement";
					document.getElementById("patiente").style.display = "block";

					let agenda_id = document.getElementById("visua_agenda").options[document.getElementById("visua_agenda").selectedIndex].value;
					let lieu_id = "";

					if (document.getElementById("filtre_calendrier_lieu") != null) {
						lieu_id = document.getElementById("filtre_calendrier_lieu").options[document.getElementById("filtre_calendrier_lieu").selectedIndex].id;
					}

					let motif_id = document.getElementById("filtre_calendrier_motif").options[document.getElementById("filtre_calendrier_motif").selectedIndex].value;

					jquery.ajax({
						url: "/index.php?entryPoint=agenda_visualisation&methode=creneaux_disponibles",
						type: "POST",
						dataType: "json",
						data: {
							id_agenda: agenda_id,
							motif: motif_id,
							lieu: lieu_id,
							start: "",
							end: "",
						},
						success: function (events) {
							if (events.length != 0) {

								// Trier les événements par ordre croissant de date de début
								events.sort(function (a, b) {
									return new Date(a.start) - new Date(b.start);
								});

								// Récupération du premier créneau disponible
								let firstAvailableSlot = new Date(events[0].end);

								// Si un créneau disponible a été trouvé, naviguer à la semaine qui contient cet événement
								if (firstAvailableSlot) {
									jquery("#calendrier").fullCalendar("gotoDate", firstAvailableSlot);
									jquery("#calendrier").fullCalendar("changeView", "basicWeek");
								}

							}
							document.getElementById("patiente").style.display = "none";
						}
					});
				},
			},
		},

		// Affichage des boutons au dessus du calendrier
		header: {
			left: "firstDispo,today,prev,next ",
			center: "title",
			right: "month, basicWeek",
		},

		// Récupération/Synchronisation des créneaux dispos
		events: function (start, end, timezone, callback) {

			// Ajout du meeting pour l'écarter de la recherche des créneaux dispos
			var add = "";
			if (document.getElementById("meeting_id").value != "") {
				add = "&meeting_id=" + document.getElementById("meeting_id").value;
			}

			var agenda_id = document.getElementById("visua_agenda").options[document.getElementById("visua_agenda").selectedIndex].value;
			var motif_id = document.getElementById("filtre_calendrier_motif").options[document.getElementById("filtre_calendrier_motif").selectedIndex].value;
			var lieu_id = "";

			if (document.getElementById("filtre_calendrier_lieu")) {
				lieu_id = document.getElementById("filtre_calendrier_lieu").options[document.getElementById("filtre_calendrier_lieu").selectedIndex].id;
			}

			if (document.getElementById("modale_creation").style.display === "block" && motif_id != "autre") {

				jquery.ajax({
					url: url_creaneau = "/index.php?entryPoint=agenda_visualisation&methode=creneaux_disponibles" + add,
					type: "POST",
					dataType: "json",
					data: {
						id_agenda: agenda_id,
						motif: motif_id,
						lieu: lieu_id,
						start: start.format(),
						end: end.format(),
					},
					success: function (json) {
						callback(json);
					},
				});
			} else {
				let json = {};
				callback(json);
			}

		},

		eventRender: (calEvent, jsEvent, view) => {

			// Css pour les creneaux ayant un rdv hors plage
			if (calEvent.hors_plage === 1) {

				jsEvent[0].classList.add("rdv_hors_plage");;

				const spanElementTime = jsEvent[0].querySelector("span.fc-time");
				const spanElementTitle = jsEvent[0].querySelector("span.fc-title");
				if (spanElementTime && spanElementTitle) {
					spanElementTime.style.color = "white";
					spanElementTitle.style.color = "white";
				}
			}
		},

		loading: function (bool) {
			jquery("#patiente").toggle(bool);
		},

		// Click sur un créneau disponible
		eventClick: function (calEvent, jsEvent, view) {
			rdv_modif = false;
			show_tab_agenda("details");

			if (typeof actualisation != "undefined") {
				clearTimeout(actualisation);
			}

			// Reset all classname
			jQuery(".fc-widget-content").find(".fc-event").removeClass("active");
			jQuery(this).addClass("active");

			document.getElementById("date_debut").value = calEvent.date_deb;
			document.getElementById("date_fin").value = calEvent.date_fin;


			if (type_rdv != "hors_plage" && !document.getElementById("filtre_calendrier_lieu")) {
				document.getElementById("crea_lieu").value = lieu_final;
			} else {
				document.getElementById("crea_lieu").value = calEvent.lieu_id;
				document.getElementById("filtre_calendrier_lieu").value = calEvent.lieu_id;
			}

			document.getElementById("date_debut").style = "border:none !important;";


			jQuery("#calendrier").fullCalendar("refetchEvents");

			var verif = verification_dispo_rendez_vous();
			// Si le créneau est disponible alors on créé un rdv temporaire
			if (verif == true) {
				var params = new Array();
				var id_meeting = document.getElementById("meeting_id").value;
				var id_meeting_2 = document.getElementById("meeting_id_2").value;

				params.push(document.getElementById("visua_agenda").value);
				params.push(document.getElementById("date_debut").value);
				params.push(document.getElementById("crea_motif").options[document.getElementById("crea_motif").selectedIndex].value);
				var user_id = document.getElementById("current_user").value;

				var tab_param = "";
				for (var i = 0; i < params.length; i++) {
					if (i == 0) {
						tab_param += params[i];
					} else {
						tab_param += "|" + params[i];
					}
				}

				var par = "params=" + tab_param + "&methode=rdv_temporaire&meeting_id=" + id_meeting + "&meeting_id_2=" + id_meeting_2 + " &user_id=" + user_id + "&lieu_id=" + document.getElementById("crea_lieu").value + "&individu_id=" + document.getElementById("id_individu_trouve_id").value;

				date_rdv_tmp = new Date();


				resultat = "";
				mise_a_jour(par);

				if (resultat != "") {
					document.getElementById("meeting_id_2").value = resultat;
				} else {
					alert("Une erreur s'est produite. (6) " + resultat);
				}
			}
		},

		// Entrée du Survol sur un créneau
		eventMouseover: function (data, event, view) {
			if (data.lieu) {
				// Popup d'affichage du lieu
				var tooltip = '<div id="survolCreneau" class="survolCreneau" data-container="calendrier" data-toggle="popover" data-placement="top">' +
					"Lieu" + ": " + data.lieu + "<br>" +
					"</div>";

				jquery("#modale_creation").append(tooltip);
				jquery(this)
					.mouseover(function (e) {
						jquery(this).css("z-index", 10000);
						jquery(".survolCreneau").fadeIn("500");
						jquery(".survolCreneau").fadeTo("10", 1.9);
					})
					.mousemove(function (e) {
						jquery(".survolCreneau").css("top", e.pageY - 80);
						jquery(".survolCreneau").css("left", e.pageX + 20);
					});
			}
		},

		// Retrait du Survol sur un créneau
		eventMouseout: function (data, event, view) {
			jquery(this).css("z-index", 8);
			jquery(".survolCreneau").remove();
		},
	});
});



function save_rdv() {
	if (document.getElementById("date_debut").value != "") {

		var its_ok = true;
		var collection_champ_obl = document.getElementsByClassName("obligatoire");

		for (let i = collection_champ_obl.length - 1; i >= 0; i--) {
			if ((collection_champ_obl[i] != null) && (collection_champ_obl[i].value == "")) {

				collection_champ_obl[i].style = "border:2px solid  #FB434F !important;";
				its_ok = false;

				if (collection_champ_obl[i].id == "commentaire") {
					var comment_true = true;
				}
				if (collection_champ_obl[i].id == "email_recherche") {
					var email_true = true;
				}
				if (collection_champ_obl[i].id == "tel") {
					var tel_true = true;
				}
				if (collection_champ_obl[i].id == "date_naissance_recherche") {
					var naissance_true = true;
				}
				if (collection_champ_obl[i].id == "crea_ressource") {
					var ressource_true = true;
				}
				if (collection_champ_obl[i].id == "first_name_recherche") {
					var first_name_true = true;
				}
				if (collection_champ_obl[i].id == "last_name_recherche") {
					var last_name_true = true;
				}
				if (collection_champ_obl[i].id == "civilite_recherche") {
					var civilite_true = true;
				}

			} else if (collection_champ_obl[i] != null) {
				$(collection_champ_obl[i]).css("border-color: #a5e8d6; border-style: solid; border-radius: 4px;");
			}
		}


		if (last_name_true != true) {
			document.getElementById("last_name_recherche").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		if (first_name_true != true) {
			document.getElementById("first_name_recherche").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		var champ_ressource = document.getElementById("crea_ressource");
		if (ressource_true != true && champ_ressource == "crea_ressource") {
			document.getElementById("crea_ressource").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		if (naissance_true != true) {
			document.getElementById("date_naissance_recherche").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		if (tel_true != true) {
			document.getElementById("tel").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		if (email_true != true) {
			document.getElementById("email_recherche").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		}

		if (document.getElementById("crea_lieu").value == '') {
			its_ok = false;
			document.getElementById("crea_lieu").style = "border:2px solid #FB434F !important;";
		} else {
			document.getElementById("crea_lieu").style = "border-color: #DDDDDD; border-style: solid; border-radius: 10px;";
		}


		if (its_ok == true) {
			its_ok = validate_tel();

			var oblmail = document.getElementById("email_recherche");
			var oblMailClass = oblmail.className;

			if (oblMailClass === "obligatoire") {
				its_ok = validate_mail();
			}

			its_ok = validate_date_naissance();

			var collection_champ_stock = document.getElementsByClassName("stock");

			// On teste si un champ a été modifié manuellement sans nouvelle recherche pour bloquer la sauvegarde
			var champ_modifie = false;
			for (var i = collection_champ_stock.length - 1; i >= 0; i--) {
				// Si on est sur une modification de rendez-vous, on vérifie si un champ a changé
				if (collection_champ_stock[i] != null && collection_champ_stock[i].value) {

					var id_new = collection_champ_stock[i].id;
					if (id_new != "tel_stock") {
						id_new = id_new.replace("_stock", "_recherche");
					}

					var radioValue = jQuery("#modal-individu-body input[name='individu_trouve']:checked").val();

					if (collection_champ_stock[i].value != document.getElementById(id_new).value && typeof radioValue == "undefined") {
						champ_modifie = true;
					}
				}
			}

			var action = document.getElementById("action").value;

			// Vérification si on a récupéré un individu via la recherche
			/* 			var id_individu_recherche = document.getElementById("id_individu_trouve_id").value;
						if (action != "creation_individu" && (!id_individu_recherche || champ_modifie)) { // Si une recherche n'a pas été faite et/ou qu'un champ individu a été modifié manuellement
							alert("Veuillez confirmer l'individu en effectuant une recherche.");
						} else { */

			var r = confirm("Souhaitez-vous sauvegarder ce rdv?");

			if (r == true) {

				// On vérifie qu'il s'agit d'une création de rendez-vous avec création individu
				if (action == "creation_individu") {
					// Création de la variable qui va recevoir les infos individu
					var result_indi = $.toJSON([]);

					create_individu();
					result_indi = indi_Result;
					json_indi = $.parseJSON(result_indi) || null;

					if (json_indi != null && json_indi.length == 1) {
						var obj_reponse = json_indi[0];

						// retour error individu déjà existant
						if (obj_reponse.resultat == "error") {
							if (obj_reponse.reponse == "mail_existant") {
								alert("L'email est déjà utilisé");
							} else if (obj_reponse.reponse == "nom_naissance_existant") {
								alert("L'individu est déjà existant");
							} else if (obj_reponse.reponse == "erreur_requete") {
								alert("Une erreur dans la recherche de l'individu en base de données est survenue");
							}
							// pas d'individu trouvé avec ces params
						} else if (obj_reponse.resultat == "valide") {
							nom = document.getElementById("last_name_recherche").value;
							prenom = document.getElementById("first_name_recherche").value;
							full_name = nom + " " + prenom;

							$("#id_individu_trouve_id").val(obj_reponse.reponse);
							$("#usager").val(full_name);

							var id_individu = "&id_individu=" + obj_reponse.reponse;
						} else {
							alert("Une erreur s'est produite. (4)");
						}
					}
				} else {
					var id_individu = "&id_individu=" + document.getElementById("id_individu_trouve_id").value;
				}


				let bool_send = false;
				let str_type_rdv = "";
				let elm_date_debut = "";
				let id_meeting_send = "";

				// Vérification si rdv hors plage. Sinon le creno doit etre dispo et le rdv tmp non suppr
				if (type_rdv == "hors_plage") {
					bool_send = true;
					str_type_rdv = "hors_plage";
					elm_date_debut = document.getElementById("date_start").value;
					id_meeting_send = document.getElementById("meeting_id").value;

				} else if (verification_dispo_rendez_vous() == true && verification_duree_tmp() == true) {
					bool_send = true;
					str_type_rdv = "Réservé";
					elm_date_debut = document.getElementById("date_debut").value;

					var id_meeting = document.getElementById("meeting_id").value;
					var id_meeting_2 = document.getElementById("meeting_id_2").value;
					id_meeting_send = id_meeting + "&meeting_id_2=" + id_meeting_2;
				}

				if (bool_send) {


					var params = new Array();

					params.push(document.getElementById("visua_agenda").value);
					params.push(elm_date_debut);
					params.push(document.getElementById("date_fin").value);
					params.push(document.getElementById("usager").value);
					params.push(rdv_action);
					params.push(document.getElementById("presence").options[document.getElementById("presence").selectedIndex].value);
					params.push(encodeURIComponent(document.getElementById("commentaire").value));

					if (document.getElementById("crea_lieu").value == "autre" && document.getElementById("crea_lieu_autre_input").value != "") {
						params.push(encodeURIComponent("Autre - " + document.getElementById("crea_lieu_autre_input").value));
					} else {
						params.push(document.getElementById("crea_lieu").value);
					}

					params.push(str_type_rdv);
					params.push(document.getElementById("nature").options[document.getElementById("nature").selectedIndex].value);


					if (document.getElementById("crea_motif").value == "autre" && document.getElementById("crea_motif_autre_input").value != "") {
						params.push(encodeURIComponent("Autre - " + document.getElementById("crea_motif_autre_input").value));
					} else {
						params.push(document.getElementById("crea_motif").value);
					}


					if (document.getElementById("crea_ressource") != null) {
						params.push(document.getElementById("crea_ressource").options[document.getElementById("crea_ressource").selectedIndex].value);
					} else {
						params.push("");
					}

					var user_assigned_id = "";
					if (document.getElementById("user_id") != null && document.getElementById("user_id").options[document.getElementById("user_id").selectedIndex].value != "") {
						var user_assigned_id = "&user_assigned_id=" + document.getElementById("user_id").options[document.getElementById("user_id").selectedIndex].value;
					}

					if (document.getElementById("accompagnants") != null) {
						params.push(encodeURIComponent(document.getElementById("accompagnants").value));
					} else {
						params.push("");
					}

					// Individu
					params.push(document.getElementById("date_naissance_recherche").value);
					params.push(document.getElementById("email_recherche").value);
					params.push(document.getElementById("btn-notif-mail").getAttribute("data-notif"));
					params.push(document.getElementById("tel").value);
					params.push(document.getElementById("btn-notif-tel").getAttribute("data-notif"));

					params.push(document.getElementById("date_naissance_recherche").value);
					params.push(document.getElementById("adr-num").value);
					params.push(document.getElementById("adr-street").value);
					params.push(document.getElementById("adr-bat").value);
					params.push(document.getElementById("adr-lieu").value);
					params.push(document.getElementById("code-postal").value);
					params.push(document.getElementById("commune").value);


					var user_id = document.getElementById("current_user").value;
					var tab_param = "";
					for (let i = 0; i < params.length; i++) {
						if (i == 0) {
							tab_param += params[i];
						} else {
							tab_param += "|" + params[i];
						}
					}

					var par = "params=" + encodeURIComponent(tab_param) + "&methode=rdv_save&meeting_id=" + id_meeting_send + "&user_id=" + user_id + user_assigned_id + String(id_individu);

					mise_a_jour(par);

					if (resultat != "TMP" && resultat != "error" && resultat != "") {

						setTimeout(function () { window.location.reload(); }, 0);

						document.getElementById("modale_creation").style.display = "none";

						if (document.getElementById("meeting_id").value == "") {
							document.getElementById("meeting_id_2").value = "";
						}

						reset();
						sessionStorage.setItem('goToDate', elm_date_debut);;

					} else {
						errors(resultat);
					}


				} else {
					errors(bool_send);
				}
			}
			//}

		} else {
			alert("Veuillez saisir les champs obligatoires");
		}

	} else {
		document.getElementById("date_debut").style = "border:2px solid #FB434F !important;";
		alert("Veuillez sélectionner une date de rendez-vous");
	}
}


///
/// Gestions des informations du Meeting et créneau
///

function errors(message) {

	if (message == false) {


		if (!verification_duree_tmp()) {
			alert("Durée de réservation du créneau dépassée.");
		} else if (!verification_dispo_rendez_vous()) {
			alert("Ce créneau n'est plus disponible.");
		} else {
			alert("Une erreur s'est produite. (1)");
		}


	} else if (message == "TMP") {

		alert("Durée de réservation du créneau dépassée.");

	} else if (message == "error") {

		//console.log("resultat :: fail :: error")
		//console.log(message)
		alert("Une erreur s'est produite. (2)");

	} else {

		//console.log("resultat :: fail :: autre")
		//console.log(message)
		alert("Une erreur s'est produite. (3)");

	}

	jquery("#calendrier").fullCalendar("refetchEvents");
	document.getElementById("date_debut").value = "";
	document.getElementById("meeting_id_2").value = "";
	document.getElementById("meeting_id").value = "";
}




function mise_a_jour(params) {

	// Initialisation de l'entrypoint
	var xhr = null;
	if (window.XMLHttpRequest || window.ActiveXObject) {
		if (window.ActiveXObject) {
			try {
				xhr = new ActiveXObject("Msxml2.XMLHTTP");
			} catch (e) {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			}
		} else {
			xhr = new XMLHttpRequest();
		}
	} else {
		alert("Votre navigateur ne supporte pas l objet XMLHTTPRequest.");
		return;
	}

	var url = "/index.php?entryPoint=agenda_visualisation";

	xhr.open("POST", url, false);

	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onreadystatechange = traitementRetour;
	xhr.send(params);


	function traitementRetour() {

		if (xhr.readyState == 4 && xhr.status == 200) {
			resultat = xhr.responseText;
			resultat = resultat.replace(/\n|\r/g, "");
		} else {

			alert("Une erreur s'est produite. (7)");
		}
	}
}


// Suppression du rdv temporaire
function suppression_rdv_tmp() {
	if (document.getElementById("meeting_id_2").value != "") {
		var params = "methode=rdv_suppr&meeting_id=" + document.getElementById("meeting_id_2").value + "&user_id=" + document.getElementById("current_user").value;
		mise_a_jour(params);
	}
}


// TEST JS RDV TMP
function verification_duree_tmp() {

	var date_rdv_save = new Date();
	var differenceMin = Math.floor((date_rdv_save - date_rdv_tmp) / (1000 * 60));
	var agenda_duree_tmp = document.getElementById("agenda_duree_tmp").value;


	if (differenceMin <= agenda_duree_tmp || rdv_modif == true) {
		date_rdv_tmp = "";
		return true;
	}


	date_rdv_tmp = "";
	return false;
}


// TEST CRENO
function verification_dispo_rendez_vous() {

	if (document.getElementById("date_debut").value != "") {
		if (actualisation != "") {
			clearTimeout(actualisation);
		}

		//Mise en place de la vérification aléatoire 
		num_aleatoire_mms = getRandomInt(5000, 9000);
		var actualisation = setTimeout("verification_dispo_rendez_vous();", num_aleatoire_mms);

		// Mise en place du contrôle de disponibilité du RDV
		var params = new Array();
		var id_meeting = document.getElementById("meeting_id").value;
		var id_meeting_2 = document.getElementById("meeting_id_2").value;

		params.push(document.getElementById("crea_motif").options[document.getElementById("crea_motif").selectedIndex].value);
		params.push(document.getElementById("visua_agenda").value);
		params.push(document.getElementById("date_debut").value);

		var user_id = document.getElementById("current_user").value;

		var tab_param = "";
		for (var i = 0; i < params.length; i++) {
			if (i == 0) {
				tab_param += params[i];
			} else {
				tab_param += "|" + params[i];
			}
		}

		var par = "params=" + tab_param + "&methode=creneaux_verification&meeting_id=" + id_meeting + "&meeting_id_2=" + id_meeting_2 + "&user_id=" + user_id;
		par += "&lieu_id=" + document.getElementById("crea_lieu").value + "&individu_id=" + document.getElementById("id_individu_trouve_id").value;


		mise_a_jour(par);
		var result = resultat.replace(/ /gi, "");

		if (resultat == false) {
			alert("Ce rendez-vous n'est plus disponible");
			jquery("#calendrier").fullCalendar("refetchEvents");
			document.getElementById("date_debut").value = "";

			suppression_rdv_tmp();
			resultat = "";

			return false;

		} else if (result == "surbooking") {

			suppression_rdv_tmp();

			alert("Ce rendez-vous n'est plus disponible");
			jquery("#calendrier").fullCalendar("refetchEvents");
			document.getElementById("date_debut").value = "";
			document.getElementById("meeting_id_2").value = "";
			return false;
		} else {
			return true;
		}
	}
}


function getRandomInt(min, max) {
	min = Math.ceil(min);
	max = Math.floor(max);

	return Math.floor(Math.random() * (max - min)) + min;
}




///
/// Gestions de l'affichage de la modale
///

/** 
 * Réinitialisation de la modale de prise de RDV
*/
function reset() {


	$('#modale_agenda').show();
	// Gestion des bordures
	var collection_champ_obl = document.getElementsByClassName('obligatoire');
	for (var i = collection_champ_obl.length - 1; i >= 0; i--) {
		collection_champ_obl[i].style = "";
	}

	show_tab_agenda("details");
	jquery(".head_agenda_tab a[rel='calendar'].btn_agenda_tab").show();

	// Gestion hors plage ouverture
	type_rdv = "";

	if (gestion == 1) {
		$(".fc-createRDV-button").show();
	}
	document.getElementById("btns_actions").style.marginTop = "-20px";


	modification_hors_plage = false;
	document.getElementById("date_debut").style = "";
	$("#modifier_rdv_hors_plage").remove();

	if (document.getElementById("overlay-calendar") != null) {
		document.getElementById("overlay-calendar").remove();
	}

	if (document.getElementById("crea_ressource") != null) {
		document.getElementById("crea_ressource").disabled = false;
	}

	reset_champs("recherche");

	document.getElementById("crea_lieu").querySelector("option[value='']").selected = true;
	document.getElementById("crea_lieu_autre_input").value = "";
	document.getElementById("crea_motif_autre_input").value = "";
	document.getElementById("crea_motif_autre").style.display = "none";

	suppression_rdv_tmp();

	document.getElementById("calendrier").style = "display:block";
	document.getElementById("crea_motif").options[0].selected = "true";
	document.getElementById("meeting_id").value = "";
	document.getElementById("meeting_id_2").value = "";
	document.getElementById("date_debut").value = "";
	document.getElementById("date_fin").value = "";
	document.getElementById("tel").value = "";
	document.getElementById("usager").value = "";
	document.getElementById("commentaire").value = "";
	document.getElementById("canal").value = "guichet";
	document.getElementById("presence").options[0].selected = "true";
	document.getElementById("dossier_id").value = "";
	document.getElementById("create_by_rdv").style.display = "none";
	document.getElementById("nature").value = "";
	document.getElementById("canal_rdv").value = "";
	document.getElementById("container_hors_plage").style.display = "none";
	document.getElementById("type_rdv").checked = false;
	document.getElementById("tel").style = "border: 1px solid #DDDDDD;";

	if (document.getElementById("accompagnants") != null) {
		document.getElementById("accompagnants").value = "";
		$('input[name=usager_concerne]').val('');
	}

	if (document.getElementById("crea_ressource") != null) {
		document.getElementById("crea_ressource").options[0].selected = "true";
	}

	if (document.getElementById("user_id") != null) {
		document.getElementById("user_id").options[user_default_index].selected = "true";
	}

	// Restore all event cell to default : remove 'active' classname on each
	jQuery(".fc-widget-content").find(".fc-event").removeClass("active");

	var eventArray = document.getElementsByClassName("fc-event-container");
	for (var i = 0; i < eventArray.length; i++) {
		eventArray[i].className = "fc-event-container";
	}

	resultat = "";

	if (typeof actualisation != "undefined") {
		clearTimeout(actualisation);
	}


	// Dossier back
	document.getElementById("dossier_back_btns").style.display = "none";

	if (document.getElementById("create_dossier") != null) {
		document.getElementById("create_dossier").style.display = "none";
	}

	if (document.getElementById("view_dossier") != null) {
		document.getElementById("view_dossier").style.display = "none";
	}

	// Dossier front
	if (document.getElementById("view_dossier_front") != null) {
		document.getElementById("view_dossier_front").style.display = "none";
	}


	// Demandeur notifs
	if (document.getElementById("btn-notif-tel") != null) {
		document.getElementById("btn-notif-tel").classList.remove('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
		document.getElementById("btn-notif-tel").classList.add('fa-bell', 'fa-solid', 'btn-notif-activate');
		document.getElementById("btn-notif-tel").setAttribute("data-notif", true);
	}

	if (document.getElementById("btn-notif-mail") != null) {
		document.getElementById("btn-notif-mail").classList.remove('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
		document.getElementById("btn-notif-mail").classList.add('fa-bell', 'fa-solid', 'btn-notif-activate');
		document.getElementById("btn-notif-mail").setAttribute("data-notif", true);
	}


	if(document.getElementById("btns_individu")!= null){

		document.getElementById("btns_individu").style.display = "block";
	}
	document.getElementById('rechercher').style.display = "block";
	if (document.getElementById("vider") != null) {
		document.getElementById("vider").style.display = 'block';
	}

	// Gestion Rdv enregistre par
	document.getElementById("create_by_name").value = "";
	document.getElementById("create_by_date").value = "";
	document.getElementById("create_by_rdv").style.display = "none";

	rdv_action = "creation";
	jquery('#calendrier').fullCalendar('refetchEvents');

	$("#crea_motif").val(motif_id_defaut);
}


/**
 * Affiche l'onglet de la modale de Création de RDV demandé (detail, calendrier, historique)
 * @param {string} tab 
 * @param {*} display 
 */
function show_tab_agenda(tab, display = "show") {
	jquery("[role='fieldset_agenda']").hide();
	jquery("[role='fieldset_agenda'][rel='" + tab + "']").show();

	jquery(".head_agenda_tab a[rel].btn_agenda_tab").removeClass("active");
	jquery(".head_agenda_tab a[rel='" + tab + "'].btn_agenda_tab").addClass("active");
	jQuery("#calendrier").fullCalendar("refetchEvents");
}


/**
 * Tri des listes
 * @param {*} node 
 */
function sort_list(node) {
	if (document.getElementById(node) != null) {
		const optionNodes = Array.from(document.getElementById(node).children);
		optionNodes.sort((a, b) => {
			if (a.value != "" && b.value != "") {
				return a.text.toLowerCase() < b.text.toLowerCase() ? -1 : 1
			}

		}

		);
		optionNodes.forEach((option) =>
			document.getElementById(node).appendChild(option)
		);
	}
}


/**
 * Reset de modification Hors Plage
 */
function reset_modifier() {
	modification_hors_plage = false;

	if (gestion == 1) {
		$(".fc-createRDV-button").show();
	}

	document.getElementById("modale_creation").style.display = "block";
	$("#overlay-calendar").remove();
}


/**
 * Affiche le calendrier de prise de rdv pour le Hors Plage
 */
function modifier_rdv_hors_plage() {
	modification_hors_plage = true;
	var toolbar = '<div id="overlay-calendar" onclick="reset_modifier()" style="position: absolute;top: 0;left: 0;right: 0;bottom: 0;display: block;background-color: #fcfcfce3;">';
	toolbar += '<div class="button_modification_rdv_hors_plage" style="text-align: end;">';
	toolbar += '<input title="Annuler" onclick="reset_modifier()" class="button" type="submit" name="methode" value="Annuler" id="annuler_rdv_hors_plage" style="float: right;margin-left: 10px;">';
	toolbar += '<h2 style="line-height: 42px;">Modification : ';
	toolbar += $("#usager").val() + " le " + $("#date_debut").val() + "</h2></div></div>";

	$(".fc-createRDV-button").hide();
	$("#calendar").find(".fc-toolbar.fc-header-toolbar").before($(toolbar));
	document.getElementById("modale_creation").style.display = "none";

	var eventArray = document.getElementsByClassName("fc-event-container");
	for (var i = 0; i < eventArray.length; i++) {
		eventArray[i].className += " modif_agenda_taille";
	}
}




/// 
///  Gestions de l'individu à la savegarde d'un rdv
///

/**
 * Récupération des params néccessaires à la création de l'individu
 * @returns result
*/
function create_individu() {

	var civilite_create = document.getElementById("civilite_recherche").value;
	var last_name_create = document.getElementById("last_name_recherche").value;
	var first_name_create = document.getElementById("first_name_recherche").value;
	var date_naissance_create = document.getElementById("date_naissance_recherche").value;
	var tel_create = document.getElementById("tel").value;
	var email_create = document.getElementById("email_recherche").value;
	var type_create = document.getElementById("type_individu_recherche").value;
	var usage_create = document.getElementById("nom_usage_recherche").value;
	var adr_num = document.getElementById("adr-num").value;
	var adr_str = document.getElementById("adr-street").value;
	var adr_bat = document.getElementById("adr-bat").value
	var adr_lieu = document.getElementById("adr-lieu").value;
	var adr_commune = document.getElementById("commune").value;
	var adr_cp = document.getElementById("code-postal").value;

	var indi_params = new Array();
	indi_params.push(civilite_create);
	indi_params.push(last_name_create);
	indi_params.push(first_name_create);
	indi_params.push(date_naissance_create);
	indi_params.push(tel_create);
	indi_params.push(email_create);
	indi_params.push(type_create);
	indi_params.push(usage_create);
	indi_params.push(adr_num);
	indi_params.push(adr_str);
	indi_params.push(adr_bat);
	indi_params.push(adr_lieu);
	indi_params.push(adr_cp);
	indi_params.push(adr_commune);

	var tab_param = "";
	for (var i = 0; i < indi_params.length; i++) {
		if (i == 0) {
			tab_param += indi_params[i];
		} else {
			tab_param += "|" + indi_params[i];
		}
	}

	var obj_params = "params=" + tab_param;

	var result = action_creation_individu(obj_params);

	return result;
}


/**
 * Création de l'individu par l'entrypoint agenda_creation_individu
 * @param string obj_params
 * @return json
 */
function action_creation_individu(obj_params) {
	// initialisation de l'entrypoint

	var xhr = null;
	if (window.XMLHttpRequest || window.ActiveXObject) {
		if (window.ActiveXObject) {
			try {
				xhr = new ActiveXObject("Msxml2.XMLHTTP");
			} catch (e) {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			}
		} else {
			xhr = new XMLHttpRequest();
		}
	} else {
		alert("Votre navigateur ne supporte pas l objet XMLHTTPRequest.");
		return;
	}

	var url = "/index.php?entryPoint=agenda_creation_individu";
	xhr.open("POST", url, false);
	xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	xhr.onreadystatechange = traitementRetour;
	xhr.send(obj_params);

	function traitementRetour() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			indi_Result = xhr.responseText;
		} else {
			alert("Une erreur s'est produite. (8)");
		}
	}
}



/**
 * Verification du format du tel
 * @returns boolean
 */
function validate_tel() {
	// Vérification de la longueur du champ téléphone si non nul et si il ne contient pas d'underscore (maskedinput)
	if ((document.getElementById("tel").value != "" && document.getElementById("tel").value.length != 14) || document.getElementById("tel").value.includes("_")) {
		document.getElementById("tel").style = "border:2px solid #FB434F !important;";
		return false;
	}

	document.getElementById("tel").style = "border: 1px solid #DDDDDD;";

	return true;
}



/**
 * Verification du format de date
 * @returns boolean
 */
function validate_date_naissance() {
	var date_naissance_control = document.getElementById("date_naissance_recherche").value;

	// Vérification de la longueur du champ téléphone si non nul
	if (date_naissance_control != "" && date_naissance_control.length != 10) {
		date_naissance_control.style = "border:2px solid #FB434F !important;";
		alert("format de la date de naissance non valide");
		return false;
	}

	date_naissance_control.split("/");
	date_naissance_control.style = "border: 1px solid #DDDDDD;";

	return true;
}



/**
 * Verification du format du mail
 * @returns boolean
 */
function validate_mail() {

	var email = document.getElementById("email_recherche").value;
	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

	if (re.test(email)) {
		document.getElementById("email_recherche").style = "border-color: #a5e8d6; border-style: solid; border-radius: 4px;";
		return true;
	}

	document.getElementById("email_recherche").style = "border:2px solid #FB434F !important;";
	alert("Adresse e-mail non valide");

	return false;
}


/**
 * Gestion du changement d'activation des notifications
 */
function change_notif(event) {

	idElm = event.target.id;
	boolNotifActivate = !(event.target.getAttribute("data-notif") === "true");
	document.getElementById(idElm).setAttribute("data-notif", boolNotifActivate);

	if (boolNotifActivate) {
		document.getElementById(idElm).classList.remove('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
		document.getElementById(idElm).classList.add('fa-bell', 'fa-solid', 'btn-notif-activate');

	} else {
		document.getElementById(idElm).classList.remove('fa-bell', 'fa-solid', 'btn-notif-activate');
		document.getElementById(idElm).classList.add('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
	}
}