jQuery(document).ready(function () {

    var class_champ_titre = document.getElementsByClassName("champ_titre");

    // Assignation par defaut required
    addToValidate("EditView", 'assigned_user_name', 'varchar', true, 'Assignation par défaut');
    $('#assigned_user_name').closest('.edit-view-row-item').prev('.edit-view-row-item').innerHTML += '<span class=\"required\">*</span>';

    Array.from(class_champ_titre).forEach(element => {

        // Creation element hr & CSS titres
        element.parentNode.closest("div").style = "background-color:transparent!important;border:none!important;";
        var hr = document.createElement('hr');
        hr.style = "border-top: 1px solid #534d64; margin-top: 0;";
        element.parentNode.closest("div").appendChild(hr);

        // Suppression du noeud label associé
        var node_label = element.parentNode.previousElementSibling;
        if (node_label != null && node_label.hasAttribute("data-label") && node_label.className.includes("label")) {
            node_label.remove();
        }
    });

    
    var div_glissements_debut = jQuery("#jours_glissement_debut").parents();
    var div_glissements_fin = jQuery("#jours_glissement_fin").parents();
    var div_date_debut = jQuery("#date_debut").parents();
    var div_date_fin = jQuery("#date_fin").parents();


    // Gestion de l'affichage du glisssement date de début
    if (document.getElementById("souhait_glissement_debut").checked) {

        div_glissements_debut[1].style.display = 'block';
        div_glissements_debut[1].style.visibility = 'visible';
        div_date_debut[2].style.visibility = 'hidden';

        removeFromValidate("EditView", 'date_debut');
        addToValidate("EditView", 'jours_glissement_debut', 'int', true, 'Nombre de jours de glissement pour le début');

    } else {
        div_glissements_debut[1].style.visibility = 'hidden';
        div_date_debut[2].style.visibility = 'visible';
        div_date_debut[2].style.display = 'block';

        addToValidate("EditView", 'date_debut', 'date', true, 'Date de début');
        removeFromValidate("EditView", 'jours_glissement_debut');
    }

    // Gestion de l'affichage du glisssement date de fin
    if (document.getElementById("souhait_glissement_fin").checked) {
        div_glissements_fin[1].style.display = null;
        div_date_fin[2].style.display = 'none';

        removeFromValidate("EditView", 'date_fin');
        addToValidate("EditView", 'jours_glissement_fin', 'int', true, 'Nombre de jours de glissement pour la fin');

    } else {
        div_glissements_fin[1].style.display = 'none';
        div_glissements_fin[1].style.visibility = 'hidden';
        div_date_fin[2].style.display = 'block';

        addToValidate("EditView", 'jours_glissement_fin', 'int', true, 'Nombre de jours de glissement pour la fin');
        removeFromValidate("EditView", 'jours_glissement_fin');
    }

    // Event de l'affichage du glissement date de debut 
    document.getElementById("souhait_glissement_debut").onchange = function () {
        if (jQuery('#souhait_glissement_debut').is(':checked') == true) {

            div_glissements_debut[1].style.display = 'block';
            div_glissements_debut[1].style.visibility = 'visible';
            div_date_debut[2].style.visibility = 'hidden';

            jQuery("#date_debut").val("");
            document.getElementById("jours_glissement_debut").value = "0";

            removeFromValidate("EditView", 'date_debut');
            addToValidate("EditView", 'jours_glissement_debut', 'int', true, 'Nombre de jours de glissement pour le début');
        } else {

            div_glissements_debut[1].style.visibility = 'hidden';
            div_date_debut[2].style.visibility = 'visible';
            div_date_debut[2].style.display = 'block';

            jQuery("#jours_glissement_debut").val("0");
            document.getElementById("jours_glissement_debut").value = "0";

            addToValidate("EditView", 'date_debut', 'date', true, 'Date de début');
            removeFromValidate("EditView", 'jours_glissement_debut');

        }
    }

    document.getElementById("souhait_glissement_fin").onchange = function () {
        if (jQuery('#souhait_glissement_fin').is(':checked') == true) {

            div_glissements_fin[1].style.display = 'block';
            div_glissements_fin[1].style.visibility = 'visible';
            div_date_fin[2].style.display = 'none';

            jQuery("#date_fin").val("");
            document.getElementById("jours_glissement_debut").value = "0";

            removeFromValidate("EditView", 'date_fin');
            addToValidate("EditView", 'jours_glissement_fin', 'int', true, 'Nombre de jours de glissement pour la fin');
        } else {

            div_glissements_fin[1].style.display = 'none';
            div_glissements_fin[1].style.visibility = 'hidden';
            div_date_fin[2].style.display = 'block';

            jQuery("#jours_glissement_fin").val("0");
            document.getElementById("jours_glissement_fin").value = "0";

            addToValidate("EditView", 'date_fin', 'date', true, 'Date de fin');
            removeFromValidate("EditView", 'jours_glissement_fin');
        }
    }

});