$(document).ready(function () {
    /* On ajoute la div des filtres du module OPS_dispositif dans le panel "Filtres" */
    let div_filtres = document.getElementById('filtres-container');
    let div_filtres_dispositifs = document.getElementById('filtres_dispositifs');
    div_filtres.append(div_filtres_dispositifs);

    /* On déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné  */
    on_objet_change_dispositifs();

    /* Si l'objet est modifié, on déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné */
    $('#dashlet_objet').change(function () {
        on_objet_change_dispositifs()
    });

    jQuery('#filtres_dispositifs div[id^="checkboxes_"] input[type=checkbox]').each(function () {
        if (this.checked) {
            $('#' + this.id).prop("checked", true);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        } else {
            $('#' + this.id).prop("checked", false);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        }
    });
});

/**
 * Fonction vérifiant le type d'objet sélectionné pour afficher les filtres et le sélecteur de colonnes correspondants
 * 
 * @return {void}
 */
var on_objet_change_dispositifs = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet == 'OPS_dispositif') {
        $('#filtres_dispositifs').show();
        $('#filtres_dispositifs *').prop('disabled', false);
        $('#li-filtres').show()
    } else {
        $('#filtres_dispositifs').hide();
        $('#filtres_dispositifs *').prop('disabled', true);
    }
}