<?php

use ODE\Helper\OdeArrayHelper;
use ODE\Model\DossierModel;
use Datetime;
use ODE\Model\GenerateurReferentielModel;
use ODE\Helper\OdePdfHelper;
use TCPDF;

require_once 'include/MassUpdate.php';

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class OPS_dossierController extends SugarController
{

    
    public function action_EditionView()
    {
        $this->view = 'edition';
    }

    public function action_GestionView()
    {
        $_GET['GestionView'] = true;
        $this->view = 'gestion';
    }
    


    /**
     * @access public
     * action_new_create()
     * Fonction qui crée un dossier
     *
     */
    function action_createDossier()
    {

        $libelle_erreur = "";
        do {

            $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = $data_verified['data'];
                break;
            } else {
                $champs_formulaire = $data_verified['data']['json_array'];
            }

            $dossier_id = OPS_dossier::createDossier($champs_formulaire);
        } while (0);

        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossier_id) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_new_create()
     * Fonction qui crée un dossier
     *
     */
    function action_updateDossier()
    {

        $libelle_erreur = "";
        do {

            $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = $data_verified['data'];
                break;
            } else {
                $champs_formulaire = $data_verified['data']['json_array'];
            }

            if (empty($champs_formulaire["dossier_id"])) {
                $libelle_erreur = "Le dossier n'a pas pu etre récupéré";
                break;
            } else {
                $dossier_id = $champs_formulaire["dossier_id"];
                unset($champs_formulaire["dossier_id"]);
                
                $champs_formulaire["brouillon"] = "non";
                $retour_update = OPS_dossier::updateDossier($champs_formulaire, $dossier_id);
            }
        } while (0);

        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $retour_update) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_initForm()
     * Fonction qui renvoie les données necessaires pour initialiser le formulaire de création d'un dossier
     *
     * @return json     $data
     */
    function action_initForm()
    {

        $onglets = false;
        $libelle_erreur = "";
        $params = array();
        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array(
            "dispositif_id" => true,
            "demandeur_type" => true,
        );

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            // On récupere le dispositif séléctionné
            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $data_verified['data']['dispositif_id']);
            if (!empty($obj_dispositif->id)) {

                $liste_thematique = OPS_dispositif::getListeThematique($obj_dispositif->thematique);
                if ($liste_thematique !== false) $params['liste_thematique'] = $liste_thematique;

                // On récupere la vue associé au dispositif
                $vues = $obj_dispositif->get_linked_beans('ops_generateur_vue_ops_dispositif', 'OPS_generateur_vue');

                // On récupere la liste des onglets et champs de la vue
                $onglets = (is_array($vues) && count($vues) == 1) ? $vues[0]->getListOnglets() : false;

                // Si le dispositif n'est pas associé à une vue ou associé à plusieurs vues on retourne une erreur
                $libelle_erreur = (is_array($vues) && count($vues) !== 1) ? count($vues) . " vue(s) sont associée(s) au dispositif " . $obj_dispositif->name : "";
            } else {
                $libelle_erreur = "Dispositif inconnu";
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }
        
        // Si les onglets et les champs on bien été récupéré, on retourne les onglets sinon le libellé de l'erreur
        $data = ($onglets !== false) ? array('statut' => 'ok', 'data' => array('onglets' => $onglets, 'params' => $params)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_addDossier()
     * Fonction qui crée le dossier le Opensub, renvoie l'id du dossier crée sinon le libellé de l'erreur
     *
     * @return json     $data
     */
    function action_addDossier()
    {

        $creation_dossier = false;
        $libelle_erreur = "";

        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array(
            "json" => true,
            "dispositif_id" => true,
            "type_tiers" => true,
        );

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);

        if ($data_verified['statut'] == 'ok') {
            // On récupere les champs du formulaire et leurs valeurs
            $champs_formulaire = $this->getChampsFromJson($data_verified['data']['json_array']);

            // On ajoute le type_tiers aux données du formulaire
            if (is_array($champs_formulaire) && count($champs_formulaire) > 0) {
                $champs_formulaire['type_tiers'] = $data_verified['data']['type_tiers'];
            }
            // On crée le dossier
            $creation_dossier = OPS_dossier::createDossier($champs_formulaire);
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si le dossier a bien été crée on retourne l'id sinon le libellé de l'erreur
        $data = ($creation_dossier !== false) ? array('statut' => 'ok', 'data' => array('id' => $creation_dossier)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access private
     * @name getChampsFromJson()
     * Fonction qui retourne le tableau des champs du formulaire
     *
     *  @param array                $json_array : Tableau des données du Json
     *  @return array               $btn_onglets_html : Tableau des champs du formulaire
     */
    private function getChampsFromJson($json_array)
    {
        $champs = array();
        foreach ($json_array as $id_onglet => $onglet) {
            foreach ($onglet as $id_ligne => $ligne) {
                foreach ($ligne as $id_champ => $champ) {
                    if (!empty($champ['id'])) {
                        $champs[$champ['id']] =  $champ['value'];
                    }
                }
            }
        }
        return $champs;
    }



    /**
     * @access private
     * @name createDossier()
     * Fonction qui génére les boutons d'onglets
     *
     *  @param array            $onglets : la liste des onglets rattaché à la vue
     *  @return string          $btn_onglets_html : code html , les boutons sont groupés dans une div
     */
    private function updateDossier($dossier, $dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        foreach ($dossier['basic'] as $champ_name => $champ_value) {
            if (is_array($champ_value)) {
                if (!empty($champ_value['type']) && $champ_value['type'] == "relation") {
                    $obj = BeanFactory::getBean($champ_value['module_name'], $champ_value['module_id']);
                    if (!empty($obj->id)) {
                        $obj->load_relationship($champ_value['relation_name']);
                        $obj->{$champ_value['relation_name']}->add($dossier_id);
                    }
                }
            } else {
                $obj_dossier->$champ_name = $champ_value;
            }
        }
        return ($obj_dossier->save()) ? $dossier_id : false;
    }

    /**
     * @access public
     * action_editDossier()
     * Fonction pour modifier un dossier
     *
     * @return json     $data
     */
    function action_editDossier()
    {

        $update_dossier = false;
        $libelle_erreur = "";

        // Liste des champs à vérifier, true si c'est obligatoire
        $champs = array(
            "json" => true,
            "dossier_id" => true,
        );

        // Vérification des données recus dans  $_REQUEST
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);

        if ($data_verified['statut'] == 'ok') {
            // On récupere les champs du formulaire et leurs valeurs
            $champs_formulaire = $data_verified['data']['json_array'];;
            // On edit le dossier
            $update_dossier = OPS_dossier::editDossier($data_verified['data']['dossier_id'], $champs_formulaire);
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si le dossier a bien été modifié on retourne l'id sinon le libellé de l'erreur
        $data = ($update_dossier !== false) ? array('statut' => 'ok', 'data' => array('id' => $update_dossier)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_duplicateDossier()
     * Fonction pour dupliquer un dossier et redirige vers le nouveau dossier
     *
     * @return json     $data
     */
    function action_duplicateDossier()
    {

        $libelle_erreur = "";

        // Liste des champs à vérifier, true si c'est obligatoire
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        if ($data_verified['statut'] === "err") {
            $libelle_erreur = $data_verified['data'];
        } else {
            $dossier_id = $data_verified['data']['json_array']["dossier_id"];
            $is_dossier_lie = $data_verified['data']['json_array']["is_dossier_lie"];

            $obj_dossier_id = OPS_dossier::duplicateDossier($dossier_id);

            if($is_dossier_lie && !empty($obj_dossier_id) && $obj_dossier_id !== false)
            {
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                $obj_dossier->load_relationship('ops_dossier_ops_dossier');
                $obj_dossier->ops_dossier_ops_dossier->add($obj_dossier_id);
            }

        }

        // Si le dossier a été dupliqué => on retourne l'id du dossier sinon le libéllé de l'erreur
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => array('id' => $obj_dossier_id)) : array('statut' => 'err', 'data' => $libelle_erreur);
        
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_deleteDossier()
     * Fonction pour supprime un dossier et redirige à la vue liste dossiers
     *
     * @return json     $data
     */
    function action_deleteDossier()
    {

        $libelle_erreur = "";

        // Liste des champs à vérifier, true si c'est obligatoire
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        if ($data_verified['statut'] === "err") {
            $libelle_erreur = $data_verified['data'];
        } else {
            $dossier_id = $data_verified['data']['json_array']["dossier_id"];
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            // On supprimer le dossier
            if (!empty($obj_dossier->id)) {
                $obj_dossier->mark_deleted($obj_dossier->id);
                if (!$obj_dossier->save()) {
                    $libelle_erreur = "Echec de la suppression du dossier id = " . $dossier_id;
                }
            }
        }

        // Si le dossier à été supprimer => on retourne l'id du dossier sinon le libéllé de l'erreur
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => array('id' => $obj_dossier->id)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_editStatut()
     * Fonction pour modifier un dossier
     *
     * @return json     $data
     */
    function action_editStatut()
    {

        $libelle_erreur = "";
        $statut_updated = false;

        // Vérification des données recus dans  $_REQUEST
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        if ($data_verified['statut'] === "err") {
            $libelle_erreur = $data_verified['data'];
        } else {
            $dossier_id = $data_verified['data']['json_array']["dossier_id"];
            $statut_id = $data_verified['data']['json_array']["statut_id"];
            // On récupere le dossier
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            if (!empty($obj_dossier->id)) {
                $statut_updated = $obj_dossier->updateStatut($statut_id);
            } else {
                $libelle_erreur = "Echec de la modification du statut du dossier.";
            }
        }

        // Si le statut a bien été mis à jour on retourne l'id du dossier sinon  vers le libellé de l'erreur
        $data = ($statut_updated !== false) ? array('statut' => 'ok', 'data' => array('id' => $obj_dossier->id)) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_recherche_individu()
     * Fonction pour rechercher un individu
     *
     * @return json     $data
     */
    function action_recherche_individu(){
        global $db;    

        $listeIndividu = array();
        if(!empty($_REQUEST['array_champs'])){

            foreach($_REQUEST['array_champs'] as $key => $value){


                $key = str_replace("_beneficiaire", "", $key);

                switch($key){
                    case 'telephone':
                        if($value != ""){
                            $value = str_replace('.', ' ', $value);
                            $key = 'phone_mobile';
                            if(empty($where)){
                                $where = " UPPER(TRIM(REPLACE( REPLACE( REPLACE( REPLACE( ops_individu." . $key . ", '_', ''), ' ', ''), '-', ''), '.', ''))) LIKE '%". $db->quote( strtoupper (str_replace(" ", "", $value) ) ) ."%' ";
                            }else{
                                $where .= " AND UPPER(TRIM(REPLACE( REPLACE( REPLACE( REPLACE( ops_individu." . $key . ", '_', ''), ' ', ''), '-', ''), '.', ''))) LIKE '%". $db->quote( strtoupper (str_replace(" ", "", $value) ) ) ."%' ";
                            }
                            continue 2;
                        }
                        break;
                    case 'date_naissance':
                        if( substr($value, 2 , 1) == "/" ){
                            $value = implode('-', array_reverse(explode('/', $value))); 

                        }
                        break;
                    default:
                        break;
                }

                if($key == 'email' && !empty($value) ){
                    $search_email=$value;
                    continue;
                }
                elseif ($key=="email") {
                    $search_email=false;
                    continue;
                }

                if($key == 'type_individu')
                {
                    if(!empty($where)){
                        $where .= " AND ";
                    }

                    $value_array = explode(',', $value);

                    $value = [];
                    foreach($value_array as $val)
                    {
                        $value[] = "'" . $val . "'";
                    }

                    $value = implode(",", $value);

                    $where .= " UPPER(TRIM(REPLACE( REPLACE( REPLACE( ops_individu." . $key . ", '_', ''), ' ', ''), '-', ''))) IN (". strtoupper (str_replace(" ", "", $value) . ")" );
                    continue;
                }

                $value = $this->delete_caractere( $value );

                if($value != ""){
                    if(empty($where)){
                        $where = " UPPER(TRIM(REPLACE( REPLACE( REPLACE( ops_individu." . $key . ", '_', ''), ' ', ''), '-', ''))) LIKE '%". $db->quote( strtoupper (str_replace(" ", "", $value) ) ) ."%' ";
                    }else{
                        $where .= " AND UPPER(TRIM(REPLACE( REPLACE( REPLACE( ops_individu." . $key . ", '_', ''), ' ', ''), '-', ''))) LIKE '%". $db->quote( strtoupper (str_replace(" ", "", $value) ) ) ."%' ";
                    }
                }
            }

            if (  $search_email != false  ) {

                $qry  = "select ops_individu.id from ops_individu
                        inner join email_addr_bean_rel on email_addr_bean_rel.bean_id=ops_individu.id and email_addr_bean_rel.deleted=0
                        inner join email_addresses on email_addresses.id=email_addr_bean_rel.email_address_id and email_addresses.deleted=0
                        where email_addresses.email_address like '%".$search_email."%'
                            and email_addr_bean_rel.primary_address=1
                            and email_addresses.deleted=0";

                $result=$db->query($qry);
                
                $row=$db->fetchByAssoc($result);

                if (!empty($row['id'])){
                    if(empty($where)){
                        $where = " ops_individu.id = '".$row['id']."' ";
                    }else{
                        $where .= " AND ops_individu.id = '".$row['id']."' ";
                    }
                }                
            }

            if($where != ""){

                $where = str_replace('_beneficiaire','',$where);

                $beanIndividu = BeanFactory::getBean('OPS_individu');

                $beanList = $beanIndividu->get_list('last_name',$where,0,16);
    
                foreach($beanList['list'] as $num => $bean){
                    $listeIndividu[$num] = array(
                        'id' => $bean->id,
                        'salutation' => $bean->salutation,
                        'name' => $bean->name,
                        'last_name' => html_entity_decode($bean->last_name, ENT_QUOTES | ENT_XML1, 'UTF-8'),
                        'nom_usage' => html_entity_decode($bean->nom_usage, ENT_QUOTES | ENT_XML1, 'UTF-8'),
                        'first_name' => html_entity_decode($bean->first_name, ENT_QUOTES | ENT_XML1, 'UTF-8'),
                        'date_naissance' => implode('/', array_reverse(explode('-', $bean->date_naissance))),
                        'email' => $bean->emailAddress->getPrimaryAddress($bean),
                        'phone_number' => $bean->phone_mobile,
                    );
                }
            }
        }

        ob_clean();
        echo json_encode($listeIndividu);
        sugar_cleanup(true);
       
    }


    /**
     * @access public
     * action_recherche_individu()
     * Fonction pour rechercher un individu
     *
     * @return json     $data
     */
    function action_recherche_personne_morale(){

        global $db;    
        $listeProfil = array();
        $where = "" ; 
        if(!empty($_REQUEST['array_champs'])){


            foreach($_REQUEST['array_champs'] as $key => $value){

                if($key == 'type' ){

                    if( is_array($_REQUEST['array_champs']['type']) )
                    {
                        $value = "'" ; 

                        $value = implode("', '", $_REQUEST['array_champs']['type']);
                    }

                    $where .= " AND ops_type_personne_ops_personne_morale.ops_type_personne_id in ('".$value."')";

                    continue;
                }

                $value = $this->delete_caractere( $value );

                if($key == 'raison_sociale')$key = 'name';

                if($key == 'numero_uai')$key = 'numero_rne';

                if($value != ""){
                    $where .= " AND UPPER(TRIM(REPLACE( REPLACE( REPLACE( ops_personne_morale." . $key . ", '_', ''), ' ', ''), '-', ''))) LIKE '%". $db->quote( strtoupper ($value) ) ."%' ";
                }
            }

            if($where != ""){

             $requete = $db->query("
                SELECT  ops_personne_morale.id, 
                        ops_personne_morale.name,
                        ops_personne_morale.siret,
                        ops_personne_morale.numero_rna,
                        ops_personne_morale.numero_rne,
                        ops_type_personne.id as id_type,
                        ops_type_personne.name as type_profil
                FROM ops_personne_morale, ops_type_personne_ops_personne_morale, ops_type_personne
                WHERE ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
                AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
                AND ops_personne_morale.deleted = 0
                AND ops_type_personne_ops_personne_morale.deleted = 0
                AND ops_type_personne.deleted = 0
                ".$where."
                ORDER BY `ops_personne_morale`.`name` ASC 
                LIMIT 16");
            
                while ($row = $db->fetchRow($requete)) {

                    $listeProfil[$row['id']] = array(
                        'id' => $row['id'],
                        'raison_sociale' => $row['name'],
                        'type' => $row['id_type'],
                        'siret' => ( !empty( $row['siret'] )? $row['siret'] : ""  ) ,
                        'numero_rna' => ( !empty( $row['numero_rna'] )? $row['numero_rna'] : ""  ) ,
                        'numero_uai' => ( !empty( $row['numero_rne'] )? $row['numero_rne'] : ""  ) ,
                    ); 
                }
            }
        }

        ob_clean();
        echo json_encode($listeProfil);
        sugar_cleanup(true);

    }


    /**
     * @access public
     * action_get_profil()
     * Fonction pour rechercher une liste de  profils associés à un individu
     *
     * @return json     $data
     */
    function action_get_profils(){
        global $db;    


        $retour = array( "statut" => "ko", "datas" => array() );

        $id_individu = $_REQUEST['id_individu']; 

        $type_tiers = $_REQUEST['type_tiers'] ; 

        foreach ($type_tiers as $key => $value) {

            $liste_type .=  "'".$value . "'," ;  

        }

        $liste_type = rtrim($liste_type, ',');

        if( !empty($liste_type) ){
            $where_clause =  "AND ops_type_personne.id in ( ".$liste_type." )" ; 
        } 

        if( !empty($id_individu) ){

            $requete = $db->query("
            SELECT  ops_personne_morale.id, 
                    ops_personne_morale.name,
                    ops_personne_morale.siret,
                    ops_personne_morale.numero_rna,
                    ops_personne_morale.numero_rne,
                    ops_type_personne.id as id_type,
                    ops_type_personne.name as type_profil,
                    ops_personne_morale_individu.responsable
            FROM ops_personne_morale, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu ,ops_personne_morale_individu, ops_type_personne_ops_personne_morale, ops_type_personne
            WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
            AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
            AND ops_individu_ops_personne_morale_individu.ops_individu_id =  '" . $id_individu . "'
            AND ops_type_personne_ops_personne_morale.ops_personne_morale_id = ops_personne_morale.id
            AND ops_type_personne_ops_personne_morale.ops_type_personne_id = ops_type_personne.id
            AND ops_personne_morale.deleted = 0
            AND ops_individu_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
            AND ops_personne_morale_individu.deleted = 0
            AND ops_type_personne_ops_personne_morale.deleted = 0
            AND ops_type_personne.deleted = 0
            ".$where_clause."
            ORDER BY `ops_personne_morale`.`name` ASC ");
        
            while ($row = $db->fetchRow($requete)) {
                $retour['statut'] = "ok";
                $retour['datas'][$row['id']] = $row ; 
            }
        
        }

        ob_clean();
        echo json_encode($retour);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_get_profil()
     * Fonction pour rechercher une liste de  profils associés à un individu
     *
     * @return json     $data
     */
    function action_get_individus(){
        global $db;    


        $retour = array( "statut" => "ko", "datas" => array() );

        $id_objet = $_REQUEST['id_profil']; 

        // Recherche d'une liste d'un individu par un profil 
        if( !empty($id_objet) )
        {
              $requete = $db->query("
                SELECT  ops_individu.id as id,
                        ops_personne_morale_individu.role 
                FROM ops_personne_morale_individu, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu , ops_individu, ops_personne_morale
                WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
                AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
                AND ops_personne_morale_individu.id  = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id
                AND ops_personne_morale_individu.id = ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id
                AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id =  '" . $id_objet . "'
                AND ops_individu_ops_personne_morale_individu.ops_individu_id = ops_individu.id
                AND ops_individu_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_individu.deleted = 0
                AND ops_individu.deleted = 0
                AND ops_personne_morale.deleted = 0
                AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_individu.deleted = 0
                ORDER BY ops_individu.last_name , ops_individu.first_name ");
            
            while ($row = $db->fetchRow($requete)) {
                
                $obj_individu = BeanFactory::getBean('OPS_individu', $row['id']);

                $row['first_name']     = html_entity_decode($obj_individu->first_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
                $row['last_name']     = html_entity_decode($obj_individu->last_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
                $row['date_naissance'] = $obj_individu->date_naissance;
                $row['email']          = $obj_individu->email1;

                $retour['statut'] = "ok";
                $retour['datas'][$row['id']] = $row ;
            }
        
        }

        ob_clean();
        echo json_encode($retour);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_get_profil()
     * Fonction pour rechercher une liste de  profils associés à un individu
     *
     * @return json     $data
     */
    function action_get_individus_by_types(){
        global $db;    


        $retour = array( "statut" => "ko", "datas" => array() );

        $id_objet = $_REQUEST['id_profil']; 
        $type_individu = $_REQUEST['type_individu']; 

        $value_array = explode(',', $type_individu);

        $value = [];
        foreach($value_array as $val)
        {
            $value[] = "'" . $val . "'";
        }
        $type_individu = implode(',', $value);

        // Recherche d'une liste d'un individu par un profil 
        if( !empty($id_objet) )
        {
              $requete = $db->query("
                SELECT  ops_individu.id as id,
                        ops_personne_morale_individu.role 
                FROM ops_personne_morale_individu, ops_individu_ops_personne_morale_individu , ops_personne_morale_ops_personne_morale_individu , ops_individu, ops_personne_morale
                WHERE ops_personne_morale.id = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id 
                AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id = ops_personne_morale_individu.id 
                AND ops_personne_morale_individu.id  = ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_individu_id
                AND ops_personne_morale_individu.id = ops_individu_ops_personne_morale_individu.ops_personne_morale_individu_id
                AND ops_personne_morale_ops_personne_morale_individu.ops_personne_morale_id =  '" . $id_objet . "'
                AND ops_individu_ops_personne_morale_individu.ops_individu_id = ops_individu.id
                AND ops_individu_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_individu.deleted = 0
                AND ops_individu.deleted = 0
                AND ops_personne_morale.deleted = 0
                AND ops_personne_morale_ops_personne_morale_individu.deleted = 0
                AND ops_personne_morale_individu.deleted = 0
                AND ops_individu.type_individu IN (" . $type_individu . ")
                ORDER BY ops_individu.last_name , ops_individu.first_name ");
            
            while ($row = $db->fetchRow($requete)) {
                
                $obj_individu = BeanFactory::getBean('OPS_individu', $row['id']);

                $row['first_name']     = html_entity_decode($obj_individu->first_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
                $row['last_name']     = html_entity_decode($obj_individu->last_name, ENT_QUOTES | ENT_XML1, 'UTF-8');
                $row['date_naissance'] = $obj_individu->date_naissance;
                $row['email']          = $obj_individu->email1;

                $retour['statut'] = "ok";
                $retour['datas'][$row['id']] = $row ;
            }
        
        }

        ob_clean();
        echo json_encode($retour);
        sugar_cleanup(true);
    }


    private function delete_caractere($str){

        $tab_caractere = array( "à" => "a","ä" => "a","Â" => "a","À" => "a","Ä" => "a","ç" => "c","Ç" => "c","é" => "e","è" => "e","ë" => "e","É" => "e","È" => "e","Ë" => "e","î" => "i","ï" => "i","Î" => "i","Ï" => "i","ô" => "o","ö" => "o","Ô" => "o","Ö" => "o","û" => "u","ù" => "u","ü" => "u","Û" => "u","Ù" => "u","Ü" => "u" ,"-" => "","_" => ""," " => "");

        foreach ($tab_caractere as $key => $value) {
           $str =  str_replace($key, $value, $str);
        }

        return $str;

    } 

    /**
     * @access public
     * action_getCustomFields()
     *
     */
    function action_getCustomFields()
    {
        $custom_fields = GenerateurReferentielModel::getCustomFieldListe();
        $data = is_array($custom_fields) && count($custom_fields) > 0 ? ['statut' => 'ok', 'data' => $custom_fields] : ['statut' => 'err', 'data' => []];
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_initChoixFlux()
     * Fonction pour initialiser le formulaire pour lancer un flux en action par lot
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données d'initialisation' ou le libellé de l'erreur
     */
    public function action_initChoixAssignation()
    {
        $resultat = array('erreur' => "");
        $dossiers_selected_ids = array();
        $dossiers_selected_nums = array();

        $data_verified =  $this->getDossiers($_REQUEST);

        if ($data_verified['statut'] == 'ok') {

            $dossiers_ids = array();

            if(isset($data_verified['data']) && is_array($data_verified['data']))
            {
                $dossiers_ids = $data_verified['data'];
            }

            // On récupere le ou les dispositifs associés aux dossiers
            $dispositifs = $this->isValidDispositifs($dossiers_ids);

            if (is_array($dispositifs) && count($dispositifs) === 1) 
            {
                foreach ($dossiers_ids as $dossier_id) 
                {
                    $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                    $dispositifId = $obj_dossier->ops_dispositif_id;
                    $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $dispositifId);
                    $obj_dispositif->load_relationship('ops_habilitation_dispositif_ops_dispositif');
                    $habilitationsID = $obj_dispositif->ops_habilitation_dispositif_ops_dispositif->get();

                    foreach($habilitationsID as $habilitationID)
                    {
                        $obj_habilitation = BeanFactory::getBean('OPS_habilitation_dispositif', $habilitationID);

                        if($obj_habilitation->instruction == 0) continue;

                        $obj_habilitation->load_relationship('ops_habilitation_dispositif_securitygroups');
                        $securityGroupsID = $obj_habilitation->ops_habilitation_dispositif_securitygroups->get(); 
                        
                        foreach ($securityGroupsID as $securityGroupID) 
                        {
                            $obj_security = BeanFactory::getBean('SecurityGroups', $securityGroupID);
                            $members = $obj_security->getMembers();

                            if(is_array($members) && count($members) > 0)
                            {
                                $memberList = [];
                                foreach($members as $member)
                                {
                                    $name = $member['last_name'] . ' ' . $member['first_name'];
                                    $memberList[$member['id']] = $name;
                                }
                                asort($memberList);

                                $resultat['assignation']['securityGroups'][$obj_security->id] = $obj_security->name;
                                $resultat['assignation']['members'][$obj_security->id] = $memberList;
                            }
                        }
                    }


                    if (!empty($obj_dossier->id)) {
                        $dossiers_selected_ids[] = $obj_dossier->id;
                        $dossiers_selected_nums[] = $obj_dossier->num_dossier;
                    }
                }

                if (is_array($dossiers_selected_ids) && count($dossiers_selected_ids) > 0) {
                    sort($dossiers_selected_nums);
                    $resultat['dossiers_selected'] = array(
                        'nb' => count($dossiers_selected_ids),
                        'ids' => implode("|", $dossiers_selected_ids),
                        'nums' => implode(", ", $dossiers_selected_nums)
                    );
                }
            }
            else
            {
                $resultat['erreur'] = "Les dossiers sélectionnés sont associés à plusieurs dispositifs.";
                $html_message = '';
                foreach ($dispositifs as $dispositif) {
                    $html_message .= '<div style=" margin-left: 12px; margin-top: 5px;"> - <strong> ' . $dispositif['count'] . ' </strong>';
                    $html_message .=    ($dispositif['count'] === 1) ? 'dossier sur le dispositif' : 'dossiers sur le dispositif';
                    $html_message .=    ' " <strong>' . $dispositif['name'] . '</strong> " ';
                    $html_message .= '</div>';
                }
                $html_message .= '<div style="font-weight: bold; margin-top: 20px;"> Pour modifier l\'assignation, veuillez sélectionner des dossiers d\'un même dispositif </div>';
                $resultat['html_message'] = $html_message;
            }
        } else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_lancerFluxByDossier()
     * Fonction pour déclencher un flux par dossier
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $resultat_flux : Json avec un statut ( ok/err ) + le résultat du déclenchement du flux ou le libellé de l'erreur
     */
    public function action_lancerAssignationByDossier()
    {
        if (!empty($_REQUEST['array_champs'])) 
        {
            $dossier_id = $_REQUEST['array_champs']['record'];
            $user_id    = $_REQUEST['array_champs']['user_id'];

            if( !isset( $dossier_id ) || empty( $dossier_id ) )
            {
                return;
            }

            // On récupere le flux concerné et on utilise la fonction getDonneesFlux de OPS_flux pour récuperer les données à envoyer
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            $obj_dossier->assigned_user_id = $user_id;
            $obj_dossier->save(true);

            $data = array(
                "OK"
            );
        }

        ob_clean();
        echo json_encode($resultat);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_lancerFluxByDossier()
     * Fonction pour déclencher un flux par dossier
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $resultat_flux : Json avec un statut ( ok/err ) + le résultat du déclenchement du flux ou le libellé de l'erreur
     */
    public function action_lancerAssignationByDossierLot()
    {
        $resultat = array('statut' => 'err', 'data' => array());
        $champs = array("json" => true);

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {
            
            $data_decode = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($data_decode);

            $user_id = '';
            if( isset($donnees->user_id) )
            {
                $user_id = $donnees->user_id; 
            }

            // On récupere le flux concerné et on utilise la fonction getDonneesFlux de OPS_flux pour récuperer les données à envoyer
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $donnees->dossier_id);
            $obj_dossier->assigned_user_id = $user_id;
            $obj_dossier->save(true);

            $resultat['data']['dossier_id'] = $donnees->dossier_id; 
            $resultat['data']['dossier_name'] = $obj_dossier->num_dossier; 
            $resultat['data']['data_retour'] = 'Utilisateur assigné'; 
            $resultat['statut'] = 'ok'; 
        } else {
            $resultat['data'] = $data_verified['data'];
        }

        ob_clean();
        echo json_encode($resultat);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * @name isValidDispositifs()
     * Fonction pour retourne les dispositifs des dossiers séléctionnés
     * 
     *  @param array                            $dossiers : les ids des dossiers séléctionnés
     *  @return array                           $dispositifs : les dispositifs associés aux dossiers séléctionnés 
     */
    function isValidDispositifs($dossiers)
    {

        $dispositifs = array();
        if (is_array($dossiers) && count($dossiers) > 0) {
            foreach ($dossiers as $dossier_id) {
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                if (!empty($obj_dossier->id)) {
                    $liste_dispositif = $obj_dossier->get_linked_beans("ops_dispositif_ops_dossier", "OPS_dispositif");
                    if (is_array($liste_dispositif) && count($liste_dispositif) === 1) {
                        if (array_key_exists($liste_dispositif[0]->id, $dispositifs)  === false) {
                            $dispositifs[$liste_dispositif[0]->id] = array(
                                'name' =>  $liste_dispositif[0]->name,
                                'count' => 1
                            );
                        } else {
                            $dispositifs[$liste_dispositif[0]->id]['count']++;
                        }
                    }
                }
            }
        }
        return $dispositifs;
    }

    /**
     * @access public
     * action_creer_individu()
     * Fonction pour créer un individu
     *
     * @return json     $data
     */
    public function action_creer_individu(){
        if(!empty($_REQUEST['array_champs'])){
            $objIndividu = BeanFactory::newBean('OPS_individu');
            $objIndividu->type_individu = !empty($_REQUEST['array_champs']['type'])?$_REQUEST['array_champs']['type']:'';
            $objIndividu->salutation = !empty($_REQUEST['array_champs']['salutation'])?$_REQUEST['array_champs']['salutation']:'';
            $objIndividu->sexe = !empty($_REQUEST['array_champs']['sexe'])?$_REQUEST['array_champs']['sexe']:'';
            $objIndividu->last_name = !empty($_REQUEST['array_champs']['last_name'])?$_REQUEST['array_champs']['last_name']:'';
            $objIndividu->nom_usage = !empty($_REQUEST['array_champs']['nom_usage'])?$_REQUEST['array_champs']['nom_usage']:'';
            $objIndividu->first_name = !empty($_REQUEST['array_champs']['first_name'])?$_REQUEST['array_champs']['first_name']:'';
            $objIndividu->date_naissance = !empty($_REQUEST['array_champs']['date_naissance'])?$_REQUEST['array_champs']['date_naissance']:'';
            $objIndividu->phone_mobile = !empty($_REQUEST['array_champs']['telephone'])?str_replace('.', '', $_REQUEST['array_champs']['telephone']):'';
            $objIndividu->email1 = !empty($_REQUEST['array_champs']['email'])?$_REQUEST['array_champs']['email']:'';

            $id = $objIndividu->save();

            ob_clean();
            echo json_encode($id);
            sugar_cleanup(true);
        }
    }

    /**
     * @access public
     * action_initChoixDocument()
     * Fonction pour récuperer les dossier de l'action par lot générer document
     *
     * @return json     $data
     */
    public function action_initChoixDocument(){
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        if ($data_verified['statut'] == 'ok') {
            $dossiers_ids = $data_verified['data']['json_array']['dossiers'];

            foreach($dossiers_ids as $dossierId){
                $objDossier = BeanFactory::getBean('OPS_dossier',$dossierId);
                if (!empty($objDossier->id)) {
                    $dossiersSelectedIds[] = $objDossier->id;
                    $dossiersSelectedNums[] = $objDossier->num_dossier;
                }
            }
            if (is_array($dossiersSelectedIds) && count($dossiersSelectedIds) > 0) {
                sort($dossiersSelectedNums);
                $resultat['dossiers_selected'] = array(
                    'nb' => count($dossiersSelectedIds),
                    'ids' => implode("|", $dossiersSelectedIds),
                    'nums' => implode(", ", $dossiersSelectedNums)
                );
            }
        }else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_initChoixDocument()
     * Fonction pour génère le récapitulatif de l'action par lot
     *
     * @return json     $data
     */
    public function action_genererDocumentDossiers(){
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        if ($data_verified['statut'] == 'ok') {
            $dossiers_ids = $data_verified['data']['json_array']['dossiers'];
            $dossierFile = array();
            foreach($dossiers_ids as $dossierId){
                $objDossier = BeanFactory::getBean('OPS_dossier',$dossierId);
                if (!empty($objDossier->id)) {
                    $ode_pdf = new OdePdfHelper($objDossier->id, "agent", "mail");
                    $dossierFile[$objDossier->num_dossier] = $ode_pdf->generer();
                    
                }
            }
            ksort($dossierFile);
            if(!empty($dossierFile)){
                require_once($_SERVER['DOCUMENT_ROOT'].'/vendor/setasign/fpdi/src/autoload.php');
                $pdf = new setasign\Fpdi\Tcpdf\Fpdi();
                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);        
                foreach ($dossierFile as $key => $value) {
                    $pagecount = $pdf->setSourceFile($value['data']['path']);
                    for ($i = 1; $i <= $pagecount; $i++) {
                        $template = $pdf->importPage($i);
                        $pdf->AddPage();
                        $pdf->useTemplate($template);
                    }
                    unlink($value['data']['path']);
                }
                $file_name = create_guid();
                $file_location = $_SERVER['DOCUMENT_ROOT'].'/upload/'.$file_name;
                $pdf->Output($file_location, 'F');
                $resultat = array(
                    'nb' => count($dossierFile),
                    'nom' => $file_name
                );
            }
        }else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    public function action_telechargerDocument(){
        $file_location = $_SERVER['DOCUMENT_ROOT'].'/upload/'.$_REQUEST['file_name'];
        header("Cache-Control:public");
        header("Content-type:application/pdf");
        header("Content-Disposition:attachment;filename=recaputilatif_dossier.pdf");
        header("Content-Length:" . filesize($file_location));
        readfile($file_location);
        exit();
    }

    public function action_genererSelectDispositif(){
        if ($_REQUEST['array_champs'] ) {

            $resultat = array();

            $dispositifOld = BeanFactory::getBean('OPS_dispositif', $_REQUEST['array_champs']['ancien_id_dispositif']);
            $dispositifOld->load_relationship('ops_guide_instruction_ops_dispositif');
            $idGuideOld = $dispositifOld->ops_guide_instruction_ops_dispositif->get();

            $dispositifNew = BeanFactory::getBean('OPS_dispositif', $_REQUEST['array_champs']['nouveau_id_dispositif']);
            $dispositifNew->load_relationship('ops_guide_instruction_ops_dispositif');
            $idGuideNew = $dispositifNew->ops_guide_instruction_ops_dispositif->get();

            if($idGuideOld[0] != $idGuideNew[0]){
                $guideIstruction = BeanFactory::getBean('OPS_guide_instruction', $idGuideNew[0]);
                $guideIstruction->load_relationship('ops_guide_instruction_ops_etape');
                $idEtape = $guideIstruction->ops_guide_instruction_ops_etape->get();

                $listeEtape = '<option value=""></option>';
                $listeStatut = '<option value=""></option>';
                $etapes = array();

                foreach($idEtape as $uneEtape){
                    $etape = BeanFactory::getBean('OPS_etape', $uneEtape);
                    $etapes[$etape->ordre] = $etape->id;
                }
                ksort($etapes);

                //On récupère chaque étape ainsi que leur statut
                foreach($etapes as $uneEtape){
                    $etape = BeanFactory::getBean('OPS_etape', $uneEtape);
                    $listeEtape .= '<option id="'.$etape->id.'" value="'.$etape->id.'">'.$etape->name.'</option>';
                    $statuts = $etape->get_linked_beans(
                        'ops_etape_ops_statut',
                        'OPS_statut',
                        'ordre');
                    foreach ($statuts as $unStatut ) {
                        $listeStatut .= '<option id="'.$unStatut->id.'" value="'.$unStatut->id.'" data-etape="'.$etape->id.'" style="display:none;">'.$unStatut->name.'</option>';
                    }

                }

                $resultat['liste_etape'] = $listeEtape;
                $resultat['liste_statut'] = $listeStatut;
            }
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name getDossiers()
     * Fonction pour retourne les ids des dossiers séléctionnés 
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return array                           $data : array avec un statut ( ok/err ) + les données ou le libellé de l'erreur
     */
    private function getDossiers($request)
    {
        global $db;
        $libelle_erreur = '';
        $dossiers = [];
        do {

            $data_verified = OdeArrayHelper::isDataValid($request, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['dossiers']) && is_array($data['dossiers']) && count($data['dossiers']) > 0) {
                $dossiers = $data['dossiers'];
                break;
            }
            if (!empty($data['filtres'])) {
                $json = htmlentities(json_encode($data['filtres']), ENT_QUOTES, 'UTF-8');
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des dossiers + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_dossier', $json);
                $where_clause = $mass->where_clauses;
                $obj_dossier = new OPS_dossier();
                $query = $obj_dossier->create_export_query("", $where_clause);
                $queryExplode = explode('FROM',$query);
                $queryExplode[0] = 'SELECT ops_dossier.id';
                $query = implode(' FROM', $queryExplode);
                $query = OPS_dossier::cleanQueryActionLot($query,array('ops_sous_territoire','ops_dossier','ops_elu'));
                $result = $db->query($query);
                while ($dossier = $db->fetchByAssoc($result)) {
                    $dossiers[] = $dossier['id'];
                }
            }

            // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
            if (!is_array($dossiers) || count($dossiers) === 0) {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossiers) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }

        /**
     * @access public
     * action_createDemandePaiement()
     * Fonction de création d'un demande paiement => liaison entre dossier  + redirection vers la modification 
     *
     * @return json     $data
     */
    function action_createDemandePaiement()
    {
        // Récupération du dossier père pour récupérer le demandeur, profil et bénéficiaire 
        $obj_dossier =  BeanFactory::getBean('OPS_dossier', $_GET['record'] ); 

        if( isset( $obj_dossier->id ) ){            
            $donnees_formated['ops_personne_morale'] = $obj_dossier->ops_personne_morale; 
            $donnees_formated['beneficiaire_id'] = $obj_dossier->beneficiaire_id; 
            $donnees_formated['demandeur'] = $obj_dossier->ops_individu_id; 
            $donnees_formated["dispositif"] =  $_GET['dispositif_id'] ;
            $donnees_formated['brouillon'] = true;
            $donnees_formated['type_tiers'] = "OPS_individu";

            // On récupere l'id du dossier 
            $dossier_id = OPS_dossier::createDossier($donnees_formated);
         
            if( strlen($dossier_id) == 36 ){

                $obj_dossier_paiement = BeanFactory::getBean('OPS_dossier', $dossier_id);

                // Rattachement de la demande de paiement à la fiche action : 
                $obj_dossier->load_relationship('ops_dossier_ops_dossier_paiement');
                $obj_dossier->ops_dossier_ops_dossier_paiement->add($obj_dossier_paiement);

                // Redirection vers la modification du dossier 
                SugarApplication::redirect("/index.php?module=OPS_dossier&action=EditView&record=".$obj_dossier_paiement->id );

            }
            else{
                SugarApplication::appendErrorMessage("Une erreur s'est produite, le dossier n'a pas été créé." );
                SugarApplication::redirect( "index.php?module=OPS_dossier&return_module=OPS_dossier&action=DetailView&record=".$obj_dossier->id );
            }

        }
        else{
            SugarApplication::appendErrorMessage("Une erreur s'est produite, le dossier n'a pas été récupéré." );
            SugarApplication::redirect("index.php?module=OPS_dossier&action=index&return_module=OPS_dossier" );
        }
      
    }


    



}
