$(document).ready(function() {

    // We initialize the modal
    ModalAssignation.initialisation( LancerAssignation.modal_id );

    if ( ModalAssignation.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        LancerAssignation.setClickActionLotBtn();
    }

    $('#form_assignation_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_assignation_btn_execute').click(function(){
        LancerAssignation.lancerAssignationDossiers();
    });

    $('#form_assignation_unitaire_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_assignation_unitaire_btn_execute').click(function(){
        LancerAssignation.lancerAssignationUnitaire();
    });

});

// We create an instance of the OdeModal object
const ModalAssignation = Object.create(OdeModal);

if( typeof(LancerAssignation) == 'undefined' ){ var LancerAssignation = { modal_id: 'ode_modal_assignation', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
LancerAssignation.setClickActionLotBtn = function(){
    $('[role="ode-modal-assignation-btn"]').off().on('click', function () {
        $('#form_assignation_btn_terminer').text('Annuler');
        $('#form_assignation_btn_execute').show();
        ModalAssignation.initialisation( LancerAssignation.modal_id );
        ModalAssignation.open();
        LancerAssignation.initialisation();
    });

    $('[role="ode-modal-assignation-unitaire-btn"]').off().on('click', function () {
        $('#form_assignation_unitaire_btn_terminer').text('Annuler');
        $('#form_assignation_unitaire_btn_execute').show();
        ModalAssignation.initialisation( LancerAssignation.modal_id );
        ModalAssignation.open();
        LancerAssignation.initialisationUnitaire();
    });
}

LancerAssignation.initialisation = function(){ 

    ModalAssignation.route('loading');

    var loading = function(){
        ModalAssignation.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalAssignation.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalAssignation.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.dossiers_selected.nb === 1 ) 
                    ? `Récupération du dossier séléctionné`
                    : `Récupération des ${this.result.dossiers_selected.nb} dossiers séléctionnés`;

        ModalAssignation.loading.setMessage(message);
        ModalAssignation.loading.setTotal(this.result.dossiers_selected.nb);

        for(var i = 0; i < this.result.dossiers_selected.nb; i++){
            ModalAssignation.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalAssignation.route('assignation');
            ModalAssignation.loading.reset();
            retourFunctionAssignation.initChoixAssignation(this);
        }, 1000);
    };

    var dossiers = LancerAssignation.getSelectedDossiers();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_dossier');
    query.setAction("initChoixAssignation");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

LancerAssignation.initialisationUnitaire = function(){ 

    ModalAssignation.route('loading');

    var loading = function(){
        ModalAssignation.loading.setMessage('Récupération du dossier');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalAssignation.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalAssignation.route('erreur',this.result.erreur);
            return; 
        }

        var message = `Récupération du dossier`;

        ModalAssignation.loading.setMessage(message);
        ModalAssignation.loading.setTotal(1);
        ModalAssignation.loading.increaseCurrent();

        setTimeout(() => {
            ModalAssignation.route('assignation');
            ModalAssignation.loading.reset();
            retourFunctionAssignation.initChoixUnitaire(this);
        }, 1000);
    };

    var dossier = getDataFunctionAssignation.initChoixUnitaire();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_dossier');
    query.setAction("initChoixAssignation");
    query.setPostData( dossier );
    OdeAjax.getByAction( query, loading, callBack );
}

LancerAssignation.lancerAssignationDossiers = function(){
    $("#tbody_resultat_assignation").empty(); 
    $("#small_select_assignation").hide();
    $("#select_assignation").css('border', '1px solid green');

    var dossiers_selected_ids = $("#dossiers_selected_ids").val();
    var obj_ids = ( dossiers_selected_ids !== "" ) ? dossiers_selected_ids.split('|') : [];

    if( obj_ids.length > 0 )
    {
        for ( var key in obj_ids ) {
            ModalAssignation.route('loading');
            ModalAssignation.loading.reset();
            lancerAssignationByDossier( obj_ids[key], obj_ids.length );
        }
    }
}

LancerAssignation.lancerAssignationUnitaire = function(){
    var assignation_id = $("#select_assignation").children("option:selected").attr("id");
    if( assignation_id !== undefined ){
        $("#tbody_resultat_assignation").empty(); 
        $("#small_select_assignation").hide();
        $("#select_assignation").css('border', '1px solid green');
        ModalAssignation.route('loading');

        var loading = function(){
            ModalAssignation.loading.setMessage('Assignation de l\'utilisateur');
        };

        var callBack = function(){

            var message = `Assignation de l\'utilisateur sur le dossier`;

            ModalAssignation.loading.setMessage(message);
            ModalAssignation.loading.setTotal(1);
            ModalAssignation.loading.increaseCurrent();

            setTimeout(() => {
                ModalAssignation.route('assignation');
                ModalAssignation.loading.reset();
                retourFunctionAssignation.lancerAssignationByDossier(this);
                $('#form_assignation_unitaire_btn_terminer').text('Fermer');
                $('#form_assignation_unitaire_btn_execute').hide();
            }, 1000);
            
        };

        var obj_json = { dossier_id: getIdDossier(), user_id: $("#select_assignation").children("option:selected").attr("id") };
        var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        var query = OdeQueries.getAjaxActionQuery();
        query.setModule('OPS_dossier');
        query.setAction("lancerAssignationByDossier");
        query.setPostData( data );
        OdeAjax.getByAction( query, loading, callBack );

        }else{
            $("#small_select_assignation").text("Aucun assignation n'est séléctionné").show();
            $("#select_assignation").css('border', '1px solid red');
        }
}

LancerAssignation.getSelectedDossiers = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    if (document.MassUpdate.uid.value != ''){
        var massUpdate = document.MassUpdate.uid.value;
        massUpdate += ',';
        massUpdate += tabId.join(',');
        tabId = massUpdate.split(',');
        if(tabId[tabId.length - 1] == ''){
            tabId.pop();
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { dossiers: false, filtres: json } : { dossiers: tabId, filtres: false };
}

var RoutingAssignation = {

    route: function (form_name, data) {

        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }

        this.initFormulaire(form_name, data);
        this.displayFormulaire();

        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "message_assignation":
                Assignation.initMessage(data);
                break;
            case "loading_assignation":
                Assignation.initLoading();
                break;
            case "progress_loading_assignation":
                Assignation.initProgressLoading();
                break;
            case "choix_assignation":
                Assignation.initChoix(data);
                break;
            case "resultat_assignation":
                Assignation.initResultat(data);
                break;
            case "choix_assignation_unitaire":
                Assignation.initChoixUnitaire(data);
                break;
            case "resultat_assignation_unitaire":
                Assignation.initResultatUnitaire(data);
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
    
};


var Assignation = {

    initMessage: function (data) {
        console.log("initMessage :: data = ", data)
    },

    initLoading: function () {
        LoadingAssignation.addSpinner($('#modal_assignation_loading'));
        $("#form_assignation_btn_lancer").hide();
    },

    initProgressLoading: function () {
        ProgressBarAssignation.initBar("assignation_progress_bar");
        $("#form_assignation_btn_lancer").hide();
    },

    initChoix: function (data) {

        var title = ( data.dossiers_selected.nb === 1 ) ? "Assigner un utilisateur sur le dossier" : "Assigner un utilisateur sur les "+data.dossiers_selected.nb+" dossiers"; 

        
        $("#form_assignation_btn_lancer").show();
        $("#modal_assignation_title").text( title );
        $("#dossiers_selected_ids").val( data.dossiers_selected.ids );
        $("#dossiers_assignation_selected_nums").text( data.dossiers_selected.nums );
        $("#small_select_assignation").hide();
        $("#select_assignation").css('border', '');
        $("#select_assignation").empty();
        $("#select_assignation").append('<option value=""></option>');
        if ( data.hasOwnProperty('assignation') && data.assignation.hasOwnProperty('securityGroups') && data.assignation.hasOwnProperty('members')) {
            var securityGroups = data.assignation.securityGroups;
            var modal_assignation = data.assignation;
            Object.keys(securityGroups).forEach(function(securityGroupsID) {
                $("#select_assignation").append('<optgroup id="'+ securityGroupsID +'" label="' + securityGroups[securityGroupsID] + '">'+  +'</optgroup>');
                Object.keys(data.assignation.members[securityGroupsID]).forEach(function(memberID) {
                    $("#select_assignation").append('<option id="'+ memberID +'">' + data.assignation.members[securityGroupsID][memberID] +'</option>');
                });
                $("#select_assignation").append('</optgroup>');
            });
        }
    },
    
    initResultat: function (data) {
        if( data !== false ){
            console.log("initResultat :: data = ", data)
        }
    },

    initChoixUnitaire: function (data) {
        $("#small_select_assignation").hide();
        $("#assignation_description").text("");
        $("#select_assignation").css('border', '');
        $("#select_assignation").empty();
        $("#select_assignation").append('<option value=""></option>');
        if ( data.hasOwnProperty('assignation') && data.assignation.hasOwnProperty('securityGroups') && data.assignation.hasOwnProperty('members')) {
            var securityGroups = data.assignation.securityGroups;
            var modal_assignation = data.assignation;
            Object.keys(securityGroups).forEach(function(securityGroupsID) {
                $("#select_assignation").append('<optgroup id="'+ securityGroupsID +'" label="' + securityGroups[securityGroupsID] + '">'+  +'</optgroup>');
                Object.keys(data.assignation.members[securityGroupsID]).forEach(function(memberID) {
                    $("#select_assignation").append('<option id="'+ memberID +'">' + data.assignation.members[securityGroupsID][memberID] +'</option>');
                });
                $("#select_assignation").append('</optgroup>');
            });
        }
    },

    initResultatUnitaire: function (data) {

        var resultat = data.result;
        $("#tbody_resultat_assignation").empty(); 
        $html_dossier =  '<tr>';
        $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
        $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
        $html_dossier +=         ( data.statut === true ) ? '#003a6c;">' : 'red;">';
        $html_dossier +=         resultat.dossier_name + '</a>';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=        ( data.statut === true  ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
        $html_dossier +=    '</td>';
        $html_dossier +=    '<td class="td-resultat-verification">';
        $html_dossier +=       resultat.data_retour;
        $html_dossier +=    '</td>';
        $html_dossier += '</tr>';
        $("#tbody_resultat_assignation").append($html_dossier);

    },

}

var LoadingAssignation = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

function lancerAssignationByDossier( dossier_id, dossiers_length ){

    var loading = function(){
        ModalAssignation.loading.setMessage('Lancement du assignation');
    };

    var callBack = function(){

        var message = ( dossiers_length === 1 ) 
                    ? `Assignation de l\'utilisateur sur le dossier séléctionné`
                    : `Assignation de l\'utilisateur sur les ${dossiers_length} dossiers séléctionnés`;

        ModalAssignation.loading.setMessage(message);
        ModalAssignation.loading.setTotal(dossiers_length);

        retourlancerAssignationByDossier( this, dossiers_length )
    };

    var obj_json = { dossier_id: dossier_id, user_id: $("#select_assignation").children("option:selected").attr("id") };
    var data = ( isJson( JSON.stringify( obj_json ) ) ) ? utf8_to_b64( JSON.stringify( obj_json ) ) : false;
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_dossier');
    query.setAction("lancerAssignationByDossierLot");
    query.setPostData( data );
    OdeAjax.getByAction( query, loading, callBack );
    
}

function retourlancerAssignationByDossier( reponse, dossiers_length ){

    var resultat = reponse.result;

    $html_dossier = '';
    $html_dossier += '<tr>';
    $html_dossier +=    '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 45%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
    $html_dossier +=        '<a href="index.php?module=OPS_dossier&action=DetailView&record=' + resultat.dossier_id + '" target="_blank" style="color:'; 
    $html_dossier +=         ( reponse.statut === true ) ? '#003a6c;">' : 'red;">';
    $html_dossier +=         resultat.dossier_name + '</a>';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=        ( reponse.statut === true ) ? '<img style="width: 17px;" src="custom/include/images/success.png" />' : '<img style="width: 17px;" src="custom/include/images/delete.png" />';
    $html_dossier +=    '</td>';
    $html_dossier +=    '<td class="td-resultat-verification">';
    $html_dossier +=       resultat.data_retour;
    $html_dossier +=    '</td>';
    $html_dossier += '</tr>';
    $("#tbody_resultat_assignation").append($html_dossier);

    ModalAssignation.loading.increaseCurrent();

    if( ModalAssignation.loading.total === dossiers_length ){
        time = 2000 + (dossiers_length * 1000);
        setTimeout(function (){
            ModalAssignation.route('assignation');
            RoutingAssignation.route("resultat_assignation", false);
            $('#form_assignation_btn_terminer').text('Fermer');
            $('#form_assignation_btn_execute').hide();
        }, time); 
    }

}

var ProgressBarAssignation = {

    currentValue: 0,
    currentDone: 0,
    barContent: false,

    initBar: function( bar_content_id ){
        this.barContent = ( $("#"+bar_content_id).length > 0 ) ? $("#"+bar_content_id) : false;
        this.reset();
    },

    reset: function () {
        this.currentValue = 0;
        this.currentDone = 0;
        if(this.barContent){
            this.barContent.css("width","0%");
        }
    },

    increaseDone(){
        this.currentDone = this.currentDone + 1;
    },

    animate: function ( value ) {
        value = Math.floor( value );
        if( this.barContent !== false && typeof value === "number" && value > 0 ){
            if( this.currentValue + value > 100 ){
                value = 100 - this.currentValue;
            }
            this.currentValue += value;
            this.barContent.css("width",`${this.currentValue}%`);
        }
    }

}

function getIdDossier(){
    var searchParams = new URLSearchParams(location.search);
    return ( searchParams.get("record") ) ? searchParams.get("record") : "";
}

// Fonction qui retourne la liste des dossiers 
function getDossiers(){

    var dossiers = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    dossiers = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        dossiers = json + '&selectAll=1';
    }
    return dossiers;

}


var getDataFunctionAssignation = {
    initChoixAssignation: function() {
        var dossiers = getDossiers();
        return ( typeof dossiers === "string" &&  Object.keys(dossiers).length > 0 ) ? "dossiers=" + dossiers : false;
    },
    lancerAssignationDossiers: function() {
        var obj_json = { 
            dossiers_ids: $("#dossiers_selected_ids").val(),
            assignation_id: $("#select_assignation").children("option:selected").attr("id") 
        };
        return ( isJson( JSON.stringify( obj_json ) ) ) ? "json=" + utf8_to_b64( JSON.stringify( obj_json ) ) : false;
    },
    initChoixUnitaire: function() {
        var dossier_id = getIdDossier();
        return ( typeof dossier_id === "string" ) ? {dossier_id : dossier_id} : false;
    },
    lancerAssignationByDossier: function() {
        var assignation_id = $("#select_assignation").children("option:selected").attr("id") 
        if( assignation_id !== undefined ){
            var obj_json = { 
                dossier_id: getIdDossier(),
                assignation_id: assignation_id
            };
            return ( isJson( JSON.stringify( obj_json ) ) ) ? "json=" + utf8_to_b64( JSON.stringify( obj_json ) ) : false;
        }else{
            $("#small_select_assignation").text("Aucun assignation n'est séléctionné").show();
            $("#select_assignation").css('border', '1px solid red');
            return false;
        }
    },
    
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionAssignation : Object.assign(getDataFunction, getDataFunctionAssignation);


// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionAssignation = {
    initChoixAssignation: function() {
        RoutingAssignation.route("loading_assignation", null);
    },
    lancerAssignationDossiers: function() {
        RoutingAssignation.route("loading_assignation", null);
    },
    initChoixUnitaire: function() {
        RoutingAssignation.route("loading_assignation", null);
    },    
    lancerAssignationByDossier: function() {
        RoutingAssignation.route("loading_assignation", null);
    },
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionAssignation : Object.assign(loadingFunction, loadingFunctionAssignation);


// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionAssignation = {
    initChoixAssignation: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingAssignation.route( "choix_assignation", data.result );
            } else {
                RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerAssignationDossiers: function(data) {
        if(data){
            if( data['statut'] === "ok" ){
                RoutingAssignation.route( "resultat_assignation", data.data );
            } else {
                RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    initChoixUnitaire: function(data) {
        if(data){
            if( data['statut'] === true ){
                RoutingAssignation.route( "choix_assignation_unitaire", data.result );
            } else {
                RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
            }
        }else{
            RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
    lancerAssignationByDossier: function(data) {
        if(data){
            RoutingAssignation.route( "resultat_assignation_unitaire", data );
        }else{
            RoutingAssignation.route( "message_assignation", { statut: "err", titre: "Initialisation", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    },
};
var retourFunction2 = (typeof retourFunction === 'undefined') ? retourFunctionAssignation : Object.assign(retourFunction, retourFunctionAssignation);