var profil_liste;
var demandeur_liste;
var beneficiaire_liste;

$( document ).ready(function() {

    var params = JSON.parse(atob($('#dispositif-param').val()));

    var isPersonneMorale = params.type_beneficiare.indexOf(element => element == 'personne_morale');

    $('.btn_suivant_dossier').click(function(){
        
        var params = JSON.parse(atob($('#dispositif-param').val()));

        var erreur = '';
        var isPersonneMorale = params.type_beneficiare.find(element => element == 'personne_morale');
        if(!$('#demandeur').val()){
            erreur += 'Demandeur'; 
        }

        if( params.type_beneficiare.find(element => element == 'individu') && params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() == "" && $('#beneficiaire').val() == "" ){

            (erreur !== '')? erreur += ' et/ou' : '' ;
        
        }

        if( ( isPersonneMorale && params.type_tier.length > 0 && !$('#personne_morale').val() ) ||
            ( isPersonneMorale && params.type_tier.length > 0 && !$('#personne_morale').val() && params.beneficiaire == 1 && $('#beneficiaire').val() ) ){
            (erreur !== '')? erreur += ', Profil' :erreur += 'Profil';
        }

        if(params.beneficiaire == 1 && !$('#beneficiaire').val()  && params.type_beneficiare.find(element => element == 'personne_morale')){
            (erreur !== '')? erreur += ', Bénéficiaire' :erreur += 'Bénéficiaire';
        }

        // Dans le cas ou le dispositif est flaggué "individu" et "profil"
        if( $('#demandeur').val() != "" && params.type_beneficiare.find(element => element == 'individu') && ( params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() == "") ){

            if (window.confirm("Souhaitez-vous créer un dossier pour un individu ? ")) {
                redirect_dossier() ; 
            }

        }
        else if(erreur !== ''){
            $('#titre_modal_introuvable').text('Erreur');
            $('#paragraphe_modal_introuvable').text('Vous devez renseigner la(es) partie(s) suivante(s) : '+erreur);
            $('#modal-introuvable-body-creer').hide();
            $('#modal-introuvable').modal();
        }else{
            redirect_dossier() ; 
        }
    });

    $('#modal-demandeur').on("click",function (e) {
        OdeLoadingHelper.removeSpinner($(document.body));
    } );

    $('#creer_individu_type').on("click",function (e) {
        if($('#creer_individu_type').val() == 'enfant'){
            $('#creer_individu_salutation_div').hide();
            $("#creer_individu_salutation").val('') 
            $('#creer_individu_sexe_div').show();
        }else{
            $('#creer_individu_salutation_div').show();
            $('#creer_individu_sexe_div').hide();
            $("#creer_individu_sexe").val('') 
        }
    } );

    $('#individu_introuvable').on("click",function (e) {
        if($("input[name='individu_introuvable']:checked").val()){
            $('#individu_introuvable_select').show();
        }else{
            $('#individu_introuvable_select').hide();
        }
    } );

    $( "#creer_individu_last_name ,#creer_individu_nom_usage" ).keyup(function() {
        $(this).val($(this).val().toUpperCase());
    });

    $( "#creer_individu_first_name" ).keyup(function() {
        $(this).val($(this).val().charAt(0).toUpperCase() + $(this).val().substring(1).toLowerCase());
    });

    Inputmask({ mask: "99/99/9999" }).mask( $("#creer_individu_date_naissance") );
    Inputmask({ mask: "99.99.99.99.99" }).mask( $("#creer_individu_telephone") );
});

function redirect_dossier(){
    var params = JSON.parse(atob($('#dispositif-param').val()));

    //Faire la redirection vers le dossier
    var url = "index.php?module=OPS_dossier&action=create&demandeur_type=OPS_individu";
    var urlParams = "&dispositif_id="+params.dispositif_id+"&demandeur_id="+$('#demandeur').val();

    if($('#personne_morale') && $('#personne_morale').val() != ""  && params.type_beneficiare.find(element => element == 'personne_morale') ){
        urlParams += "&personne_morale_id="+$('#personne_morale').val();
    }
    if($('#beneficiaire') && $('#beneficiaire').val() != "" && params.type_beneficiare.find(element => element == 'personne_morale') && params.beneficiaire == 1 ){

        urlParams += "&beneficiaire_id="+$('#beneficiaire').val();
    }
    document.location.href= url+urlParams;
}

function call_ajax_recherche(type_block){

    var result_verif_obligatoire = this.verif_champs_obligatoires(type_block);

    if(result_verif_obligatoire == true){

        OdeLoadingHelper.showOverlay();
        OdeLoadingHelper.addSpinner();

        var array_champs = this.get_valeurs_champs_recherche(type_block);

        $.ajax({
            type:"POST",
            url:'index.php?module=OPS_dossier&action=recherche_individu',
            dataType: 'json',
            data: {
                array_champs: array_champs
            }
        })
        .done(function (data) {

            data = Object.values(data);

            // Un seul individu trouvé 
            if(typeof(data) != "undefined" && data.length == 1){

                var numero = data[0].phone_number;
                numero = numero.replaceAll(' ','');

                var num_longueur = numero.length;
                if(num_longueur == '10'){
                    var parttel1 = numero.substr(0, 2);
                    var parttel2 = numero.substr(2, 2);
                    var parttel3 = numero.substr(4, 2);
                    var parttel4 = numero.substr(6, 2);
                    var parttel5 = numero.substr(8, 2);
                    var numero = parttel1 + '.' + parttel2 + '.' + parttel3 + '.' + parttel4 + '.' + parttel5;
                }
                    
                if(type_block == 'recherche'){

                   
                    $('#salutation_recherche').val(data[0].salutation);
                    $('#last_name_recherche').val(data[0].last_name);
                    $('#nom_usage_recherche').val(data[0].nom_usage);
                    $('#first_name_recherche').val(data[0].first_name);
                    $('#date_naissance_recherche').val(data[0].date_naissance);
                    $('#telephone_recherche').val(numero);
                    $('#email_recherche').val(data[0].email);
                    $('#demandeur').val(data[0].id);
                    $('#creation_demandeur').show();
                    do_recherche(  data[0].id, "demandeur" );
                   
                }else if(type_block == 'beneficiaire'){
                    $('#beneficiaire').val(data[0].id);
                    $('#salutation_beneficiaire_recherche').val(data[0].salutation);
                    $('#last_name_beneficiaire_recherche').val(data[0].last_name);
                    $('#nom_usage_beneficiaire_recherche').val(data[0].nom_usage);
                    $('#first_name_beneficiaire_recherche').val(data[0].first_name);
                    $('#date_naissance_beneficiaire_recherche').val(data[0].date_naissance);
                    $('#telephone_beneficiaire_recherche').val(numero);
                    $('#email_beneficiaire_recherche').val(data[0].email);
                    $('#beneficiaire').val(data[0].id);
                    $( 'input[type="hidden"]#'+ String(data[0].id) ).attr('rel' , 'beneficiaire' );
                    $('#creation_beneficiaire').show();
                    do_recherche(  data[0].id, "beneficiaire" );
                }
            }else if(typeof(data) != "undefined" && data.length > 1){


                $("#nombre_max").hide();
                if( data.length > 15 ){
                    $("#nombre_max").show();
                    data.splice(14, 1);
                }

                $('#type_block').val('recherche');
                $('#modal-individu-body').empty();
                $('#titre_modal_trouve').text('Individus trouvés');
                if(type_block == 'recherche'){
                    $('#modal-individu-body-creer').show();
                    $('#creation_demandeur_modal').show();
                    $('#creation_beneficiaire_modal').hide();
                }else if(type_block == 'beneficiaire'){
                    $('#modal-individu-body-creer').hide();
                    $('#creation_demandeur_modal').hide();
                    $('#creation_beneficiaire_modal').show();
                }
                $('#modal-demandeur').modal();

                //affichage de la modale resutats des indi trouvé en btn radio
                for (let index = 0; index < data.length; index++) {
                    const element = data[index];

                    var input = document.createElement("input");
                    input.type = "radio";
                    input.id = String(data[index].id) + "_recherche";
                    input.name = "individu_trouve";
                    input.value = data[index].id;
                    input.className = "input_individu_trouve";
                    input.style.verticalAlign = 'top';
                    input.style.marginTop = '3px';
                    var label = document.createElement("label");
                    label.setAttribute("for", String(data[index].id) + "_recherche");
                    label.innerHTML = '<p>' + data[index].salutation + " " +
                        data[index].last_name + ((data[index].nom_usage)?" ("+data[index].nom_usage+") "+ data[index].first_name: " "+data[index].first_name) +
                        (data[index].date_naissance.length != 0 ? ", né(e) le " + data[index].date_naissance : "") + "</p>" +
                        "<p style='font-style:italic;font-weight:400;margin-left:20px'>" + (data[index].email.length != 0 ? "Email : " + data[index].email : "") +
                        (data[index].email.length != 0 && data[index].phone_number.length != 0 ? ", ": "") +
                        (data[index].phone_number.length != 0 ? "Tél. : " + data[index].phone_number : "") + "</p>";

                    var container = document.getElementById('modal-individu-body');
                    var div_input = document.createElement("div");
                    div_input.setAttribute("id",  "block_result_" + String(data[index].id) );

                    div_input.appendChild(input);
                    div_input.appendChild(label);
                    container.appendChild(div_input);

                    //auto-remplissage des champs :

                    //salutation
                    var input_civ = document.createElement("input");
                    input_civ.type = "hidden";
                    input_civ.id = String(data[index].id) + "_salutation_recherche";
                    input_civ.name = "salutation_individu_trouve";
                    input_civ.value = data[index].salutation;
                    input_civ.className = "input_salutation_individu_trouve";

                    var container_civ = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_civ);
                    container_civ.appendChild(div_input);

                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_civ.id) ).attr('rel' , 'salutation_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_civ.id) ).attr('rel' , 'salutation_beneficiaire_recherche' );
                    } 

                    //name
                    var input_name = document.createElement("input");
                    input_name.type = "hidden";
                    input_name.id = String(data[index].id) + "_last_name_recherche";
                    input_name.name = "last_name_individu_trouve";
                    input_name.value = data[index].last_name;
                    input_name.className = "input_last_name_individu_trouve";
                    var container_name = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_name);
                    container_name.appendChild(div_input);

                         
                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_name.id) ).attr('rel' , 'last_name_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_name.id) ).attr('rel' , 'last_name_beneficiaire_recherche' );
                    } 

                    //nom_usage
                    var input_name = document.createElement("input");
                    input_name.type = "hidden";
                    input_name.id = String(data[index].id) + "_nom_usage_recherche";
                    input_name.name = "nom_usage_individu_trouve";
                    input_name.value = data[index].nom_usage;
                    input_name.className = "input_nom_usage_individu_trouve";
                    var container_name = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_name);
                    container_name.appendChild(div_input);

                         
                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_name.id) ).attr('rel' , 'nom_usage_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_name.id) ).attr('rel' , 'nom_usage_beneficiaire_recherche' );
                    } 

                    //prenom
                    var input_first_name = document.createElement("input");
                    input_first_name.type = "hidden";
                    input_first_name.id = String(data[index].id) + "_first_name_recherche";
                    input_first_name.name = "first_name_individu_trouve";
                    input_first_name.value = data[index].first_name;
                    input_first_name.className = "input_first_name_individu_trouve";

                    var container_first_name = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_first_name);
                    container_first_name.appendChild(div_input);

                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_first_name.id) ).attr('rel' , 'first_name_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_first_name.id) ).attr('rel' , 'first_name_beneficiaire_recherche' );
                    } 

                    //date_naissance
                    var input_date_naissance = document.createElement("input");
                    input_date_naissance.type = "hidden";
                    input_date_naissance.id = data[index].id + "_date_naissance_recherche";
                    input_date_naissance.name = "date_naissance_individu_trouve";
                    input_date_naissance.value = data[index].date_naissance;
                    input_date_naissance.className = "input_date_naissance_individu_trouve";

                    var container_date_naissance = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_date_naissance);
                    container_date_naissance.appendChild(div_input);

                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_date_naissance.id) ).attr('rel' , 'date_naissance_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_date_naissance.id) ).attr('rel' , 'date_naissance_beneficiaire_recherche' );
                    }

                    //tel
                    var numero = data[index].phone_number;
                    numero = numero.replaceAll(' ','');

                    var num_longueur = numero.length;
                    if(num_longueur == '10'){
                        var parttel1 = numero.substr(0, 2);
                        var parttel2 = numero.substr(2, 2);
                        var parttel3 = numero.substr(4, 2);
                        var parttel4 = numero.substr(6, 2);
                        var parttel5 = numero.substr(8, 2);
                        var numero = parttel1 + '.' + parttel2 + '.' + parttel3 + '.' + parttel4 + '.' + parttel5;
                    }

                    var input_phone_number = document.createElement("input");
                    input_phone_number.type = "hidden";
                    input_phone_number.id = data[index].id + "_phone_number_recherche";
                    input_phone_number.name = "phone_number_individu_trouve";
                    input_phone_number.value = numero;
                    input_phone_number.className = "input_phone_number_individu_trouve";

                    var container_input_phone = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_phone_number);
                    container_input_phone.appendChild(div_input);
 
                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_phone_number.id) ).attr('rel' , 'telephone_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_phone_number.id) ).attr('rel' , 'telephone_beneficiaire_recherche' );
                    }

                    //mail
                    var input_email = document.createElement("input");
                    input_email.type = "hidden";
                    input_email.id = data[index].id + "_email_recherche";
                    input_email.name = "email_individu_trouve";
                    input_email.value = data[index].email;
                    input_email.className = "input_email_individu_trouve";

                    var container_email = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_email);
                    container_email.appendChild(div_input);

                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_email.id) ).attr('rel' , 'email_recherche' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_email.id) ).attr('rel' , 'email_beneficiaire_recherche' );
                    }

                    //id
                    var input_id = document.createElement("input");
                    input_id.type = "hidden";
                    input_id.id = data[index].id;
                    input_id.name = "id_individu_trouve";
                    input_id.value = data[index].id;
                    input_id.className = "input_id_individu_trouve";

                    var container_id = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_id);
                    container_id.appendChild(div_input);

                    // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                    if(type_block == 'recherche'){
                        $( 'input[type="hidden"]#'+ String(input_id.id) ).attr('rel' , 'demandeur' );
                    }else if(type_block == 'beneficiaire'){
                        $( 'input[type="hidden"]#'+ String(input_id.id) ).attr('rel' , 'beneficiaire' );
                    }
                }
            }else{

         
                // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                $('#creation_demandeur').show();
                $('#titre_modal_introuvable').text('Individu introuvable');
                $('#paragraphe_modal_introuvable').text("Il n'existe aucun individu répondant à vos critères de recherche.");
                $('#modal-introuvable-body-creer').show();
                $('#modal-introuvable').modal();
                if(type_block == 'recherche'){
                    $( 'input[type="hidden"]#individu_introuvable_type_block').attr('rel' , 'demandeur' );
                }else if(type_block == 'beneficiaire'){
                    $( 'input[type="hidden"]#individu_introuvable_type_block' ).attr('rel' , 'demandeur' );
                    $( 'input[type="hidden"]#type_block' ).attr('rel' , 'beneficiaire' );
                }
            }
        })
        .fail(function (data) {
            $('#titre_modal_introuvable').text('Erreur');
            $('#paragraphe_modal_introuvable').text('Une erreur s\'est produite lors de la recherche');
            $('#modal-introuvable').modal();
        })
        .always(function (req) {

            setTimeout( function(){
                OdeLoadingHelper.removeSpinner();
                OdeLoadingHelper.hideOverlay();
            } , 220 );

        });
    }

}

function call_ajax_recherche_personne_morale(){

    var result_verif_obligatoire = this.verif_champs_obligatoires('personne_morale');

    if(result_verif_obligatoire == true){

        OdeLoadingHelper.showOverlay();
        OdeLoadingHelper.addSpinner();

        var array_champs = this.get_valeurs_champs_recherche('personne_morale');

        $.ajax({
            type:"POST",
            url:'index.php?module=OPS_dossier&action=recherche_personne_morale',
            dataType: 'json',
            data: {
                array_champs: array_champs
            }
        })
        .done(function (data) {
            data = Object.values(data);

            if(typeof(data) != "undefined" && data.length == 1){

                $('#raison_sociale_recherche').val(data[0].raison_sociale);
                $('#type_recherche').val(data[0].type);
                $('#siret_recherche').val(data[0].siret);
                $('#numero_rna_recherche').val(data[0].numero_rna);
                $('#numero_uai_recherche').val(data[0].numero_uai);
                $('#personne_morale').val(data[0].id);
                do_recherche(  data[0].id, "personne_morale" );


            }else if(typeof(data) != "undefined" && data.length > 1){

                // Retrait du 16 résultat et affichage d'un message
                $("#nombre_max").hide();
                if( data.length > 15 ){
                    $("#nombre_max").show();
                    data.splice(14, 1);
                }
                $('#type_block').val('personne_morale');
                $('#modal-individu-body').empty();
                $('#titre_modal_trouve').text('Profils trouvés');
                $('#modal-demandeur').modal();

                //affichage de la modale resutats des personne morale trouvé en btn radio
                for (let index = 0; index < data.length; index++) {
                    const element = data[index];

                    var input = document.createElement("input");
                    input.type = "radio";
                    input.id = String(data[index].id) + "_recherche";
                    input.name = "individu_trouve";
                    input.value = data[index].id;
                    input.className = "input_individu_trouve";
                    input.style.verticalAlign = 'top';
                    input.style.marginTop = '3px';
                    var label = document.createElement("label");
                    label.setAttribute("for", String(data[index].id) + "_recherche");
                    label.innerHTML = '<p>' +  data[index].raison_sociale +
                        "<p style='font-style:italic;font-weight:400;margin-left:20px'>" + (data[index].siret.length != 0 ? "Siret : " + data[index].siret : "") +
                        (data[index].numero_uai.length != 0 ? ", Numéro UAI : " + data[index].numero_uai : "") +
                        (data[index].numero_rna.length != 0 ? ", Numéro RNA : " + data[index].numero_rna : "") + "</p>";
                        var container = document.getElementById('modal-individu-body');
                    var div_input = document.createElement("div");
                    div_input.setAttribute("id",  "block_result_" + String(data[index].id) );

                    div_input.appendChild(input);
                    div_input.appendChild(label);
                    container.appendChild(div_input);

                    //auto-remplissage des champs :

                    //raison_social
                    var input_raison_social = document.createElement("input");
                    input_raison_social.type = "hidden";
                    input_raison_social.id = String(data[index].id) + "_raison_sociale_recherche";
                    input_raison_social.name = "raison_sociale_individu_trouve";
                    input_raison_social.value = data[index].raison_sociale;
                    input_raison_social.className = "input_raison_sociale_individu_trouve";

                    var container_raison_social = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_raison_social);
                    container_raison_social.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_raison_social.id) ).attr('rel' , 'raison_sociale_recherche' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

                    //type
                    var input_type = document.createElement("input");
                    input_type.type = "hidden";
                    input_type.id = String(data[index].id) + "_type_recherche";
                    input_type.name = "type_individu_trouve";
                    input_type.value = data[index].type;
                    input_type.className = "input_type_individu_trouve";

                    var container_type = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_type);
                    container_type.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_type.id) ).attr('rel' , 'type_recherche' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.


                    //siret
                    var input_siret = document.createElement("input");
                    input_siret.type = "hidden";
                    input_siret.id = String(data[index].id) + "_siret_recherche";
                    input_siret.name = "siret_individu_trouve";
                    input_siret.value = data[index].siret;
                    input_siret.className = "input_siret_individu_trouve";

                    var container_siret = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_siret);
                    container_siret.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_siret.id) ).attr('rel' , 'siret_recherche' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

                    //numero_rna
                    var input_numero_rna = document.createElement("input");
                    input_numero_rna.type = "hidden";
                    input_numero_rna.id = String(data[index].id) + "_numero_rna_recherche";
                    input_numero_rna.name = "numero_rna_individu_trouve";
                    input_numero_rna.value = data[index].numero_rna;
                    input_numero_rna.className = "input_numero_rna_individu_trouve";

                    var container_numero_rna = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_numero_rna);
                    container_numero_rna.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_numero_rna.id) ).attr('rel' , 'numero_rna_recherche' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

                    //numero_uai
                    var input_numero_uai = document.createElement("input");
                    input_numero_uai.type = "hidden";
                    input_numero_uai.id = data[index].id + "_numero_uai_recherche";
                    input_numero_uai.name = "numero_uai_individu_trouve";
                    input_numero_uai.value = data[index].numero_uai;
                    input_numero_uai.className = "input_numero_uai_individu_trouve";

                    var container_numero_uai = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_numero_uai);
                    container_numero_uai.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_numero_uai.id) ).attr('rel' , 'numero_uai_recherche' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.

                    //id
                    var input_id = document.createElement("input");
                    input_id.type = "hidden";
                    input_id.id = data[index].id;
                    input_id.name = "id_personne_morale_trouve";
                    input_id.value = data[index].id;
                    input_id.className = "input_id_personne_morale_trouve";
                    var container_id = document.getElementById('modal-individu-body');

                    div_input.appendChild(input_id);
                    container_id.appendChild(div_input);

                    $( 'input[type="hidden"]#'+ String(input_id.id) ).attr('rel' , 'personne_morale' ); // Affecte dans l'attribut 'rel' la propriété ID du champ de la view form.
                }
            }else{
                $('#titre_modal_introuvable').text('Profil introuvable');
                $('#paragraphe_modal_introuvable').text("Il n'existe aucun profil répondant à vos critères de recherche");
                $('#modal-introuvable-body-creer').hide();
                $('#modal-introuvable').modal();
            }
        })
        .fail(function (data) {
            $('#titre_modal_introuvable').text('Erreur');
            $('#paragraphe_modal_introuvable').text('Une erreur s\'est produite lors de la recherche');
            $('#modal-introuvable-body-creer').hide();
            $('#modal-introuvable').modal();
        })
        .always(function (req) {

            setTimeout( function(){
                OdeLoadingHelper.removeSpinner();
                OdeLoadingHelper.hideOverlay();
            } , 220 );

        });
    }

}

function reset_champs(type_block) {

    $("#nombre_max").hide();

    if (type_block == 'recherche') {
        $('#champs_recherche :input').val('');
        $('#rechercher').prop('disabled', false);
        $("#vider").prop('disabled', true);
    }
    else if(type_block == 'personne_morale'){
        $('#champs_recherche_personne_morale :input').val('');
        $('#rechercher_personne_morale').prop('disabled', false);
        $("#vider_personne_morale").prop('disabled', true);
    }
    else if(type_block == 'beneficiaire'){
        $('#champs_recherche_beneficiaire :input').val('');
        $('#rechercher_beneficiaire').prop('disabled', false);
        $("#vider_beneficiaire").prop('disabled', true);
    }
    else {
        $('#creation_individu :input').val('');
    }

    $('.btn_suivant_dossier').prop('disabled', true);

    // Retrait de la recherche des profils/bénéficiaire/demandeur 
    $('#champs_recherche').show();
    $('#btn_modal_search_demandeur').show();
    $('#list_demandeur')[0].style.display = "none";
    $('#demandeur').val("");
    $('#demandeur_liste :input').val('');

    removeOptions(document.getElementById('selection_demandeur'));

    if( document.getElementById('personne_morale')  ){

        $('#profil_liste :input').val('');
        $('#personne_morale').val("");
        $('#champs_recherche_personne_morale').show();
        $('#btn_modal_search_personne_morale').show();
        $('#list_profil')[0].style.display = "none";
        removeOptions(document.getElementById('selection_profil'));
    }

    if( document.getElementById('beneficiaire')  ){
        $('#beneficiaire_liste :input').val('');
        $('#beneficiaire').val("");
        $('#champs_recherche_beneficiaire').show();
        $('#btn_modal_search_beneficiaire').show();
        $('#list_beneficiaire')[0].style.display = "none";
        removeOptions(document.getElementById('selection_beneficiaire'));
    }

}

function verif_champs_obligatoires(type_block) {
    var array_champs = this.get_valeurs_champs_recherche(type_block);

    if (Object.keys(array_champs).length == 0  || ( Object.keys(array_champs).length == 1 && array_champs.type !== undefined )) {
        alert('Veuillez saisir au moins un critère de recherche.');
        return false;
    } else if (Object.keys(array_champs).length != 0 ) {
        
        var error_msg = "";

        //Individu
        if ( (array_champs.first_name !== undefined && array_champs.first_name.length > 0 && array_champs.first_name.length < 3 ) 
            || ( array_champs.first_name_beneficiaire !== undefined && array_champs.first_name_beneficiaire.length > 0 && array_champs.first_name_beneficiaire.length < 3 ) ) {
            error_msg += '\n- Prénom';
        }

        if ( ( array_champs.last_name !== undefined && array_champs.last_name.length > 0 && array_champs.last_name.length < 3 ) 
            || ( array_champs.last_name_beneficiaire !== undefined && array_champs.last_name_beneficiaire.length > 0 && array_champs.last_name_beneficiaire.length < 3 ) ) {
            error_msg += '\n- Nom';
        }
        
        if ( (array_champs.date_naissance !== undefined && array_champs.date_naissance.length > 0 && array_champs.date_naissance.length < 3 ) 
            || ( array_champs.date_naissance_beneficiaire !== undefined && array_champs.date_naissance_beneficiaire.length > 0 && array_champs.date_naissance_beneficiaire.length < 3 ) ) {
            error_msg += '\n- Date de naissance';
        }

        if ( (array_champs.telephone !== undefined && array_champs.telephone.length > 0 && array_champs.telephone.length < 3 ) 
            || ( array_champs.telephone_beneficiaire !== undefined && array_champs.telephone_beneficiaire.length > 0 && array_champs.telephone_beneficiaire.length < 3 ) ) {
            error_msg += '\n- Téléphone';
        }

        if ( (array_champs.email !== undefined && array_champs.email.length > 0 && array_champs.email.length < 3 ) 
            || ( array_champs.email_beneficiaire !== undefined && array_champs.email_beneficiaire.length > 0 && array_champs.email_beneficiaire.length < 3 ) ) {
            error_msg += '\n- Email';
        }

        //Personne morale
        if (array_champs.raison_sociale !== undefined && array_champs.raison_sociale.length > 0 && array_champs.raison_sociale.length < 3) {
            error_msg += '\n- Raison sociale';
        }
       
        if (array_champs.siret !== undefined && array_champs.siret.length > 0 && array_champs.siret.length < 3) {
            error_msg += '\n- Siret';
        }

        if (array_champs.numero_rna !== undefined && array_champs.numero_rna.length > 0 && array_champs.numero_rna.length < 3) {
            error_msg += '\n- Numéro RNA';
        }

        if (array_champs.numero_uai !== undefined && array_champs.numero_uai.length > 0 && array_champs.numero_uai.length < 3) {
            error_msg += '\n- Numéro UAI';
        }
        if (error_msg != "") {
            alert('Veuillez saisir au moins 3 caractères dans le champ suivant :' + error_msg);
            return false;

        } else {
            return true;

        }
        return true;


    } else {
        if (typeof array_champs.last_name.length != "undefined" && array_champs.last_name.length < 3) {}
        return true;

    }
}

function get_valeurs_champs_recherche(type_block) {
    var array_valeurs_champs = {};

    if (type_block == 'recherche') {
        $('#champs_recherche :input').each(function () {
            if (this.value != "") {
                id = this.id.replace('_recherche', '');
                if ( id == 'salutation'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'last_name'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'nom_usage'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'first_name'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'date_naissance'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'telephone'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'email'){
                    array_valeurs_champs[id] = this.value;
                }
            }
        });
    }else if (type_block == 'beneficiaire') {
        $('#champs_recherche_beneficiaire :input').each(function () {
            if (this.value != "") {

                id = this.id.replace('_recherche', '');

                if ( id == 'salutation_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'last_name_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'nom_usage_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'first_name_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'date_naissance_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'telephone_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
                if ( id == 'email_beneficiaire'){
                    array_valeurs_champs[id] = this.value;
                }
            }
        });
    }else if(type_block == 'personne_morale'){
        $('#champs_recherche_personne_morale :input').each(function () {
            if (this.value != "") {
                id = this.id.replace('_recherche', '');

                if ( id == 'raison_sociale'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'type'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'siret'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'numero_rna'){
                    array_valeurs_champs[id] = this.value;
                }

                if ( id == 'numero_uai'){
                    array_valeurs_champs[id] = this.value;
                }
            }


        });

        //Personne morale
        if ( typeof array_valeurs_champs.type == "undefined" ) {
            var params = JSON.parse(atob($('#dispositif-param').val()));
            array_valeurs_champs.type = params.type_tier ; 
        }
    }

    return array_valeurs_champs;
}

function save_modal_recherche(type_block) {

    if( type_block == "" ){
        type_block = $('#type_block').attr('rel'); 
    }              


    var radioValue = ($("input[name='individu_trouve']:checked").val())?$("input[name='individu_trouve']:checked").val():$("input[name='individu_introuvable']:checked").val();
    if (typeof radioValue != "undefined") {

        if(radioValue == 'individu_non_trouve' || radioValue == 'individu_introuvable'){

    
            if( type_block == "" || type_block != "beneficiaire" ){

                // On récupère les infos du demandeur 
                $('#modal-creer-individu-body input, #modal-creer-individu-body select').each(function () {
                    $(this).val('');

                    var champ = $(this).attr('id').replace('creer_individu_', '')+'_recherche';
                    
                    if($(this).attr('id') == 'creer_individu_last_name' || $(this).attr('id') == 'creer_individu_nom_usage'){
                        $(this).val($('#'+champ).val().toUpperCase());
                    }else if($(this).attr('id') == 'creer_individu_first_name'){
                        $(this).val($('#'+champ).val().charAt(0).toUpperCase() + $('#'+champ).val().substring(1).toLowerCase());
                    }
                    else{
                        $(this).val($('#'+champ).val());
                    }
                });

            }
            else{

                 // On récupère les infos du beneficiaire 
                $('#modal-creer-individu-body input, #modal-creer-individu-body select').each(function () {
                    $(this).val('');
                    var champ = $(this).attr('id').replace('creer_individu_', '')+'_beneficiaire_recherche';
                    if($(this).attr('id') == 'creer_individu_last_name' || $(this).attr('id') == 'creer_individu_nom_usage'){
                        $(this).val($('#'+champ).val().toUpperCase());
                    }else if($(this).attr('id') == 'creer_individu_first_name'){
                        $(this).val($('#'+champ).val().charAt(0).toUpperCase() + $('#'+champ).val().substring(1).toLowerCase());
                    }
                    else{
                        $(this).val($('#'+champ).val());
                    }
                });


            }

            $('#creation_demandeur_modal').show();
            $('.creer_individu_erreur').hide();
            $('.creer_individu_erreur').hide();
            $('#modal-creer-individu').modal();
            $('#modal-demandeur').modal('hide');
            $('#modal-introuvable').modal('hide');

        }else{

            $('#block_result_' + String(radioValue) + ' input[type="hidden"]').each(function ( i,o ) {
                let _source_field = $(o);
                _relation_field_id = _source_field.attr('rel');
                $('#'+ _relation_field_id ).val(  _source_field.val() );
                $('#modal-demandeur').modal('hide');
            });

            do_recherche(radioValue, document.getElementById(String(radioValue)).attributes.rel.value) ;
           
            // L'individu a été séléctionné 
            //Dans le cas d'un particulier => Si le dispositif est uniquement pour un particulier on passe direct à la création d'un dossier #4761
            var params = JSON.parse(atob($('#dispositif-param').val()));

            //Dans le cas d'un particulier => Si le dispositif est uniquement pour un particulier on passe direct à la création d'un dossier #4761
            if( params.type_tier == "" || ( params.type_beneficiare.length == 1 && params.type_beneficiare[0] == "individu" ) ){
                redirect_dossier() ; 
            }
        }

    }
}

function do_recherche(radioValue, type){


    var params = JSON.parse(atob($('#dispositif-param').val()));

    if( params.type_beneficiare.length > 1 || params.type_beneficiare[0] == "personne_morale"){

        // Traitement de la récupération des informations 
        $('#champs_recherche_personne_morale').hide();
        $('#champs_recherche').hide();
        $('#btn_modal_search_personne_morale').hide();
        $('#btn_modal_search_demandeur').hide();
        $('#list_demandeur')[0].style.display = "block";
        $('#list_profil')[0].style.display = "block";

        if( params.beneficiaire == 1){
            $('#champs_recherche_beneficiaire').hide();
            $('#btn_modal_search_beneficiaire').hide();
            $('#list_beneficiaire')[0].style.display = "block";
        }

        // L'utilisateur a choisi un demandeur => affichage des profils avant les bénéficiaires 
        if( type == "demandeur" ){

            $('#champs_recherche').show();
            $('#btn_modal_search_demandeur').show();
            search_profils( String(radioValue) ); 
            $('#list_demandeur')[0].style.display = "none";
            $('#rechercher').prop('disabled', true);
            $("#vider").prop('disabled', false);
        }
        if( type == "beneficiaire" ){
            $('#champs_recherche_beneficiaire').show();
            $('#btn_modal_search_beneficiaire').show();

            search_profils( String(radioValue) ); 

            $('#rechercher_beneficiaire').prop('disabled', true);
            $("#vider_beneficiaire").prop('disabled', false);
            
            $('#list_beneficiaire')[0].style.display = "none";

        }
        if( type == "personne_morale" ){
            $('#champs_recherche_personne_morale').show();
            $('#btn_modal_search_personne_morale').show();

            search_individus( String(radioValue) );

            $('#rechercher_personne_morale').prop('disabled', true);
            $("#vider_personne_morale").prop('disabled', false);

            if( params.beneficiaire == 1 ){
                search_beneficiaire( String(radioValue), $('#type_individu_beneficiaire_recherche').val() );
            }            
            $('#list_profil')[0].style.display = "none";
        }
        //Activation du bouton suivant
        if( ($('#demandeur').val() != "" && params.type_beneficiare.find(element => element == 'individu') && ( params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() == ""))
            || params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != "" && $('#beneficiaire').val() != "" && params.beneficiaire == 1
            || params.beneficiaire == 0 && params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != ""
            ){

            //Dans le cas d'un particulier => Si le dispositif est uniquement pour un particulier on passe direct à la création d'un dossier #4761
            if( params.type_tier == "" || ( params.type_beneficiare.length == 1 && params.type_beneficiare[0] == "individu" ) ){
                redirect_dossier() ; 
            }
            $('.btn_suivant_dossier').prop('disabled', false);
        }
    }else{
        $('#rechercher').prop('disabled', true);
        $("#vider").prop('disabled', false);
        $('.btn_suivant_dossier').prop('disabled', false);
    }

}


// Mise automatique de la recherche 
function search_profils( id_individu ){

    // Récupération des types de profils pour ce dispositif 
    var params = JSON.parse(atob($('#dispositif-param').val()));
    var type_tiers = params.type_tier ; 

    // Recherche des profils en fonction du demandeur et des profils possible 
    $.ajax({
        type:"POST",
        url:'index.php?module=OPS_dossier&action=get_profils',
        dataType: 'json',
        data: {
            id_individu: id_individu,
            type_tiers : type_tiers
        }
    })
    .done(function (data) {

        data = Object.values(data);

        if(  data[0]  == "ko" ){
            alert("Aucun profil rattaché à cet individu, veuillez créer un profil.");
        }
        else{
            removeOptions(document.getElementById('selection_profil'));
            var option = new Option ("--- Sélectionner ---" ,"");
            document.getElementById("selection_profil").options.add ( option );       

            profil_liste = data[1] ;

            // Ajout des profils dans le select : 
            for (const [key, value] of Object.entries(data[1])) {
                var select = document.getElementById ("selection_profil");
                var entrie = new Option (value.name, key);
                select.options.add( entrie );       
            }
        }

    })
    .fail(function (data) {
        console.log( "Erreur récupération des profils")
    })
    .always(function (req) {
        setTimeout( function(){
            OdeLoadingHelper.removeSpinner();
            OdeLoadingHelper.hideOverlay();
        } , 220 );
    });

}

function search_individus( id_profil){

    var params = JSON.parse(atob($('#dispositif-param').val()));

    // Recherche des individus en fonction d'un profil
    $.ajax({
        type:"POST",
        url:'index.php?module=OPS_dossier&action=get_individus',
        dataType: 'json',
        data: {
            id_profil: id_profil,
        }
    })
    .done(function (data) {

        data = Object.values(data);

        if(  data[0]  == "ko" ){
            alert("Aucun individu rattaché, veuillez rattacher un individu.");
        }
        else{
            if( $("#demandeur").val().length != 36 ){

                removeOptions(document.getElementById('selection_demandeur'));
                var option = new Option ("--- Sélectionner ---" ,"");
                document.getElementById("selection_demandeur").options.add( option );       

                // Ajout des individus dans le select demandeur : 
                individus_liste = data[1] ;
                for (const [key, value] of Object.entries(individus_liste)) {
                    document.getElementById ("selection_demandeur").options.add( new Option (value.last_name + " " + value.first_name , key) );       
                }
            }
        }
    })
    .fail(function (data) {
        console.log( "Erreur récupération des profils");
        
    })
    .always(function (req) {
        setTimeout( function(){
            OdeLoadingHelper.removeSpinner();
            OdeLoadingHelper.hideOverlay();
        } , 220 );
    });


}

function search_beneficiaire( id_profil, type_individu ){
    var params = JSON.parse(atob($('#dispositif-param').val()));

    // Recherche des individus en fonction d'un profil
    $.ajax({
        type:"POST",
        url:'index.php?module=OPS_dossier&action=get_individus_by_types',
        dataType: 'json',
        data: {
            id_profil: id_profil,
            type_individu: type_individu,
        }
    })
    .done(function (data) {

        data = Object.values(data);

        if(  data[0]  == "ko" ){
            alert("Aucun individu rattaché, veuillez rattacher un individu.");
        }
        else{
            // Ajout des individus dans le select Bénéficiaire 
            var option = new Option ("--- Sélectionner ---" ,"");
            if( params.beneficiaire == 1 && search_beneficiaire){
                
                removeOptions(document.getElementById('selection_beneficiaire'));
                var option = new Option ("--- Sélectionner ---" ,"");
                document.getElementById("selection_beneficiaire").options.add( option );       
                individus_liste = data[1] ;

                for (const [key, value] of Object.entries(individus_liste)) {
                    document.getElementById ("selection_beneficiaire").options.add( new Option (value.last_name + " " + value.first_name , key) );       
                }
            }
        }
    })
    .fail(function (data) {
        console.log( "Erreur récupération des profils");
        
    })
    .always(function (req) {
        setTimeout( function(){
            OdeLoadingHelper.removeSpinner();
            OdeLoadingHelper.hideOverlay();
        } , 220 );
    });


}

function selection_profil()
{
    var params = JSON.parse(atob($('#dispositif-param').val()));

    // Choix d'un profil : on remplit les champs 
    profil = profil_liste[document.getElementById("selection_profil").value];

    document.getElementById( "select_type" ).value = (profil.type_profil) ? profil.type_profil : "";
    document.getElementById( "select_siret" ).value = (profil.siret) ? profil.siret : "";
    document.getElementById( "select_rna" ).value = (profil.select_rna) ? profil.select_rna : "";
    document.getElementById( "select_uai" ).value = (profil.code_rne) ? profil.code_rne : "";

    // On récupére les bénéficiaires 
    if( params.beneficiaire == 1){
        search_beneficiaire( profil.id, $('#type_individu_beneficiaire_recherche').val() ); 
    }

    // Mise au choix du profil
    $('#personne_morale').val(profil.id);

    if($('#list_demandeur').css('display') !== 'none'){
        refresh_demandeur()
    }

    //Activation du bouton suivant
    if( ($('#demandeur').val() != "" && params.type_beneficiare.find(element => element == 'individu') && ( params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() == ""))
        || params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != "" && $('#beneficiaire').val() != "" && params.beneficiaire == 1
        || params.beneficiaire == 0 && params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != ""
        ){
        $('.btn_suivant_dossier').prop('disabled', false);
    }

}
function selection_individu( type ){ // Type = benficiaire || demandeur 

    var params = JSON.parse(atob($('#dispositif-param').val()));

    // Choix d'un individu : on remplit les champs 
    individu = individus_liste[document.getElementById("selection_"+type).value];

    document.getElementById( "select_first_name_"+type ).value = individu.first_name;
    document.getElementById( "select_last_name_"+type ).value = (individu.last_name) ? individu.last_name : "";
    document.getElementById( "select_date_naissance_"+type ).value = (individu.date_naissance) ? individu.date_naissance : "";

    // Mise au choix du profil
    $('#'+type).val(individu.id);

    //Activation du bouton suivant
    if( ($('#demandeur').val() != "" && params.type_beneficiare.find(element => element == 'individu') && ( params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() == ""))
        || params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != "" && $('#beneficiaire').val() != "" && params.beneficiaire == 1
        || params.beneficiaire == 0 && params.type_beneficiare.find(element => element == 'personne_morale') && $('#personne_morale').val() != "" && $('#demandeur').val() != ""
        ){
        $('.btn_suivant_dossier').prop('disabled', false);
    }
}



function removeOptions(selectElement) {
   var i, L = selectElement.options.length - 1;
   for(i = L; i >= 0; i--) {
      selectElement.remove(i);
   }
}


function refresh_demandeur(){

    OdeLoadingHelper.addSpinner();
    search_individus( $('#personne_morale').val() ); 

}


function refresh_beneficiaire(){

    OdeLoadingHelper.addSpinner();
    search_beneficiaire( $('#personne_morale').val(), $('#type_individu_beneficiaire_recherche').val() ); 

}

function refresh_profil(){

    if( $('#beneficiaire').val() != "" && typeof $('#beneficiaire').val() != 'undefined' ){
        var id_individu = $('#beneficiaire').val() ; 
    }
    else{
        var id_individu = $('#demandeur').val() ; 

    }

    OdeLoadingHelper.addSpinner();
    search_profils( id_individu ); 
}

function creer_individu(type_block){
    if( typeof($('#type_block').attr('rel')) != "undefined" && $('#type_block').attr('rel') != "" ){
        type_block = $('#type_block').attr('rel'); 
    }

    var check = true;

    if(!$('#creer_individu_last_name').val()){
        $( $('#creer_individu_last_name').parent().parent().children()[0] ).find('.creer_individu_erreur').show();
        check = false;
    }else{
        $( $('#creer_individu_last_name').parent().parent().children()[0] ).find('.creer_individu_erreur').hide();
    }
    if(!$('#creer_individu_first_name').val()){
        $( $('#creer_individu_first_name').parent().parent().children()[0] ).find('.creer_individu_erreur').show();
        check = false;
    }else{
        $( $('#creer_individu_first_name').parent().parent().children()[0] ).find('.creer_individu_erreur').hide();
    }

    if(check){
        var array_champs = {};
        $('#modal-creer-individu-body input, #modal-creer-individu-body select').each(function () {
            if (this.value != "") {
                var id = this.id.replace('creer_individu_', '');
                array_champs[id] = this.value;
            }
        });
        $.ajax({
                type:"POST",
                url:'index.php?module=OPS_dossier&action=creer_individu',
                dataType: 'json',
                data: {
                    array_champs: array_champs
                }
            })
            .done(function (data) {

                if(typeof(data) != "undefined"){

                    if(type_block == 'recherche'){
                        $('#demandeur').val(data);
                        $('#creation_demandeur').hide();
                        $('#salutation_recherche').val(array_champs['salutation']);
                        $('#last_name_recherche').val(array_champs['last_name']);
                        $('#nom_usage_recherche').val(array_champs['nom_usage']);
                        $('#first_name_recherche').val(array_champs['first_name']);
                        $('#date_naissance_recherche').val(array_champs['date_naissance']);
                        $('#telephone_recherche').val(array_champs['telephone']);
                        $('#email_recherche').val(array_champs['email']);
                        


                        // On a réussi à créer l'individu :
                        var params = JSON.parse(atob($('#dispositif-param').val()));
                        //Dans le cas d'un particulier => Si le dispositif est uniquement pour un particulier on passe direct à la création d'un dossier #4761
                        if( params.type_tier == "" || ( params.type_beneficiare.length == 1 && params.type_beneficiare[0] == "individu" ) ){
                            redirect_dossier() ; 
                        }
                        else{
                            call_ajax_recherche(type_block);
                        }
                    }else if(type_block == 'beneficiaire'){
                        $('#beneficiaire').val(data);
                        $('#salutation_beneficiaire_recherche').val(array_champs['salutation']);
                        $('#last_name_beneficiaire_recherche').val(array_champs['last_name']);
                        $('#nom_usage_beneficiaire_recherche').val(array_champs['nom_usage']);
                        $('#first_name_beneficiaire_recherche').val(array_champs['first_name']);
                        $('#date_naissance_beneficiaire_recherche').val(array_champs['date_naissance']);
                        $('#telephone_beneficiaire_recherche').val(array_champs['telephone']);
                        $('#email_beneficiaire_recherche').val(array_champs['email']);
                        
                        call_ajax_recherche(type_block);

                    }
                }else{

                    $('#titre_modal_introuvable').text('Erreur');
                    $('#paragraphe_modal_introuvable').text('Une erreur s\'est produite lors de la création');
                    if(type_block == 'recherche'){
                        $('#modal-introuvable-body-creer').show();
                    }else if(type_block == 'beneficiaire'){
                        $('#modal-introuvable-body-creer').hide();
                    }
                    $('#modal-introuvable').modal();
                    $('#modal-creer-individu').modal('hide');


                }
            })
            .fail(function (data) {
                $('#titre_modal_introuvable').text('Erreur');
                $('#paragraphe_modal_introuvable').text('Une erreur s\'est produite lors de la création');
                if(type_block == 'recherche'){
                    $('#modal-introuvable-body-creer').show();
                }else if(type_block == 'beneficiaire'){
                    $('#modal-introuvable-body-creer').hide();
                }
                $('#modal-introuvable').modal();
            })
            .always(function (req) {
                setTimeout( function(){
                    OdeLoadingHelper.removeSpinner();
                    OdeLoadingHelper.hideOverlay();
                } , 220 );

            });
            $('#modal-creer-individu').modal('hide');
    }
}