// Initialisation de la navigation
const ON = new GenerateurNavigation();

// Fonction de navigation entre les onglets 
function displayOnglet( onglet_id ){
    ON.route( onglet_id )
}

function deleteDossier(){
    if ( window.confirm(" Êtes-vous sûr de vouloir supprimer ce dossier ? ") ){
        execute('deleteDossier','OPS_dossier');
    }
}

// Fonction au changement du statut 
function onChangeSelectStatut(){
    $("#action_id").css( "border", "1px solid rgb(165, 232, 214)" );
}

/**------------------------------------------------------------------------- Fonctions Ajax ------------------------------------------------------------------- */

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionDetail = {
    deleteDossier: function(data) {
        if (data) {
            console.log(' deleteDossier() => retourFunction data = ',data)
            if( data['statut'] == "ok" ){
                if(data['data']['id']){
                    // On redirige vers la vue liste dossiers
                    var redirect = "/index.php?module=OPS_dossier";
                    window.location.replace(redirect);
                }
            }else{
                console.log(' deleteDossier() => Erreur retour ')
            }
        } else {
            console.log(" deleteDossier() => format de retour différent de JSON ")
        }
    },
    editStatut: function(data) {
        if (data) {
            console.log(' editStatut() => retourFunction data = ',data)
            if( data['statut'] == "ok" ){
                if( data['data']['id'] ){
                    // On redirige vers la vue détail du dossier pour recharger la ligne du workflow
                    var redirect = "/index.php?module=OPS_dossier&action=DetailView&record=" + data['data']['id'];
                    window.location.replace(redirect);
                }
            }else{
                console.log(' editStatut() => Erreur retour ')
            }
        } else {
            console.log(" editStatut() => format de retour différent de JSON ")
        }
    },
};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionDetail : Object.assign(retourFunction, retourFunctionDetail);

// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionDetail = {
    deleteDossier: function() {
        console.log("loadingFunction => deleteDossier")
    },
    editStatut: function() {
        console.log("loadingFunction => editStatut")
    },
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionDetail : Object.assign(loadingFunction, loadingFunctionDetail);

// Cette variable regroupe les differentes fonctions de récupération des données à envoyer au PHP
var getDataFunctionDetail = {
    deleteDossier: function() {
        console.log("getDataFunction => deleteDossier")
        var dossier_id =  getDossierId();
        var data = (isStringValid(dossier_id)) ? "dossier_id=" + dossier_id : false;
        return data;
    },
    editStatut: function() {
        console.log("getDataFunction => editStatut")
        var dossier_id =  getDossierId();
        var statut_id =  getSelectValue("action_id");
        if( statut_id === "disabled" ) {
            // On affiche erreur selection statut
            $("#action_id").css( "border", "1px solid red" );
            return false;
        } else {
            $("#action_id").css( "border", "1px solid rgb(165, 232, 214)" );
            return ( isStringValid(dossier_id) && isStringValid(statut_id) ) ? "dossier_id=" + dossier_id + "&statut_id=" + statut_id : false;
        }
    },
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionDetail : Object.assign(getDataFunction, getDataFunctionDetail);
/**-------------------------------------------------------------------------------------------------------------------------------------------------------- */


function getDossierId() {
    if ($_GET('record')) {
        return $_GET('record');
    } else {
        return false;
    }
}