<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Model\DossierModel;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;
use ODE\Helper\OdeDateHelper;
use ODE\Modal\OdeModal;
use ODE\NavButton\OdeNavButton;
use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\ActionStatut\OdeActionStatut;
use ODE\Model\GenerateurVueModel;
use ODE\Surcharge\TraitementViewMetadata;

class OPS_dossierViewDetail extends ViewDetail
{
    
    public $erreurs;
    
    public function __construct()
    {
        parent::__construct();
    }
    
    function display()
    {
        
        global $app_strings;
        if (empty($this->bean->id)) {
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }
        
        $donnees = [];
        $smarty           = new Sugar_Smarty();
        $current_template = "custom/include/helpers/erreurs/erreur.tpl";
        
        do {
            
            if (empty($this->bean->id)) {
                $GLOBALS['log']->fatal(" view.detail.php :: display => Le dossier n'a pas pu être récupéré. ");
                break;
            } else {
                $smarty->assign("dossier_id", $this->bean->id);
                $smarty->assign("dossier_offset", intval($_GET['offset']));
                $smarty->assign("dossier_name", $this->bean->name);
                $smarty->assign("brouillon", $this->bean->brouillon);
            }
            
            // Barre de commande dossier
            $dossier_boutons        = $this->getLinksVueDossier($this->bean);
            $dossier_barre_boutons  = (is_array($dossier_boutons)) ? implode('', array_values($dossier_boutons)) : "";
            $dossier_ligne_workflow =($this->bean->brouillon == "non") ?  $this->getLigneWorkflowVueDossier($this->bean) : "" ; 
            $smarty->assign("dossier_boutons", $dossier_barre_boutons);
            $smarty->assign("dossier_ligne_workflow", $dossier_ligne_workflow);
            
            
            $DossierModel   = new DossierModel($this->bean->id);
            $dispositif_id  = $DossierModel->getDispositifId();
            $demandeur_id   = $DossierModel->getDemandeurId();
            $demandeur_type = $DossierModel->getDemandeurType();
            if (empty($demandeur_id) || empty($demandeur_type)) {
                $GLOBALS['log']->fatal(" view.detail.php :: display => Le demandeur associé au dossier id = " . $this->bean->id . " est introuvable");
                break;
            } else {
                    $donnees["demandeur"] = ["id" => $demandeur_id, "type" => $demandeur_type]; 
            }
            
            $DispositifModel = new DispositifModel($dispositif_id);
            $dispositif      = $DispositifModel->getBean();
            if (!is_array($dispositif) || count($dispositif) === 0) {
                $GLOBALS['log']->fatal(" view.detail.php :: display => Le dispositif id = " . $dispositif_id . " est introuvable");
                break;
            } else {
                $donnees["dispositif"] = ["id" => $dispositif["id"], "name" => $dispositif["name"]];
            }
            
            // On récupere la vue agent du formulaire associé au dispositif
            $formulaire_id             = $DispositifModel->getFormulaireId();
            $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
            $agent_vue_id              = $GenerateurFormulaireModel->getVueAgentId();
            if (empty($agent_vue_id)) {
                $GLOBALS['log']->fatal(" view.detail.php :: display => La vue agent associé formulaire id = " . $formulaire_id . " est introuvable");
                break;
            } else {
                $donnees["vue"] = ["id" => $agent_vue_id, "type" => "agent"];
                $generateurVueModel = new GenerateurVueModel($agent_vue_id);
                $conditions = $generateurVueModel->getChampsConditions();
            }
            
            $typeProfil = '';
            if(!empty($this->bean->ops_personne_morale)){
                $personneMoralObj = BeanFactory::getBean('OPS_personne_morale',$this->bean->ops_personne_morale);
                $typeProfil = $personneMoralObj->ops_type_personne_id;
            }

            $params_html = '<input type="hidden" id="ops_personne_morale" name="ops_personne_morale" value="' . $this->bean->ops_personne_morale . '"/>
                            <input type="hidden" id="dispositif" name="dispositif" value="' . $dispositif_id . '"/>
                            <input type="hidden" id="demandeur" name="demandeur" value="' . $this->bean->ops_individu_id . '"/>
                            <input type="hidden" id="beneficiaire_id" name="beneficiaire_id" value="' . $this->bean->beneficiaire_id . '"/>
                            <input type="hidden" id="ops_type_personne" name="ops_type_personne" value="' . $typeProfil . '"/>
                            <input type="hidden" id="conditions" name="conditions" value="'.$conditions.'"/>';
            
            $obj_generateur_formualaire = BeanFactory::getBean('OPS_generateur_formulaire',$formulaire_id);
            $onglets_html = "";

            $contenue = '';
            
            if ($obj_generateur_formualaire->couverture) {
                
                $onglets_html .= '<li style="width:auto"><a href="#" class="active" style="padding: 11px 15px;"><i class="fas fa-house-user fa-2x" ></i></a></li>';
                
                $onglets_contenus = '<div id="onglet_" role="onglet-formulaire" data-conditions="" class="onglet-layout" style="">';
                $contenue         = $this->remplace_champs($obj_generateur_formualaire->description);
                
            }else{
                $params_html .= '<input type="hidden" id="no_couverture" name="no_couverture" value="1"/>';
            }


            $cheminSurcharge = "custom/modules/OPS_dossier/Surcharge/views/";
            $fichiers = TraitementViewMetadata::checkDir('view.detail',$cheminSurcharge);

            if(!empty($fichiers) && is_array($fichiers)){
                foreach ($fichiers as $fichier) {
                    include("$cheminSurcharge$fichier");
                    if(!empty($surchargeClass)){
                        new $surchargeClass($this,$smarty,$contenue);
                    }
                }
            }

            if($contenue){
                $onglets_contenus .= html_entity_decode(str_replace('&nbsp;', ' ', $contenue));
                $onglets_contenus .= '</div>'; 
            }

            $individuObj = BeanFactory::getBean('OPS_individu',$this->bean->ops_individu_id);

            if(!empty($individuObj) && $individuObj->connexion_internet){
                $onglets_html .= '<li id="bouton_tab_fil_conversationnel" style="width:auto" rel="fil_onversationnel" data-record-id="'.$this->bean->id.'">
    	                                <a href="#" id="bouton_fil_conversationnel" class="" style="padding: 12px 15px;display: flex;">
    	                                <!--i class="fa-solid fa-message fa-2x"></i-->
    	                                <svg xmlns="http://www.w3.org/2000/svg" height="24" width="24" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2023 Fonticons, Inc.--><path d="M64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h96v80c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64z"/></svg>
    	                                </a>
                                    </li>';
                $onglets_contenus .= '<div id="onglet_fil_conversationnel" rel="fil_conversationnel" data-record-id="'.$this->bean->id.'" data-record-type="OPS_dossier" role="onglet-formulaire" data-conditions="" class="onglet-layout" style="position:relative; display: none;">';
                $onglets_contenus .= '</div>';
                $params_html .= '<input type="hidden" id="conversation" name="conversation" value="1"/>';
            }
            
            // On récupere le html de la vue de création 
            $viewFactory = new OdeViewFactory($this->bean, false, $donnees);
            $onglets_html .= $viewFactory->getOngletsHtml($obj_generateur_formualaire->couverture);
            
            $smarty->assign('onglets_html', $onglets_html);
            
            $onglets_contenus .= $viewFactory->getContenusHtml();
            
            $smarty->assign('onglets_contenus_html', $onglets_contenus);

            $statut_id = (!empty($this->bean->ops_statut_id)) ? $this->bean->ops_statut_id : "";

            $contenu = $this->actionStatutOnglet($statut_id);

            $smarty->assign('contenu', $contenu);

            $smarty->assign('statut_id', $statut_id);
            
            $smarty->assign('params_html', $params_html);
            
            $current_template = "modules/OPS_dossier/tpls/detail.tpl";
        } while (0);
        
        $smarty->display($current_template);
    }
    
    
    /**
     * @access private
     * @name getLinksVueDossier()
     * Fonction qui retourne les boutons de la vue détail du dossier 
     * 
     *  @param array            $dossier : Bean OPS_dossier
     *  @return string    $dossier_boutons_html : code html , les boutons de la vue détail
     */
    private function getLinksVueDossier($dossier)
    {
        
        global $current_user;
        
        // TODO : Contraindre ou étendre selon les habilitations !
        $dossier_html_boutons = array();
        
        $dossier_html_boutons['edition']       = $this->getBtnModifierDossier($dossier); // On initialise le bouton modifier le dossier 
        $dossier_html_boutons['assignation']   = ($this->bean->brouillon == "non") ? $this->getBtnAssignationDossier($dossier)  : ""; // On initialise le bouton supprimer le dossier 
        $dossier_html_boutons['correction']    = $this->getBtnEditDossier($dossier); // On initialise le bouton modifier le dossier 
        $dossier_html_boutons['duplication']   = ($this->bean->brouillon == "non") ? $this->getBtnDupliquerDossier()  : ""; // On initialise le bouton générer le pdf
        //$dossier_html_boutons['instruction']   = ($this->bean->brouillon == "non") ? $this->getBtnLancerFluxDossier() : ""; // On initialise le bouton lancer flux 
        $dossier_html_boutons['pdf_dynamique'] = ($this->bean->brouillon == "non") ? $this->getBtnGenererPdfDossier() : ""; // On initialise le bouton générer le pdf
        $dossier_html_boutons['suppression']   = $this->getBtnSupprimerDossier($dossier); // On initialise le bouton supprimer le dossier 
        $dossier_html_boutons['execution']     = $this->getBtnExecuterDossier(); // On initialise le bouton executer le dossier 

        # On récupere la liste des boutons custom
        $custom_boutons = OdeNavButton::get([
            'dossier_num' => $this->bean->num_dossier,
            'dossier_id' => $dossier->id
        ]);

        # On boucle sur le tableau pour ajouter les boutons 1 par 1 
        if ( is_array($custom_boutons) && count($custom_boutons) > 0 ) {
            foreach ($custom_boutons as $button ) {
                $dossier_html_boutons[$button->name]   = $this->bean->brouillon == "non" ? $button->html : "";
            }
        }

        $dossier_html_boutons['instruction'] = ($this->bean->brouillon == "non") ? $this->getBtnModifierStatutDossier($dossier) : ""; // On initialise le bouton lancer flux 
        $dossier_html_boutons['date_status']   = ($this->bean->brouillon == "non") ? $this->getBtnAfficheStatutDossier($dossier)  : '' ; // On initialise le bouton lancer flux 
        
        
        // On négocie les éléments contenus dans la barre de commande OPS_dossier.
        // Les habilitations (rôles et privilèges) permettent la distribution des éléments à afficher...
        //
        // L'adminitrateur peut quant à lui disposer de l'ensemble des éléments, les autres utilisateurs sont contitionnés.
        
        if (!$current_user->isAdmin()) {
            
            $dossier_html_boutons['visualisation'] = $this->getCodeRedirectDossier(); // On initialise le code visualiser le dossier 

            
            $habilitation_dispositif = $_SESSION['habilitation_dispositif'];
            
            # Vérification de l'habilitation sur le dispositif associé
            if (!isset($habilitation_dispositif[$dossier->ops_dispositif_id])) {
                
                $privilege = array(
                    'visualisation' => false,
                    'instruction'   => false,
                    'edition'       => false,
                    'suppression'   => false,
                    'assignation'   => false,
                    'execution'     => false,
                    'duplication'   => false,
                    'correction'    => false,
                );
            } else {
                
                // Définit les privilèges par défaut au niveau du dispositif.
                $privilege = array(
                    'visualisation' => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['visualisation'])),
                    'assignation'   => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['assignation'])),
                    'correction'    => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['correction'])),
                    'duplication'   => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['duplication'])),
                    'execution'     => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['execution'])),
                    'instruction'   => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['instruction'])),
                    'edition'       => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['edition'])),
                    'suppression'   => boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['suppression'])),
                );


                // On récupère l'étape du dossier pour les habilitations par étapes

                // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
                $dispositifs = $dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
                $dispositif  = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;
                
                // Récupération du guide d'instruction
                $guide_instructions = ($dispositif !== false) ? $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction') : array();
                $guide_instruction  = (is_array($guide_instructions) && count($guide_instructions) == 1) ? $guide_instructions[0] : false;
                
                // Récupération de la liste des étapes du guide d'instruction
                $liste_des_etapes = ($guide_instruction !== false) ? $guide_instruction->liste_etapes() : array();
                
                // Récupération de l'étape courante pour ne pas afficher les étapes suivantes ou on aurait pu revenir en arrière
                $etape_courante = BeanFactory::getBean('OPS_etape', $dossier->ops_etape_id);

                $obj_statut = BeanFactory::getBean('OPS_statut', $dossier->ops_statut_id);
                $etape_id = $etape_courante->id;

                /*
                // Si le statut est à suivant, on prend l'étape suivante
                if($obj_statut->avancement == 'suivant')
                {
                    $trouverProchain = false;
                    $prochainId = '';

                    foreach ($liste_des_etapes as $etape) {
                        if ($trouverProchain) {
                            $etape_id = $etape['id'];
                            break;
                        }
                        if ($etape['id'] === $etape_courante->id) {
                            $trouverProchain = true;
                        }
                    }
                }
                */

                // (re)Définit les privilèges surchargés prévalant au niveau étape courant pour ce dispositif.
                if (isset($habilitation_dispositif[$dossier->ops_dispositif_id]['etapes'][$etape_id])) {
                    
                    $privilege['visualisation'] = boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['etapes'][$etape_id]['visualisation']));
                    $privilege['instruction'] = boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['etapes'][$etape_id]['instruction']));
                    $privilege['edition'] = boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['etapes'][$etape_id]['edition']));
                }

                // Définit les privilèges par défaut au niveau du dispositif.
                $privilege['assignation'] = boolval(intval($habilitation_dispositif[$dossier->ops_dispositif_id]['assignation']));
            }
            
            if ($current_user->isAdmin()) {
                $dossier_html_boutons['correction'] = $dossier_html_boutons['correction'];
            }
            
            $dossier_html_boutons['visualisation'] = ($privilege['visualisation']) ? '' : $dossier_html_boutons['visualisation']; // reverse
            $dossier_html_boutons['edition']       = ($privilege['edition'])       ? $dossier_html_boutons['edition']       : '';
            $dossier_html_boutons['correction']    = ($privilege['correction'])    ? $dossier_html_boutons['correction']    : '';
            $dossier_html_boutons['duplication']   = ($privilege['duplication'])   ? $dossier_html_boutons['duplication']   : '';
            $dossier_html_boutons['suppression']   = ($privilege['suppression'])   ? $dossier_html_boutons['suppression']   : '';
            $dossier_html_boutons['assignation']   = ($privilege['assignation'])   ? $dossier_html_boutons['assignation']   : '';
            $dossier_html_boutons['execution']     = ($privilege['execution'])     ? $dossier_html_boutons['execution']   : '';
            $dossier_html_boutons['instruction']   = ($privilege['instruction'])   ? $dossier_html_boutons['instruction'] : '';
            $dossier_html_boutons['pdf_dynamique'] = ($privilege['visualisation']) ? $dossier_html_boutons['pdf_dynamique'] : '';

            /*
            if($dossier->assigned_user_id != $current_user->id) {
                $dossier_html_boutons['instruction'] = '';
            }
            */
        }

        return $dossier_html_boutons;
    }
    
    /**
     * @access private
     * @name getCodeRedirectDossier()
     * Fonction qui génére un script JS de redirection si pas de visualisation du dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['visualisation'] : code html , script js
     */
    private function getCodeRedirectDossier()
    {
        return '<script type="text/javascript" charset="UTF-8">self.location.href = "/index.php?module=OPS_dossier&action=index&parentTab=DOssiers";</script>';
    }
    
    /**
     * @access private
     * @name getBtnModifierDossier()
     * Fonction qui génére le bouton modifier le dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['modify'] : code html , bouton modifier
     */
    private function getBtnEditDossier($dossier)
    {
        global $sugar_config;
        return (!empty($dossier->id)) ? '<input title="Editer le dossier" 
                class="button" 
                type="button" 
                value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['corriger']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['corriger']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['corriger'] : 'Corriger').'" 
                onclick="location.href=\'index.php?module=OPS_dossier&action=EditionView&record=' . $dossier->id . '\'">' : '';
    }
    
    
    /**
     * @access private
     * @name getBtnModifierDossier()
     * Fonction qui génére le bouton modifier le dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['modify'] : code html , bouton modifier
     */
    private function getBtnModifierDossier($dossier)
    {
        global $sugar_config;
        return (!empty($dossier->id)) ? '<input title="Modifier le dossier" 
                class="button" 
                type="button" 
                value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['modifier']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['modifier']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['modifier'] : 'Modifier').'" 
                onclick="location.href=\'index.php?module=OPS_dossier&action=EditView&record=' . $dossier->id . '\'">' : '';
    }
    
    /**
     * @access private
     * @name getBtnSupprimerDossier()
     * Fonction qui génére le bouton supprimer le dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['remove'] : code html , bouton supprimer
     */
    private function getBtnSupprimerDossier($dossier)
    {
        global $sugar_config;
        //Modal confirmation suppréssion
        $modal =                '<div id="modal-supprimer-dossier" class="modal" tabindex="-1" aria-hidden="true" style="display: none;">';
        $modal .=                '<div class="modal-dialog" style="width: 800px;">';
        $modal .=                  '<div class="modal-content">';
        $modal .=                    '<div class="modal-header">';
        $modal .=                      '<button class="close" type="button" data-dismiss="modal" aria-hidden="true" onclick="OdeLoadingHelper.removeSpinner($(document.body));">x</button>';
        $modal .=                      '<h4 id="titre_modal_supprimer" class="modal-title">Suppression du dossier</h4>';
        $modal .=                    '</div>';
        $modal .=                    '<div class="modal-body" style="overflow-y: auto;">Voulez-vous réellement supprimer ce dossier ?</div>';
        $modal .=                    '<div class="modal-footer" style="overflow-y: auto;">';
        $modal .=                      '<button type="button" id="supprimer_dossier_bouton" class="button button-modal" style="margin-right: 10px;">Supprimer</button>';
        $modal .=                      '<button type="button" class="button button-modal" data-dismiss="modal" onclick="OdeLoadingHelper.removeSpinner($(document.body));">Fermer</button>';
        $modal .=                    '</div>';
        $modal .=                  '</div>';
        $modal .=                '</div>';
        $modal .=               '</div>';
        return (!empty($dossier->id)) ? '<input title="Supprimer le dossier" 
                id="delete_dossier_btn"
                class="button"
                type="button" 
                value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['supprimer']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['supprimer']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['supprimer'] : 'Supprimer').'" >'.$modal : '';
    }

    /**
     * @access private
     * @name getBtnExecuterDossier()
     * Fonction qui génére le bouton supprimer le dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['remove'] : code html , bouton supprimer
     */
    private function getBtnExecuterDossier()
    {
        global $sugar_config;
        $executer_button  = '<div class="dropdown" style="display: inline;">';
        $executer_button .= '<input class="input-button dropdown-toggle button" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" 
            value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['executer']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['executer']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['executer'] : 'Exécuter').'">';
        $executer_button .= '<i class="icon-input fa fa-angle-double-down"></i>';
        $executer_button .= '       <div id="dropdown_executer_dossier" class="dropdown-menu ode-dropdown-menu" aria-labelledby="dropdownMenuButton" style="margin-top: 7px;">';
        $executer_button .= '       </div>';
        $executer_button .= '</div>';

        $executer_button .= $this->getBtnLancerFluxDossier();
        $executer_button .= $this->getBtnLancerTraitementDossier();


        return $executer_button;
    }

    /**
     * @access private
     * @name getBtnAssignationDossier()
     * Fonction qui génére le bouton assignation de dosser
     * 
     *  @return string    $dossier_html_boutons['assignation'] : code html , bouton assignation
     */
    private function getBtnAssignationDossier()
    {
        global $sugar_config;
        $dossier_id = $_REQUEST['record'];

        $resultat = array();

        if(!empty($dossier_id))
        {
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            $dispositifId = $obj_dossier->ops_dispositif_id;
            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $dispositifId);
            $obj_dispositif->load_relationship('ops_habilitation_dispositif_ops_dispositif');
            $habilitationsID = $obj_dispositif->ops_habilitation_dispositif_ops_dispositif->get();

            foreach($habilitationsID as $habilitationID)
            {
                $obj_habilitation = BeanFactory::getBean('OPS_habilitation_dispositif', $habilitationID);

                if($obj_habilitation->instruction == 0) continue;

                $obj_habilitation->load_relationship('ops_habilitation_dispositif_securitygroups');
                $securityGroupsID = $obj_habilitation->ops_habilitation_dispositif_securitygroups->get(); 
                
                foreach ($securityGroupsID as $securityGroupID) 
                {
                    $obj_security = BeanFactory::getBean('SecurityGroups', $securityGroupID);
                    $members = $obj_security->getMembers();

                    if(is_array($members) && count($members) > 0)
                    {
                        $memberList = [];
                        foreach($members as $member)
                        {
                            $name = $member['last_name'] . ' ' . $member['first_name'];
                            $memberList[$member['id']] = $name;
                        }
                        asort($memberList);

                        $resultat['securityGroups'][$obj_security->id] = $obj_security->name;
                        $resultat['members'][$obj_security->id] = $memberList;
                    }
                }
            }
        }

        $select_html = '<select id="select_assignation">';
        $select_html .= '<option></option>';
        foreach($resultat['securityGroups'] as $securityGroupID => $securityGroupName)
        {
            if( isset($resultat['members'][$securityGroupID]) && is_array($resultat['members'][$securityGroupID]) && count($resultat['members'][$securityGroupID]) > 0)
            {
                $select_html .= '<optgroup id="' . $securityGroupID . '" label="' . $securityGroupName . '">';
                foreach($resultat['members'][$securityGroupID] as $memberId => $memberName)
                {
                    $select_html .= '<option value="' . $memberId . '">' . $memberName . '</option>';
                }
                $select_html .= '</optgroup>';
            }
        }
        $select_html .= '</select>';

        $modale_html = '<script src="modules/OPS_dossier/js/assignation_dossier.js?='.time().'" type="text/javascript"></script>';
        $modale_html .= '<div id="modal-assignation" class="modal" tabindex="-1" role="dialog">';
        $modale_html .=     '<div class="modal-dialog" style="max-width: 800px;">';
        $modale_html .=         '<div class="modal-content">';
        $modale_html .=             '<div class="modal-header">';
        $modale_html .=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modale_html .=                 '<h4 class="modal-title" id="titre_modal_assignation">Assigner le dossier</h4>';
        $modale_html .=                 '</button>';
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-assignation-body" class="modal-body" style="min-height: 78px;">';
        $modale_html .=             '<div class="col-xs-12 col-sm-4 label" style="padding: 15px;">Utilisateur:</div>';
        $modale_html .=             $select_html;
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-assignation-succes" style="color:green;"></div>';
        $modale_html .=             '<div id="modal-assignation-error" style="color:red;"></div>';
        $modale_html .=             '<div class="modal-footer">';
        $modale_html .=                 '<button id="form_assignation_unitaire_btn_execute" type="button" class="button button-modal" style="width: auto!important;margin-bottom: 4px;margin-right: 4px;" onclick="assignation_dossier()">'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['assigner']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['assigner']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['assigner'] : 'Assigner').'</button>';
        $modale_html .=                 '<button id="form_assignation_unitaire_btn_terminer" type="button" class="button button-modal" data-dismiss="modal" id="annuler_modal" style="width: auto!important;margin-bottom: 4px;margin-right: 4px;">Annuler</button>';
        $modale_html .=             '</div>';
        $modale_html .=         '</div>';
        $modale_html .=     '</div>';
        $modale_html .= '</div>';

        $modale_html .= '<input title="Assigner" 
                          class="button" 
                          type="button" 
                          value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['assigner']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['assigner']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['assigner'] : 'Assigner').'" 
                          onclick="$(\'#modal-assignation\').modal()">';

        return $modale_html;
    }



    
    
    /**
     * @access private
     * @name getBtnLancerFluxDossier()
     * Fonction qui génére le bouton lancer flux
     * 
     *  @return string    $dossier_html_boutons['trigger'] : code html , bouton lancer flux
     */
    private function getBtnLancerFluxDossier()
    {
        global $sugar_config;
        $modal = new OdeModal('ode_modal_flux');
        $modal->setTitle('LANCER UN FLUX');
        $modal->setCss(['modules/OPS_flux/css/declencher_flux.css']);
        $modal->setJS(['modules/OPS_flux/js/declencher_flux.js']);
        $modal->setPages(['modules/OPS_dossier/tpls/declencher_flux.tpl']);

        return '<a title="Déclencher un traitement" 
                class="dropdown-item ode-dropdown-item execute_button" 
                type="button" 
                name="lancer_flux" 
                style="display:none;"
                role="ode-modal-flux-unitaire-btn">'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['flux']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['flux']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['flux'] : 'Lancer un flux').'</a>'.$modal->getHtml();
    }
    
    /**
     * @access private
     * @name getBtnLancerTraitementDossier()
     * Fonction qui génére le bouton lancer traitement
     *
     *  @return string    $dossier_html_boutons['trigger'] : code html , bouton lancer traitement
     */
    private function getBtnLancerTraitementDossier()
    {

        $modal = new OdeModal('ode_modal_traitement');
        $modal->setTitle('LANCER UN TRAITEMENT');
        $modal->setCss(['modules/OPS_type_traitement/css/declencher_traitement.css']);
        $modal->setJS(['modules/OPS_type_traitement/js/declencher_traitement.js']);
        $modal->setPages(['modules/OPS_dossier/tpls/declencher_traitement.tpl']);
        return '<a title="Déclencher un traitement"
                class="dropdown-item ode-dropdown-item execute_button"
                type="button"
                name="lancer_traitement"
                style="display:none;"
                role="ode-modal-traitement-unitaire-btn">Lancer un traitement</a>'.$modal->getHtml();
    }



    /**
     * @access private
     * @name getBtnGenererPdfDossier()
     * Fonction qui génére le bouton lancer flux
     * 
     *  @return string    $dossier_html_boutons['trigger'] : code html , bouton lancer flux
     */
    private function getBtnGenererPdfDossier()
    {
        global $sugar_config;
        return '<input 
                    type="button"
                    class="button" 
                    href="#"  
                    title="Télécharger le dossier en PDF" 
                    onClick="window.location = \'index.php?entryPoint=generer_pdf&dossier_id=' . $this->bean->id . '\'; " 
                    value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['pdf']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['pdf']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['pdf'] : 'PDF').'" />';
    }
    
    /**
     * @access private
     * @name getBtnDupliquerDossier()
     * Fonction qui génére le bouton dupliquer le dossier
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['remove'] : code html , bouton supprimer
     */
    private function getBtnDupliquerDossier()
    {
        global $sugar_config;
        $modale_html .= '<div id="modal-dupliquer" class="modal" tabindex="-1" role="dialog">';
        $modale_html .=     '<div class="modal-dialog" style="max-width: 800px;">';
        $modale_html .=         '<div class="modal-content">';
        $modale_html .=             '<div class="modal-header">';
        $modale_html .=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modale_html .=                 '<h4 class="modal-title" id="titre_modal_dupliquer">Dupliquer le dossier</h4>';
        $modale_html .=                 '</button>';
        $modale_html .=             '</div>';
        $modale_html .=             '<div id="modal-dupliquer-body" class="modal-body" style="min-height: 78px;">';
        $modale_html .=                 '<input type="checkbox" id="dupliquer_dossier_checkbox" name="dupliquer_dossier_checkbox" checked>';
        $modale_html .=                 '<label for="dupliquer_dossier_checkbox">Lier le nouveau dossier à l\'ancien';
        $modale_html .=             '</div>';
        $modale_html .=             '<div class="modal-footer">';
        $modale_html .=                     '<button id="dupliquer_dossier_btn" type="button" class="button button-modal" style="width: auto!important;margin-bottom: 4px;margin-right: 4px;">'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer'] : 'Dupliquer').'</button>';
        $modale_html .=                     '<button type="button" class="button button-modal" style="width: auto!important;margin-bottom: 4px;margin-right: 4px;" onclick="$(\'#modal-dupliquer\').modal(\'hide\')">Annuler</button>';
        $modale_html .=             '</div>';
        $modale_html .=         '</div>';
        $modale_html .=     '</div>';
        $modale_html .= '</div>';

        $modale_html .= '<input title="Dupliquer" 
                          class="button" 
                          type="button" 
                          value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['dupliquer'] : 'Dupliquer').'" 
                          onclick="$(\'#modal-dupliquer\').modal()">';

        return $modale_html;
    }
    
    /**
     * @access private
     * @name getBtnModifierStatutDossier()
     * Fonction qui génére le select statut + bouton modifier statut + affichage statut courant
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['change_status'] : code html , bouton modifier statut
     */
    private function getBtnModifierStatutDossier($dossier)
    {
        global $sugar_config;
        
        // Récupération de la liste des statuts pour le Workflow 
        $obj_statut = new OPS_statut();
        $obj_statut->retrieve($dossier->ops_statut_id);
        
        $liste_wf = $obj_statut->liste_statuts($dossier);
        
        
        $select_actions = '<select name="action_id" id="select_statut" >';
        $select_actions .= '<option value="disabled" disabled="disabled" selected="selected" > Sélectionner un statut </option>';
        foreach ($liste_wf as $statut_id => $statut_name) {
            
            if ("undefined" != $statut_id) {
                
                $picto = "" ; 

                $ops_statut = new OPS_statut();
                $ops_statut->retrieve($statut_id);
                if( !empty($ops_statut->id) ){
                    switch ($ops_statut->avancement) {
                        case 'precedent':
                            $picto = "&#8592;" ; 
                            break;
                        case 'suivant':
                            $picto = "&#8594;" ; 
                            break;
                        case 'termine':
                            $picto = "&#8855;" ; 
                            break;
                    
                    }

                }
              
                $select_actions .= '<option value="' . $statut_id . '" >' . $statut_name . ' '. $picto .' </option>';
            }
        }
        
        $select_actions .= "</select>";
        
        
        
        $str_liste_actions = '<div style="display: inline-block;" role="group-buttons">' . $select_actions;
        
        if (!empty($liste_wf)) {
            
            $str_liste_actions .= '<input title="Instruire" 
                                        id="select_statut_btn"
                                        class="button"
                                        type="button"
                                        name="workflow_bouton"
                                        value="'.(isset($sugar_config['opensocle']['dossier_boutons_libelles']['instruire']) && !empty($sugar_config['opensocle']['dossier_boutons_libelles']['instruire']) ? $sugar_config['opensocle']['dossier_boutons_libelles']['instruire'] : 'Instruire').'" >';
        }
        
        $str_liste_actions .= "</div>";
        
        
        return $str_liste_actions;
    }
    
    
    /**
     * @access private
     * @name getBtnAfficheStatutDossier()
     * Fonction qui génére le libellé du statut courant et sa date
     * 
     *  @param bean    $dossier : objet OPS_dossier initialisé en amont
     *  @return string    $dossier_html_boutons['date_status'] : code html , block statut et date
     */
    private function getBtnAfficheStatutDossier($dossier)
    {
        
        // Récupération de la liste des statuts pour le Workflow 
        $obj_statut = new OPS_statut();
        $obj_statut->retrieve($dossier->ops_statut_id);
        
        $statut_courant  = $obj_statut->name;
        $date_avancement = (!empty($dossier->date_avancement)) ? OdeDateHelper::toHTML($dossier->date_avancement) : "";
        
        $str_liste_actions = "";
        
        
        // Ajout du statut en plus 
        if (!empty($statut_courant)) {
            
            $str_liste_actions .= '<span class="info-label-badge" style="background: ' . $obj_statut->code_couleur . ';">'. $statut_courant . '</span>';
        }
        
        return $str_liste_actions;
    }
    
    
    /**
     * @access private
     * @name getLinksDossier()
     * Fonction qui génére les boutons d'onglets 
     * 
     *  @param bean       $dossier : objet OPS_dossier initialisé en amont
     *  @return string      $btn_onglets_html : code html , les boutons sont groupés dans une div
     */
    private function getLigneWorkflowVueDossier($dossier)
    {
        
        // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
        $dispositifs = $dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
        $dispositif  = (is_array($dispositifs) && count($dispositifs) == 1) ? $dispositifs[0] : false;
        
        // Récupération du guide d'instruction
        $guide_instructions = ($dispositif !== false) ? $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction') : array();
        $guide_instruction  = (is_array($guide_instructions) && count($guide_instructions) == 1) ? $guide_instructions[0] : false;
        
        // Récupération de la liste des étapes du guide d'instruction
        $liste_des_etapes = ($guide_instruction !== false) ? $guide_instruction->liste_etapes() : array();
        
        // Récupération de l'étape courante pour ne pas afficher les étapes suivantes ou on aurait pu revenir en arrière
        $etape_courante = BeanFactory::getBean('OPS_etape', $dossier->ops_etape_id);
        
        // Récupération des status passés 
        $tab_historiques = $dossier->get_linked_beans('ops_historisation_ops_dossier', 'OPS_historisation', '', 0, -1, 0, "flag_retour = '1'");
        $tabhisto        = array(
            "Tableau historisation"
        );
        
        
        $str_workflow = ""; // Init HTML Workflow code.
        
        
        $OPS_dossier_history = array();
        $dossier_tab_history = $tab_historiques;
        //$dossier_tab_history = array_reverse($tab_historiques);
        
        foreach ($dossier_tab_history as $key => $historisation) {
            
            $_history = array(
                'id' => $historisation->id,
                'date_entered' => $historisation->date_entered,
                'date_modified' => $historisation->date_modified,
                'ops_statut_id' => $historisation->ops_statut_id,
                'statut' => $historisation->statut,
                'ops_etape_id' => $historisation->ops_etape_id,
                'etape' => $historisation->etape
            );

            $step_pointer                       = $historisation->ops_etape_id;
            $OPS_dossier_history[$step_pointer] = $_history;
        }
        
        $str_workflow .= '<div class="align-items-center d-flex justify-content-between" role="dossier-workflow">';
        
        
        $total_steps  = count($liste_des_etapes);
        $focused_step = 0;
        $has_picto    = false;
        $finished     = false;
        $completed    = false;
        $decorate     = true;
        
        //Pour les actions de statut où on saute des étapes
        if (count($OPS_dossier_history) > 1) {
            $last_before_current = current(array_slice($OPS_dossier_history, -2, 1));
            
            foreach ($liste_des_etapes as $k => $value) {
                if ($value['id'] == $etape_courante->id) {
                    $my_key = $k;
                }
                if ($value['id'] == $last_before_current['ops_etape_id']) {
                    $last_key = $k;
                }
            }
            
            for ($i = $my_key + 1; $i <= count($liste_des_etapes); $i++) {
                foreach ($OPS_dossier_history as $k => $value) {
                    if ($value['ops_etape_id'] == $liste_des_etapes[$i]['id']) {
                        unset($OPS_dossier_history[$k]);
                    }
                }
            }
            
            $last_id = $liste_des_etapes[$last_key]['id'];
            
            for ($j = $last_key + 1; $j < $my_key; $j++) {
                $_history = array(
                    'by_pass' => true,
                    'ops_statut_id' => $OPS_dossier_history[$last_id]['ops_statut_id'],
                    'ops_etape_id' => $liste_des_etapes[$j]['id'],
                    'etape' => $liste_des_etapes[$j]['name']
                );

                $step_pointer                       = $liste_des_etapes[$j]['id'];
                
                $OPS_dossier_history[$step_pointer] = $_history;
            }
        }

        $dossiers_history = $OPS_dossier_history;
        if(is_array($OPS_dossier_history) && count($OPS_dossier_history) > 1) 
        {
            $dossiers_history = array_values($dossiers_history);
            $pres_value = $dossiers_history[0];

            $OPS_dossier_history_new = $OPS_dossier_history;

            for ($i = 1; $i < count($dossiers_history); ++$i) 
            {
                $dossier_history = $dossiers_history[$i];

                if(!isset($dossier_history['ops_etape_id']) || empty($dossier_history['ops_etape_id']))
                {
                    continue;
                }

                $obj_etape = BeanFactory::getBean('OPS_etape', $dossier_history['ops_etape_id']);
                if(empty($obj_etape->ops_etape_id))
                {
                    continue;
                }

                $obj_etape_pres = BeanFactory::getBean('OPS_etape', $obj_etape->ops_etape_id);

                $count = $i - 1;
                $ops_statut_id = $pres_value['ops_statut_id'];
                while( ($obj_etape_pres->id != $dossiers_history[$i - 1]['ops_etape_id']) || empty($obj_etape_pres->id) || $count < 0)
                {
                    if( !array_key_exists($obj_etape_pres->id, $OPS_dossier_history_new) )
                    {
                        $_history = array(
                            'by_pass' => true,
                            'ops_statut_id' => $ops_statut_id,
                            'ops_etape_id' => $obj_etape_pres->id,
                            'etape' => $obj_etape_pres->name,
                        );

                        $OPS_dossier_history_new[$obj_etape_pres->id] = $_history;

                        $obj_etape = $obj_etape_pres;

                        if(empty($obj_etape_pres->ops_etape_id))
                        {
                            break;
                        }
                        $obj_etape_pres = BeanFactory::getBean('OPS_etape', $obj_etape_pres->ops_etape_id);

                        $count = $count - 1;
                    }
                    else
                    {
                        break;
                    }

                }

                if(!empty($dossier_history['ops_statut_id']))
                {
                    $pres_value = $dossier_history;
                }
            }

            $last_etape = array_search($my_key, array_keys($liste_des_etapes)) + 1;
            $etapes_non_passer = array_slice($liste_des_etapes, $last_etape, count($liste_des_etapes) - $last_etape);

            foreach($etapes_non_passer as $etape)
            {
                if(is_array($OPS_dossier_history_new) && array_key_exists($etape['id'], $OPS_dossier_history_new) ) 
                {
                    unset( $OPS_dossier_history_new[$etape['id']] );
                }
            }
            $OPS_dossier_history = $OPS_dossier_history_new;
        }


        foreach ($liste_des_etapes as $k => $value) {
            
            $extra = '';
            
            $obj_statut = BeanFactory::getBean('OPS_statut', $dossier->ops_statut_id);
            
            $current_step = ($value['id'] == $dossier->ops_etape_id) ? true : false;
            
            $step_status_name = $OPS_dossier_history[$value['id']]['statut'];
            
            $step_statut_id     = $OPS_dossier_history[$value['id']]['ops_statut_id'];
            $step_obj_statut    = BeanFactory::getBean('OPS_statut', $step_statut_id);
            $step_code_couleur  = (!empty($step_obj_statut->id)) ? $step_obj_statut->code_couleur : 'rgba(0, 0, 0, 0.1)';
            $phase_code_couleur = (!empty($step_obj_statut->id)) ? $step_obj_statut->code_couleur : 'rgba(0, 0, 0, 0.05)';
            
            $step_date_modified = $OPS_dossier_history[$value['id']]['date_modified'];
            
            if ($OPS_dossier_history[$value['id']]['by_pass']) {
                $step_coloration  = ' style="background-color:' . $step_code_couleur . ';" ';
                $phase_coloration = ' style="background: repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(255, 255, 255, 0.15) 10px, rgba(255, 255, 255, 0.15) 20px); background-color:' . $phase_code_couleur . '"';
            } else {
                $step_coloration  = ' style="background-color:' . $step_code_couleur . ';" ';
                $phase_coloration = ' style="background-color:' . $phase_code_couleur . ';" ';
            }
            
            // TODO ! Do not decorate phase until step is not effective passed.
            #   $dossier->ops_etape_id
            #   $dossier->ops_statut_id
            
            if ($decorate) {
                /* Allows CSS coloration and Label status  */
            } else {
                /* no longer labelized */
                $step_coloration  = '';
                $step_status_name = '';
            }

            $labelClass = '';
            
            
            if ($current_step /*current step ?*/ ) {
                
                if ($has_picto) {
                    $labelClass .= 'class="label-current"';
                    $extra .= ' current fa fa-archive ';
                    $has_picto        = false;
                    $decorate         = false;
                    $phase_coloration = '';
                } else {
                    
                    if ($obj_statut->avancement == 'suivant') {
                        $has_picto = true;
                        $decorate  = false;
                    } elseif ($obj_statut->avancement == 'courant') {
                        $has_picto = false;
                        $labelClass .= 'class="label-current"';
                        $extra .= ' current fa fa-archive ';
                        $decorate         = false;
                        $phase_coloration = '';
                    } else { // 'termine'
                        $has_picto = false;
                        $labelClass .= 'class="label-current"';
                        $extra .= ' current  fa fa-archive ';
                        $finished = true;
                        $decorate = false;
                        if ($focused_step >= $total_steps - 1) {
                            $extra .= ' successful ';
                        } else {
                            $extra .= ' premature ';
                            $phase_coloration = '';
                        }
                    }
                }
            } else {
                if ($has_picto) {
                    $labelClass .= 'class="label-current"';
                    $extra .= ' current fa fa-archive ';
                    $has_picto        = false;
                    $decorate         = false;
                    $phase_coloration = '';
                }
            }
            
            $textAide = strip_tags(mb_convert_encoding(base64_decode($value['instruction'], true), 'UTF-8', 'HTML-ENTITIES'));

            if(strlen($textAide) > 300){
                $textAide = substr($textAide, 0, 300). " ... ... ... (Cliquer sur l'infobulle pour voir la suite)";
            }
            
            $aide = (!empty($value['instruction']))?'<i class="fa fa-info-circle info-tooltip aide-instruction" title="'.$textAide.'" data-instruction="'.$value['instruction'].'" style="margin-left: 5px;"></i>':'';
            
            //Si le dossier est terminé
            if ($k == end(array_keys($liste_des_etapes)) && $obj_statut->avancement == 'termine') {
                $extra = ' fa fa-times ';
                $extra .= ' failed ';
                $extra .= ' current ';
            }

            $str_workflow .= '<div class="step-label" ><label '.$labelClass.'>' . $value['name'] .$aide. '</label>';
            $str_workflow .= '<div class="step-circle ' . $extra . '" ' . $step_coloration . ' data-step-id="' . $value['id'] . '" ><span>' . $value['name'] . '</span></div></div>';
            if(array_key_last($liste_des_etapes) != $k){
                $str_workflow .= '<div class="flex-grow step-phase" data-step-name="' . $value['name'] . '" ' . $phase_coloration . ' ></div>';
            }
        }        
        
        // / [role="dossier-workflow"]
        $str_workflow .= '</div>';

        $str_workflow .= OPS_etape::html_modal();
        
        
        return $str_workflow;
    }
    
    
    
    private function remplace_champs($contenue)
    {
        global $db,$app_list_strings;
        // Remplacement du dispositif
        $obj_dispositif = new OPS_dispositif();
        $obj_dispositif->retrieve($this->bean->ops_dispositif_id);
        $contenue = str_replace('{$dossier.ops_dispositif_id}', $obj_dispositif->name, $contenue);
        
        // Remplacer les champs du Dossiers 
        foreach ($this->bean->field_defs as $field) {

            $field_name = $field['name'];

            if (!empty($field_name) && $field['type'] === 'enum' && !empty($field['options'])) {
                $liste_name = $field['options'];
                
                $field_value = $app_list_strings[$liste_name][$this->bean->$field_name];
                $contenue    = str_replace('{$dossier.' . $field_name . '}', $field_value, $contenue);
            }


            if (isset($this->bean->$field_name) && !($this->bean->$field_name instanceof Link2) && $field_name != 'duplication_id') {
                $field_value = $this->bean->$field_name;
                $contenue    = str_replace('{$dossier.' . $field_name . '}', $field_value, $contenue);
            }

            if($field_name == 'duplication_id'){
                $beanDossier = BeanFactory::getBean('OPS_dossier',$this->bean->$field_name);
                $field_value = "<a target='_blank' href='/index.php?module=OPS_dossier&action=DetailView&record=" . $beanDossier->id . "'>
                                    <span class='sugar_field'>" . $beanDossier->name . "</span></a>";
                $contenue    = str_replace('{$dossier.' . $field_name . '}', $field_value, $contenue);
            }
        }

        # On récupére la liste des champs custom de la vue agent
        $dispositifModel = new DispositifModel($this->bean->ops_dispositif_id);
        $champsVueAgent = $dispositifModel->getChampsVueAgent();

        # On initialise la classe OdeFieldFactory
        $odeFieldFactory = new OdeFieldFactory($this->bean, false, []);

        $champsDossier = [];
        foreach ($champsVueAgent as $champTab => $champ) 
        {
           $val = $odeFieldFactory->getChampPdfValue($champ); 
            if( is_string($val) ){
                $contenue    = str_replace('{$dossier.' . $champTab . '}', $val , $contenue);
            }

        }


        if(strpos($contenue, "dossier.assigned_user_last_name") !== false){
            $userObj = BeanFactory::getBean('Users',$this->bean->assigned_user_id);
            $contenue = str_replace('{$dossier.assigned_user_last_name}', $userObj->last_name, $contenue);
        }

        if(strpos($contenue, "dossier.dossier_lie") !== false){

            $dossiers = array();
            $sql = " SELECT `ops_dossier_id2` FROM `ops_dossier_ops_dossier` WHERE `ops_dossier_id` = '" . $this->bean->id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $dossiers[] = $row['ops_dossier_id2'];
            }
            
            if(count($dossiers) == 1){
                $beanDossier = BeanFactory::getBean('OPS_dossier',$dossiers[0]);
                $field_value = "<a target='_blank' href='/index.php?module=OPS_dossier&action=DetailView&record=" . $beanDossier->id . "'>
                                <span class='sugar_field'>" . $beanDossier->name . "</span></a>";
            }else{
                $field_value = "";
            }
            $contenue = str_replace('{$dossier.dossier_lie}', $field_value, $contenue);
        }


        if(strpos($contenue, "dossier.dossier_originel") !== false){

            $dossiers = array();
            $sql = " SELECT `ops_dossier_pere_id` FROM `ops_dossier_ops_dossier_paiement` WHERE `ops_dossier_paiement_id` = '" . $this->bean->id . "' AND `deleted` = '0' ";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $dossiers[] = $row['ops_dossier_pere_id'];
            }
            
            if(count($dossiers) == 1){
                $beanDossier = BeanFactory::getBean('OPS_dossier',$dossiers[0]);
                $field_value = "<a target='_blank' href='/index.php?module=OPS_dossier&action=DetailView&record=" . $beanDossier->id . "'>
                                <span class='sugar_field'>" . $beanDossier->name . "</span></a>";
            }else{
                $field_value = "";
            }

            $contenue = str_replace('{$dossier.dossier_originel}', $field_value, $contenue);
        }
        
        // Remplacer les champs du demandeur 
        if (strpos($contenue, "demandeur.") !== false) {
            
            $obj_individu = new OPS_individu();
            if (!empty($this->bean->ops_individu_id)) {
                
                $obj_individu->retrieve($this->bean->ops_individu_id);
            }
            
            foreach ($obj_individu->field_defs as $field) {
                $field_name = $field['name'];
                if (!($obj_individu->$field_name instanceof Link2)) {
                    // Ajout du lien cliquable 
                    if ($field_name == "full_name" || $field_name == "last_name") {
                        $field_value = "<a target='_blank' href='/index.php?module=OPS_individu&action=DetailView&record=" . $obj_individu->id . "'>
                                    <span class='sugar_field'>" . $obj_individu->$field_name . "</span></a>";
                        
                    } else {
                        $field_value = $obj_individu->$field_name;
                    }
                    $contenue = str_replace('{$demandeur.' . $field_name . '}', $field_value, $contenue);
                }
            }
        }
        
        // Remplacer les champs du profil 
        if (strpos($contenue, "profil.") !== false) {

            


            $obj_profil = new OPS_personne_morale();
            if (!empty($this->bean->ops_personne_morale)) {
                $obj_profil->retrieve($this->bean->ops_personne_morale);
            }
            
            if (str_contains($contenue, '{$profil.sous_territoire}')) {
                $str_territoire = "" ;
                $tab_sous_territoire = $obj_profil->get_linked_beans('ops_sous_territoire_ops_personne_morale', 'OPS_sous_territoire');

                foreach ($tab_sous_territoire as $key => $sous_territoire) {
                    $str_territoire .= $sous_territoire->name .", "; 
                }

                $str_territoire = substr($str_territoire, 0, -2);
                $contenue = str_replace('{$profil.sous_territoire}' , $str_territoire, $contenue);
            }

            foreach ($obj_profil->field_defs as $field) {
                $field_name = $field['name'];
                if (!($obj_profil->$field_name instanceof Link2)) {
                    
                    // Ajout du lien cliquable 
                    if ($field_name == "name") {
                        $field_value = "<a target='_blank' href='/index.php?module=OPS_personne_morale&action=DetailView&record=" . $obj_profil->id . "'>
                                    <span class='sugar_field'>" . $obj_profil->$field_name . "</span></a>";
                        
                    } else {
                        $field_value = $obj_profil->$field_name;
                    }
                    $contenue = str_replace('{$profil.' . $field_name . '}', $field_value, $contenue);
                }
            }
        }
        
        // Remplacer les champs du bénéficiaire 
        if (strpos($contenue, "beneficiaire.") !== false) {
            
            $obj_individu = new OPS_individu();
            if (!empty($this->bean->beneficiaire_id)) {
                
                $obj_individu->retrieve($this->bean->beneficiaire_id);
            }
            
            foreach ($obj_individu->field_defs as $field) {
                $field_name = $field['name'];
                if (!($obj_individu->$field_name instanceof Link2)) {
                    // Ajout du lien cliquable 
                    if ($field_name == "full_name" || $field_name == "last_name") {
                        $field_value = "<a target='_blank' href='/index.php?module=OPS_individu&action=DetailView&record=" . $obj_individu->id . "'>
                                    <span class='sugar_field'>" . $obj_individu->$field_name . "</span></a>";
                        
                    } else {
                        $field_value = $obj_individu->$field_name;
                    }
                    $contenue = str_replace('{$beneficiaire.' . $field_name . '}', $field_value, $contenue);
                }
            }
        }
        
        return $contenue;
        
    }

    public function actionStatutOnglet($statut_id){

        $contenu = '<div id="action_statut_onglet" style="display:none;">';

        $statutBean = BeanFactory::getBean('OPS_statut', $statut_id);
        if(empty($statutBean)) return "";
        $statutBean->load_relationship('ops_action_statut_ops_statut');

        $listeActions = $statutBean->ops_action_statut_ops_statut->get();

        foreach ($listeActions as $action) {
            $actionBean = BeanFactory::getBean('OPS_action_statut', $action);
            if($actionBean->active == 1 && $actionBean->ext_valeur_2 == "modif_onglet"){

                $this->bean->load_relationship('ops_dispositif_ops_dossier');
                $dispositif = $this->bean->ops_dispositif_ops_dossier->get();

                $dispositifBean = BeanFactory::getBean('OPS_dispositif',$dispositif[0]);
                $dispositifBean->load_relationship('ops_generateur_formulaire_ops_dispositif');

                $formulaire = $dispositifBean->ops_generateur_formulaire_ops_dispositif->get();
                $action_statut = new OdeActionStatut($actionBean, null);
                $donnees = $action_statut->getExtValeurText('rendrevisiblemodifiableongletaction');

                if(str_contains($donnees['modele_dossier'] , $formulaire[0] )){
                    $contenu .= '<input type="hidden" value="'.$donnees['onglet_crm'].'" data-visible="'.$donnees['visible_crm'].'" data-modifiable="'.$donnees['modifiable_crm'].'">';
                }
            }
        }
        $contenu .= '</div>';
        return $contenu;
    }
    
}
