<?php
class Filtre_CanalViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";
    private $nomListe;
    private $nomFiltre;

    

    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Canal";
        $this->nomFiltre = "canal";

    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        global $db, $app_list_strings;
        $canaux = $app_list_strings['ops_canal_list'] ?? [];


        $options = [];
        foreach($canaux as $value => $libelle){
            if($value == "") continue;
            $options[$value] = $libelle;
        }



        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['canal'] ?? array();
        $valeur = $infosFiltre['valeurs'] ?? "";
        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "fas fa-globe");
        $this->smarty->assign("NOM_CHAMP", $this->nomFiltre);
        $this->smarty->assign("VALEURS_SELECT", $valeur);
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS",$this->type);
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 3;
    }
    
    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }

}