<?php
class Filtre_ClosViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";
    private $nomListe;
    private $nomFiltre;



    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Clos";
        $this->nomFiltre = "clos";


    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        $options = [
            1 => "Oui",
            0 => "Non",
        ];


        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['cloture'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "far fa-times-circle");
        $this->smarty->assign("NOM_CHAMP", $this->nomFiltre);
        $this->smarty->assign("VALEURS_SELECT", strval($valeur));
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 2;
    }

    public function getNomListe(){
        return $this->nomListe;
    }


    
    public function getNomFiltre() {
        return $this->nomFiltre;

    }
}