<?php
class Filtre_ConversationViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";
    private $nomListe;
    private $nomFiltre;


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Conversation";
        $this->nomFiltre = "conversation_statut";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){

        global $app_list_strings;

        $options = $app_list_strings['conversation_statut_list'];

        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['conversation_statut'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "fas fa-comment-alt");
        $this->smarty->assign("NOM_CHAMP", $this->nomFiltre);
        $this->smarty->assign("VALEURS_SELECT", strval($valeur));
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 2;
    }

    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }
}