<?php
class Filtre_JustificatifViewUtils {

    private $smarty;
    private $template;
    private $type = "flag_colonne";
    private $nomListe;
    private $nomFiltre;

    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Justificatif";
        $this->nomFiltre = "justificatif";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){
        
        $options = [
            "flag_justificatif_etude" => "Etude",
            "flag_justificatif_reetude" => "Re-étude"
        ];

        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_flag']['justificatif'] ?? array();
        $valeur = $infosFiltre['colonnes'] ?? "";
        $this->smarty->assign("NOM_FILTRE", $this->nomFiltre);
        $this->smarty->assign("NOM_LISTE",  $this->nomListe);
        $this->smarty->assign("VALEURS_SELECT", $valeur);
        $this->smarty->assign("ICON", "fas fa-paperclip");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 4;
    }

    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }
}