<?php


if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');



class ViewGenerateur extends SugarView
{
    protected $step ;
    protected $hors_compte ;
    protected $current_service ;
    protected $entite ;
    protected $demandeur;

    public function __construct($bean = null,$view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Generateur flux');
        }

    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {
        global $beanList, $beanFiles, $app_list_strings, $mod_strings, $sugar_config;
        $smarty = new Sugar_Smarty();

        $current_template = "modules/OPS_flux/tpls/generateur.tpl";

        if(isset($_REQUEST['id_flux']) && !empty($_REQUEST['id_flux'])){

            $flux = new OPS_flux();
            $flux->retrieve($_REQUEST['id_flux']);

            // Initialisation des selecteurs de filtres
            $json_data_flux = json_encode( $this->get_data_multi_selects($flux , (array) ['OPS_dossier'] ) );
            if( $json_data_flux != false ){
                $smarty->assign("json_data_flux", $json_data_flux);
            }else{
                $GLOBALS['log']->fatal(" ViewGenerateur :: display => SELECT EMPTY ");
            }
      

            // Initilisation de la grappe JSON
            $json_elements = $flux->get_json_flux_elements(false);
            if(!empty($json_elements)){
                $text_area_value = $json_elements;
            }else{
                $text_area_value = '';
            }
            $smarty->assign("TEXT_AREA_VALUE", $text_area_value);


            // Préparation du tableau
            $elements_by_ordre = array();
            $elements = $flux->get_linked_beans('ops_flux_ops_flux_element','OPS_flux_element');
            if(!empty($elements)){

                $tr_tableau = "";
                $count =0;

                foreach ($elements as $element) {
                    if(!empty($element->name)){
                        $elements_by_ordre[$element->ordre]['name'] = $element->name;
                        $elements_by_ordre[$element->ordre]['type_element'] = $element->type_element;
                        $elements_by_ordre[$element->ordre]['flux_element_parent_id'] = $element->flux_element_parent_id;
                        $elements_by_ordre[$element->ordre]['name_flux'] = $element->name_flux;
                        $elements_by_ordre[$element->ordre]['champ'] = $element->champ;
                    }
                }
                
                // Je trie le tableau 
                ksort($elements_by_ordre);

                foreach ($elements_by_ordre as $key => $value) {
                    if($count % 2 == 1){
                        $background = "";
                    }else{
                        $background = "background-color: white;";
                    }
                    $tr_tableau .= '<tr style="'.$background.'">
                                        <td style="text-align: left; padding:10px">'.$key.'</td>
                                        <td style="text-align: left; padding:10px">'.$value['type_element'].'</td>
                                        <td style="text-align: left; padding:10px">'.$value['name'].'</td>
                                        <td style="text-align: left; padding:10px">'.$this->get_name_element_parent($value['flux_element_parent_id']).'</td>
                                        <td style="text-align: left; padding:10px">'.$value['name_flux'].'</td>
                                        <td style="text-align: left; padding:10px;padding-left: 0px;padding-right: 0px;">'.$value['champ'].'</td> 
                                    </tr>';
                    $count++;
                }

            }else{
                $tr_tableau = '<tr id="td_tableau_vide" style="background-color: white;">
                    <td colspan="6" style="text-align: center;padding: 10px;">Aucun élément sur ce flux</td>
                </tr>';
            }
            $smarty->assign("TR_FLUX_ELEMENTS", $tr_tableau);
            
        }else{

            $GLOBALS['log']->fatal(" ViewGenerateur :: display => L'id du flux est vide");
        }
 
        $btn_back_flux = '<a href="index.php?module=OPS_flux&offset=1&stamp=1580373909046267300&return_module=OPS_flux&action=DetailView&record='.$flux->id.'" id="btn_retour_flux" style="background: #32A6CF; color: #f5f5f5; padding: 5px 1px 3px 8px; margin: 0 14px 0 0px; border-radius: 3px; letter-spacing: 1px;" >
                                <span class="glyphicon glyphicon-chevron-left"> </span>
                          </a>';
                       
        $smarty->assign("BTN_BACK_FLUX", $btn_back_flux);
        $smarty->assign("TITRE", "GÉNÉRER DES ÉLÉMENTS FLUX À PARTIR D'UN JSON  ");
        $smarty->display($current_template);              

    }


    /**
     * @see ViewGenerateur::get_data_multi_selects()
     */
    public function get_data_multi_selects($flux , $beans=array())
    {
        $data = false;
        if(!empty($flux->objet)){
            switch ($flux->objet) {
                case "OPS_dossier":
                    $champs = $this->get_champs_dossier();
                    foreach ($champs as $name_module => $module) {
                        foreach ($module as $id => $libelle) {
                            $data[$name_module][$id]= $libelle;
                        }
                    }
                    break;
                case "OPS_personne_morale":
                    $GLOBALS['log']->fatal(" ViewGenerateur :: get_champs_objet => flux->objet = OPS_personne_morale non traité ");
                    break;
                case "OPS_individu":
                    $GLOBALS['log']->fatal(" ViewGenerateur :: get_champs_objet => flux->objet = OPS_individu non traité ");
                    break;
                case "Documents":
                    $GLOBALS['log']->fatal(" ViewGenerateur :: get_champs_objet => flux->objet = Documents non traité ");
                    break;
            }
        }

        $referentiel = new OPS_generateur_referentiel();
        $liste_referentiel = $referentiel->get_full_list();
        foreach ($liste_referentiel as $champ_referentiel) {
            if(!empty($champ_referentiel->name))
            {
                $data['Dossier']['$dossier_' . $champ_referentiel->name] = $champ_referentiel->libelle . ' (' . $champ_referentiel->name . ')';            
            }
        }
        asort($data['Dossier']);


        $data['Profil']       = OPS_personne_morale::get_field_list();
        $data['Beneficiaire'] = OPS_individu::get_field_list(false, true);
        $data['Demandeur']    = OPS_individu::get_field_list(false, true);


        //Special support pour la gestion dynamique des templates PDF (AOS_PDF_Templates).
        $aos_pdf_tpl = $this->fetch_aos_pdf_templates_data();
        $data['📄 Modèles PDF'] = $aos_pdf_tpl;


        //Special support pour la gestion dynamique des modèle de document (Documents Éditiques).
        if( file_exists('custom/modules/Documents/Documents_editiques.php') ){
            require_once('custom/modules/Documents/Documents_editiques.php');
        }

        if( class_exists('Documents_editiques') ){

            $ops_models_doc = $this->fetch_ops_documents_templates_data();
            $data['📄 Modèles de Documents Éditiques'] = $ops_models_doc;

        }


        return $data;
    }



    public function fetch_aos_pdf_templates_data()
    {

        // On récupère les template mis en services
        $pdf_template_bean       = BeanFactory::getBean('AOS_PDF_Templates');
        $pdf_template_collection = $pdf_template_bean->get_full_list();

        $aos_pdf_tpl             = array();

        foreach ($pdf_template_collection as $key => $pdf_template) {
            if(!empty($pdf_template->id)){

                // Fetch before it's related ops_type_document...
                $extra = ($pdf_template->ops_type_document != '')? ' ('.$pdf_template->ops_type_document.')' : '';
                $aos_pdf_tpl[ '$pdf_tpl_id_'.$pdf_template->id ] = $pdf_template->name .$extra; // Filtre sur $pdf_tpl_id_ lors du remplacement

            }

        }

        return $aos_pdf_tpl;

    }


    public function fetch_ops_documents_templates_data()
    {

        // On récupère les modèles de documents mis en services en s'appuyant sur la classe Documents_editiques qui étend Documents.
        require_once('custom/modules/Documents/Documents_editiques.php');
        if( !class_exists('Documents_editiques') ){ return []; }

        $DocumentEditique = new Documents_editiques();
        # Methods :
        // get_types_documents
        // get_modeles_documents
        // get_type_document_by_id

        $modeles_documents_collection = $DocumentEditique->get_modeles_documents();
        $types_documents_collection   = $DocumentEditique->get_types_documents();


        $ops_models_doc = array();


        foreach ($modeles_documents_collection as $key => $modele_editique) {
            if(!empty($modele_editique['id'])){

                // Fetch before it's related ops_type_document... (stored in type_name key).
                $extra = ($modele_editique['type_name'] != '')? ' ('. htmlentities($modele_editique['type_name']) .')' : '';
                $ops_models_doc[ '$editique_tpl_id_'.$modele_editique['id'] ] = htmlentities($modele_editique['name']) .$extra; // Filtre sur $editique_tpl_id_ lors du remplacement

            }

        }

        return $ops_models_doc;

    }

    public function get_champs_dossier()
    {
        global $app_list_strings;
        $array_return = array();
        foreach ($app_list_strings['ops_flux_objet_detail_list']['OPS_dossier'] as $module => $champ) {
            $array_return[$module] = $champ; 
            
        }

        return $array_return;

    }

    public function get_name_element_parent($id_parent)
    {

        $name_parent = "";
        if(!empty($id_parent)){
            $flux_element = new OPS_flux_element();
            $liste_flux_element = $flux_element->get_full_list();
            foreach ( $liste_flux_element as $key => $flux_element) {
                if($flux_element->id == $id_parent){
                    $name_parent = $flux_element->name;
                    break;
                }
            }
        }
        return $name_parent;

    }

}

?>