<?php

require_once("custom/modules/AOS_PDF_Templates/OPS_generate_PDF.php");
require_once 'modules/OPS_generateur_champ/generateur_champ.php';


use ODE\Helper\ReplaceVariable;

class OPS_flux_element extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_flux_element';
    public $object_name = 'OPS_flux_element';
    public $table_name = 'ops_flux_element';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $type_element;
    public $champ;
    public $name_flux;
    
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    function get_element_groupe( $id_groupe, $bean ){

        $obj_element = new $this() ;
        $obj_element->retrieve( $id_groupe );

        $tab_elements = $this->get_full_list( 'name', "ops_flux_element.flux_element_parent_id = '".$id_groupe."'"  );

        $tab_elements_sorted = array();

        foreach ($tab_elements as $key => $element) {
            $tab_elements_sorted[$element->ordre] = $element;
        }

        ksort($tab_elements_sorted);

        foreach ($tab_elements_sorted as $key => $value) {

            if( $value->type_element == "groupe" ){
                $tab_flux[$value->name_flux] = $this->get_element_groupe( $value->id ,$bean );
            }else{
                $tab_flux[$value->name_flux] =  $value->get_element_value($bean); 
            }
        }

        return $tab_flux ; 

    }


     function get_element_value($bean){
        
        $value = $this->champ;
        switch ($bean->object_name) {
            case 'OPS_dossier':
                $value = $this->remplace_champs_dossier($bean);
                break;
        }
        return $value ; 
    }
 
    function remplace_champs_dossier($bean){

        global $current_user, $app_list_strings;

        $GenerateurChamp = new GenerateurChamp( $bean->id , "flux", "dossier" );
        $champs_dossier = $GenerateurChamp->getListeChampDossier();

        $value = $this->champ;

        // Vérification que $this->value contient des caractères [#...#] 
        if (preg_match_all('/\[#(.*?)#\]/', $value, $matches)) {
      
            // Initialiser la variable qui va contenir la chaîne finale
            $nouvelle_valeur = $value;
        
            // Parcour chaque élément de matches[1]
            foreach ($matches[1] as $index => $match) {
                // Vérifie si l'élément est une variable (commence par $)
                if (strpos($match, '$') === 0) {
    
                    $ancienne_valeur = $this->champ;
                    $this->champ = $match;
                    // Appeler remplace_champs_dossier pour obtenir la valeur de la variable
                    $valeur_variable = $this->remplace_champs_dossier($bean);
                    // Restaurer l'ancienne valeur de $this->champ
                    $this->champ = $ancienne_valeur;
        
                    // Remplacer l'élément [#...#] dans $value par la valeur de la variable
                    $nouvelle_valeur = str_replace($matches[0][$index], $valeur_variable, $nouvelle_valeur);
                } else {
                    $nouvelle_valeur = str_replace($matches[0][$index], $match, $nouvelle_valeur);
                }
            }
            return $nouvelle_valeur ;
        }


        // Champs du dossier
        if (strpos($this->champ, '$dossier_') !== false) {

            $nom_champ = trim(str_replace('$dossier_', '', $this->champ));
            $champs_exclu = ["id", "name", "date_entered", "date_modified", "modified_user_id", "created_by", "deleted", "num_dossier", "doublon", "ops_etape_id", "ops_statut_id"];
            if(in_array($nom_champ, $champs_exclu)){
                $value = $bean->{$nom_champ};
            }else{
                $ReplaceVariable = new ReplaceVariable($bean);
                $value = ( is_array($champs_dossier) && array_key_exists($nom_champ, $champs_dossier) ) ? $ReplaceVariable->replace( '$ops_dossier_'.$nom_champ ) : "";
            }
            
            // On supprime € et % des valeurs du dossier pour les champs de type montant et pourcentage
            $champ_type = ( is_array($champs_dossier) && array_key_exists($nom_champ, $champs_dossier) ) ? $champs_dossier[$nom_champ]['type'] : "";
            if ( $champ_type === "montant" || $champ_type === "pourcentage" || $champ_type === "nombre" ) {
                $value = ( strpos( $value, '€' ) !== false ) ? str_replace(" ", "", str_replace("€", "", $value) ) : $value;
                $value = ( strpos( $value, '%' ) !== false ) ? str_replace(" ", "", str_replace("%", "", $value) ) : $value;    
            }

        }
            
        // Champs OPS_personne_morale + type personne morale lié au dossier
       if (strpos($this->champ, '$profil_') !== false) {
            $nom_champ = trim(str_replace('$profil_', '', $this->champ));
            $profil = BeanFactory::getBean('OPS_personne_morale',$bean->ops_personne_morale);
            if(!empty($profil->id)){
                $value = $profil->$nom_champ;
                if(!empty($profil->ops_type_personne_id)){
                    $type_profil = new OPS_type_personne();
                    $type_profil->retrieve($profil->ops_type_personne_id);
                    if(!empty($type_profil->id)){
                        if (strpos($this->champ, 'type_profil_')) {
                            $nom_champ = trim(str_replace('$type_profil_', '', $this->champ));
                            $value= $type_profil->$nom_champ;
                        }
                    }
                }
            }
        }

        // Champs OPS_individu => demandeur
        if (strpos($this->champ, '$demandeur_') !== false) {
            $nom_champ = trim(str_replace('$demandeur_', '', $this->champ));
            $demandeurs = $bean->get_linked_beans("ops_individu_ops_dossier", "OPS_individu");
            if(count($demandeurs) > 0){
                $demandeur = $demandeurs[0];
                if(!empty($demandeur->id)){
                    $demandeurDefinitions = $demandeur->getFieldDefinitions();
                    if($demandeurDefinitions[$nom_champ]['type'] == 'enum'){
                        $value = $app_list_strings[$demandeurDefinitions[$nom_champ]['options']][$demandeur->$nom_champ];
                    }else{
                        $value = $demandeur->$nom_champ;
                    }
                }
            }
        }

        // Champs OPS_individu => bénéficiaire
        if (strpos($this->champ, '$beneficiaire_') !== false) {
            $nom_champ = trim(str_replace('$beneficiaire_', '', $this->champ));
            $beneficiaire = BeanFactory::getBean('OPS_individu',$bean->beneficiaire_id );
            if(!empty($beneficiaire->id)){
                $beneficiaireDefinitions = $beneficiaire->getFieldDefinitions();
                    if($beneficiaireDefinitions[$nom_champ]['type'] == 'enum'){
                        $value = $app_list_strings[$beneficiaireDefinitions[$nom_champ]['options']][$beneficiaire->$nom_champ];
                    }else{
                        $value= $beneficiaire->$nom_champ;
                    }
            }
        }

        // Champs OPS_exercice lié au dossier
        if (strpos($this->champ, '$exercice_') !== false) {
            $nom_champ = trim(str_replace('$exercice_', '', $this->champ));
            // On vérifie que le dossier est bien lié à un exercice
            if(!empty($bean->ops_exercice_id)){
                $exercice = new OPS_exercice();
                $exercice->retrieve($bean->ops_exercice_id);
                if(!empty($exercice->id)){
                    $value= $exercice->$nom_champ;
                }
            }
        }
    
        // Champs OPS_statut lié au dossier
        if (strpos($this->champ, '$statut_') !== false) {
            $nom_champ = trim(str_replace('$statut_', '', $this->champ));
            // On vérifie que le dossier est bien lié à un exercice
            if(!empty($bean->ops_statut_id)){
                $statut = new OPS_statut();
                $statut->retrieve($bean->ops_statut_id);
                if(!empty($statut->id)){
                    $value= $statut->$nom_champ;
                }
            }
        }

        // Champs OPS_etape lié au dossier
        if (strpos($this->champ, '$etape_') !== false) {
            $nom_champ = trim(str_replace('$etape_', '', $this->champ));
            // On vérifie que le dossier est bien lié à une étape
            if(!empty($bean->ops_etape_id)){
                $etape = new OPS_etape();
                $etape->retrieve($bean->ops_etape_id);
                if(!empty($etape->id)){
                    $value= $etape->$nom_champ;
                }
            }
        }

        // Champs User lié au lancement du flux
        if (strpos($this->champ, '$user_') !== false) {
            $nom_champ = trim(str_replace('$user_', '', $this->champ));
            if(!empty($current_user->id)){
                $value= $current_user->$nom_champ;
            }
            
        }

        // Champs OPS_dispositif et OPS_guide_intruction liés au dossier
        $dispositifs = $bean->get_linked_beans("ops_dispositif_ops_dossier", "OPS_dispositif");
        if(count($dispositifs) > 0){
            $dispositif = $dispositifs[0];
            if(!empty($dispositif->id)){
                if (strpos($this->champ, '$dispositif_') !== false) {
                    $nom_champ = trim(str_replace('$dispositif_', '', $this->champ));
                    $value= $dispositif->$nom_champ;
                }
                if (strpos($this->champ, '$guide_instruction_') !== false) {
                    $nom_champ = trim(str_replace('$guide_instruction_', '', $this->champ));
                    $guide_instructions = $dispositif->get_linked_beans("ops_guide_instruction_ops_dispositif", "OPS_guide_instruction");
                    if(count($guide_instructions) > 0){
                        $guide_instruction = $guide_instructions[0];
                        if(!empty($guide_instruction->id)){
                            $value= $guide_instruction->$nom_champ;
                        }
                    }
                }

            }
        }

            


        // Champs AOS_PDF_Templates
        if (strpos($this->champ, '$pdf_tpl_id_') !== false) {
            $pdf_template_id = trim(str_replace('$pdf_tpl_id_', '', $this->champ));

            // Check integrity..
            $pdf_template_bean       = BeanFactory::getBean('AOS_PDF_Templates');
            $pdf_template_collection = $pdf_template_bean->get_full_list();

            $bean_pdf_tpl = null;

            foreach ($pdf_template_collection as $key => $pdf_template) {
                if(!empty($pdf_template->id && $pdf_template->id == $pdf_template_id)){
                    $bean_pdf_tpl = $pdf_template;
                }
            }


            if( $bean_pdf_tpl != null ){

                // 1. On crée un nom de fichier conforme, sur la base du nom du template exploité.
                // ... de la forme <current-bean-uid>_<template-slug-name>_<template-uid>
                $pdf_file_name = $bean->id .'_'. OPS_generate_PDF::get_valid_slugfile($bean_pdf_tpl->name) .'_'. $bean_pdf_tpl->id;


                // 2. On lance une génération PDF (template ID vs Data)
                $pdf_file = OPS_generate_PDF::transform_to_pdf( 
                    $bean, 
                    $bean_pdf_tpl->id, 
                    array(), 
                    $pdf_file_name.'.pdf' 
                );


                // 3. On converti en base 64 si on dispose bien d'un fichier
                if( $pdf_file != null && isset($pdf_file['path']) && is_file( $pdf_file['path'] ) ){
                    $pdf_streamb64 = base64_encode( file_get_contents( $pdf_file['path'] ) );

                    $return_value = array(
                        'titre'     => $bean_pdf_tpl->name,
                        'nom'       => $pdf_file_name.'.pdf',
                        'base64'    => $pdf_streamb64
                    );


                }else{

                    $return_value = array(
                        'pdf_tpl_id' => $bean_pdf_tpl->id,
                        'error'      => $pdf_file['error']
                    );

                }

                $erased = OPS_generate_PDF::erase_pdf( $pdf_file['path'] );
                $GLOBALS['log']->fatal(" <OPS_flux_element::remplace_champs_dossier(<bean>".$bean->id.") / > OPS_generate_PDF::erase_pdf( <PDF_path>". $pdf_file['path'] ." ) n'a pas été effacé !");


                $value= $return_value;

            }else{
                $value= $this->champ;
            }
            
        }



        // Champs Document_editique
        if (strpos($this->champ, '$editique_tpl_id_') !== false) {

            if( file_exists('custom/modules/Documents/Documents_editiques.php') ){
                require_once('custom/modules/Documents/Documents_editiques.php');
            }else{
                
                $value = $this->champ;
                $value = str_replace('"',"'",$value);
                $value = str_replace('&quot;',"'",$value);

                return $value ;                 

            }


            // Aucun traitement si la classe Docuument Editique n'existe pas !
            if( !class_exists('Documents_editiques') ){
                $value = $this->champ;
                $value = str_replace('"',"'",$value);
                $value = str_replace('&quot;',"'",$value);

                return $value ;                 
            }


            // Extraction de l'UUID du modèle à exploiter.
            $modele_editique_id = trim(str_replace('$editique_tpl_id_', '', $this->champ));

            // Check integrity...
            $DocumentEditique = new Documents_editiques();
            $modeles_documents_collection = $DocumentEditique->get_modeles_documents();

            $info_modele_document = null;

            // On s'assure que le modèle à exploiter existe toujours... on le recherche via le Helper
            foreach ($modeles_documents_collection as $key => $modele_editique) {
                if(!empty($modele_editique['id']) && $modele_editique['id'] == $modele_editique_id ){
                    $info_modele_document = $modele_editique;
                }
            }

            // Si on a trouvé l'id parmis la liste des modèles actifs, alors on peu traiter de manière saine.
            if( $info_modele_document != null ){

                preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $info_modele_document['id'], $output_array);

                if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                    // 0. On récupère le Bean relatif au modèle existant et actif.
                    $obj_modele_document = BeanFactory::getBean( 'OPS_modele_document' , $info_modele_document['id'] );


                    // 1. On crée un nom de fichier conforme, sur la base du nom du template exploité.
                    // ... de la forme <current-bean-uid>_<template-slug-name>_<template-uid>
                    $editique_file_name = $bean->id .'_'. $DocumentEditique->get_valid_slugfile($info_modele_document['name']) .'_'. $info_modele_document['id'];


                    $format = strtolower( $obj_modele_document->format_sortie );
                    $id     = $info_modele_document['id'];

                    $html_modele_document = !empty( trim($obj_modele_document->description) )? trim($obj_modele_document->description) : '<h1>Attention !</h1><h2>Le modèle utilisé est vide.</h2>';

                    // 2. On appelle le remplacement des variables au sein du modèle de document éditique.
                    # NOTE sur le remplacement de variable...
                    # Nous disposons du module de référence à passer pour le traitement de variables dans le système de remplacement.
                    # Un Document Éditique s'appuie sur un modèle de Document, et un document enregistré associé à un Dossier, Individu ou une Personne Morale.
                    # Ce document enregistré permet dans le fonctiopnnement normal d'identifier dans quel contexte l'éditique est généré (OPS_dossier | OPS_individu | OPS_personne_morale).
                    # Ici, $bean est le contexte du module à passer.

                    $current_bean_name = 'OPS_dossier';
                    $id     = $bean->id;

                    // 3. Procède à la génération du document éditique selon le format associé ( PDF par défaut )
                    $allowed_format = array('odt','doc','pdf');

                    $export = new \stdClass();
                    $export->content   = "";
                    $export->filename  = "";
                    $export->mime      = "";
                    $export->length    = 0;


                    if( in_array($format, $allowed_format) ){

                        switch ($format) {
                            case 'odt':
                                $export = $DocumentEditique->genere_odt($id, $format = "odt", $html_modele_document, $current_bean_name );
                                break;
                            case 'doc':
                                $export = $DocumentEditique->genere_doc($id, $format = "doc", $html_modele_document, $current_bean_name);
                                break;
                            case 'pdf':
                                $export = $DocumentEditique->genere_pdf($id, $format = "pdf", $html_modele_document, $current_bean_name);
                                break;
                            default:
                                $export = false;
                                break;
                        }

                    }

                    $return_value = array(
                        'modele_id'        => $info_modele_document['id'],
                        'modele_name'      => $info_modele_document['name'],
                        'modele_type'      => $info_modele_document['type'],
                        'modele_type_name' => $info_modele_document['type_name'],
                        'modele_type_id'   => $info_modele_document['type_id'],
                        'modele_icone'     => $info_modele_document['icone'],
                    /**/
                        'format'    => $obj_modele_document->format_sortie,

                        'titre'     => trim( $obj_modele_document->name ),
                        'nom'       => $editique_file_name.'.'. strtolower($obj_modele_document->format_sortie),
                        'base64'    => $export->content,
                        'length'    => $export->length,
                        'mime'      => $export->mime,
                        'filename'  => $export->filename,
                    );

                    $value= $return_value;

                }else{

                    // Trace log l'erreur !
                    $GLOBALS['log']->fatal( __CLASS__.' L.'.__LINE__.') - '. "L'id du modèle de document permettant de générer un Document Éditique est incorrect : ". $info_modele_document['id'] );

                    $value= ""; // Retour valeur vide.

                }


            }else{
                // Trace log l'erreur !
                $GLOBALS['log']->fatal( __CLASS__.' L.'.__LINE__.') - '. "L'id du modèle de document permettant de générer un Document Éditique est incorrect : ". $modele_editique_id );

                $value= ""; // Retour valeur vide.
            }
            
        }

        $value = str_replace('"',"'",$value);
        $value = str_replace('&quot;',"'",$value);

        return $value ; 
    }
    
}
