<?php

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Helper\OdeDateHelper;
use ODE\Helper\OdeArrayHelper;
use ODE\Model\GenerateurReferentielModel;
use ODE\Model\GenerateurVueModel;

class GenerateurChamp
{

    private $time_start;
    private $time_end;
    private $initialisation;
    private $type_retour;
    private $champs_referentiel;
    private $generateurReferentielModel;
    private $dossier;

    /**
     * Constructeur de la classe GenerateurChamp
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($dossier_id = "", $type_retour = "", $type_liste = "")
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->initialisation = false;
        $this->initClass($dossier_id, $type_liste);
        $this->initTypeRetour($type_retour);
    }

    /**
     * @access private
     * @name initTypeRetour()
     * Fonction qui initialise la classe
     *
     */
    private function initTypeRetour($type_retour)
    {
        switch ($type_retour) {
            case 'pdf':
                $this->type_retour = [
                    "text", "text_long", "relation",
                    "adresse", "lien", "pourcentage",
                    "bouton_radio", "checkbox", "chaine_libre",
                    "date", "liste", "liste_choix_simple",
                    "numerique", "telephone", "montant","nombre"
                ];
                break;
            case 'flux':
                $this->type_retour = [
                    "text", "text_long", "relation",
                    "adresse", "lien", "pourcentage",
                    "bouton_radio", "checkbox", "chaine_libre",
                    "date", "liste", "liste_choix_simple",
                    "numerique", "telephone", "montant","nombre"
                ];
                break;
            default:
                $this->type_retour = [
                    "text", "text_long", "chaine_libre",
                    "date", "liste", "liste_choix_simple",
                ];
                break;
        }
    }

    /**
     * @access private
     * @name initClass()
     * Fonction qui initialise la classe
     *
     */
    private function initClass($dossier_id = "", $type_liste = "")
    {

        do {

            if (empty($dossier_id)) {
                $GLOBALS['log']->fatal(" GenerateurChamp :: initClass() => Champ dossier_id est vide : initilisez la classe GenerateurChamp avec l'id du dossier ! ");
                break;
            }

            $this->dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            if (empty($this->dossier->id)) {
                $GLOBALS['log']->fatal(" GenerateurChamp :: initClass() => Dossier introuvable : Aucun dossier avec l'id =  " . $dossier_id);
                break;
            }

            if ($type_liste === "dossier") {

                $objDispositif = BeanFactory::getBean('OPS_dispositif',$this->dossier->ops_dispositif_id);
                $objFormulaire = BeanFactory::getBean('OPS_generateur_formulaire',$objDispositif->ops_generateur_formulaire_id);

                $GenerateurVueModel = new GenerateurVueModel($objFormulaire->agent_vue_id);
                $this->champs_referentiel = $GenerateurVueModel->getChamps();

            } else {
                $this->generateurReferentielModel = new GenerateurReferentielModel();
                $this->champs_referentiel = $this->generateurReferentielModel->getFullListe();
            }

            if (!is_array($this->champs_referentiel) || count($this->champs_referentiel) === 0) {
                $GLOBALS['log']->fatal(" GenerateurChamp :: initClass() => Liste vide : la liste des champs du réferentiel est vide ! ");
                break;
            }

            $this->initialisation = true;
        } while (0);
    }

    /**
     * @access public
     * @name getChampValueDisplay()
     * Fonction qui retourne la liste des champs du réferentiel
     *
     *  @return string               - $champs_referentiel: retourne l'appairage de la personne morale
     */
    public function getListeChampDossier()
    {
        if($this->initialisation === true){
            $objDispositif = BeanFactory::getBean('OPS_dispositif',$this->dossier->ops_dispositif_id);
            $objFormulaire = BeanFactory::getBean('OPS_generateur_formulaire',$objDispositif->ops_generateur_formulaire_id);

            $GenerateurVueModel = new GenerateurVueModel($objFormulaire->agent_vue_id);
            return $GenerateurVueModel->getChamps();

        }else{
            return array();
        }
    }

    /**
     * @access public
     * @name getChampValueDisplay()
     * Fonction qui retourne la liste des champs du réferentiel
     *
     *  @return string               - $champs_referentiel: retourne l'appairage de la personne morale
     */
    public function getChampValueDisplay($champ_name)
    {

        if ($this->initialisation === false) return "";

        $champ = $this->getChampReferentiel($champ_name);

        return (is_array($champ) && count($champ) > 0 && !empty($this->dossier->id)) ?  $this->getValueChampByType($champ) : "";
    }

    /**
     * @access public
     * @name getChampValueDisplay()
     * Fonction qui retourne la liste des champs du réferentiel
     *
     *  @param string                - $champ_name : le nom du champ du referentiel
     *  @return string               - $champs_referentiel: retourne l'appairage de la personne morale
     */
    public function getChampReferentiel($champ_name)
    {
        return (!empty($champ_name) && array_key_exists($champ_name, $this->champs_referentiel)) ? $this->champs_referentiel[$champ_name] : array();
    }

    /**
     * @access public
     * @name getChampValueDisplay()
     * Fonction qui retourne la liste des champs du réferentiel
     *
     *  @return string               - $champs_referentiel: retourne l'appairage de la personne morale
     */
    function getValueChampByType($champ)
    {

        if (in_array($champ['type'], $this->type_retour)) {

            switch ($champ['type']) {
                case 'text': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'text_long': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'relation': {
                        $value = $this->getChampRelation($champ);
                        break;
                    }
                case 'adresse': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'lien': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'pourcentage': {
                        $value = $this->getChampPourcentage($champ);
                        break;
                    }
                case 'bouton_radio': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'checkbox': {
                        $value = $this->getChampCheckbox($champ);
                        break;
                    }
                case 'chaine_libre': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'date': {
                        $value = $this->getChampdate($champ);
                        break;
                    }
                case 'liste': {
                        $value = $this->getChampListe($champ);
                        break;
                    }
                case 'liste_choix_simple': {
                        $value = $this->getChampListeChoixSimple($champ);
                        break;
                    }
                case 'numerique': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'telephone': {
                        $value = $this->getChampStandard($champ);
                        break;
                    }
                case 'montant': {
                        $value = $this->getChampMontant($champ);
                        break;
                    }
                case 'nombre': {
                    $value = $this->getChampMontant($champ);
                    break;
                }
            }
        }

        return (!empty($value)) ? trim($value) : "";
    }

    function getChampStandard($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        return (!empty($value)) ? $value : "";
    }

    function getChampdate($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        // Si non vide, on formate la date au format HTML sinon vide
        $value_display = (!empty($value)) ? OdeDateHelper::toHTML($value) : "";
        return (!empty($value_display)) ? $value_display : "";
    }

    function getChampMontant($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        $montant = number_format(floatval($value), 2, ',', ' ');
        return ((float)$montant > 0) ? $montant . " €" : "0,00 €";
    }

    function getChampRelation($champ)
    {

        $value_display = "";
        $array_champs = array("assigned_user_id", "created_by", "modified_user_id");
        $value = (in_array($champ['name'], $array_champs)) ? "" : $this->getValueChamp($champ['name'], $champ['description']);
        $json_formated = base64_decode($champ['params']);
        $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);

        if ($retour_json_to_array['statut'] == "ok") {
            if (in_array($champ['name'], $array_champs)) {

                if ($champ['name'] === "assigned_user_id") {
                    $enregistrement_id = $this->dossier->assigned_user_id;
                    $enregistrement_name = $this->dossier->assigned_user_name;
                }
                if ($champ['name'] === "created_by") {
                    $enregistrement_id = $this->dossier->created_by;
                    $enregistrement_name = $this->dossier->created_by_name;
                }
                if ($champ['name'] === "modified_user_id") {
                    $enregistrement_id = $this->dossier->modified_user_id;
                    $enregistrement_name = $this->dossier->modified_by_name;
                }
                if (!empty($enregistrement_id) &&  !empty($enregistrement_name)) {
                    $enregistrements[0] = array(
                        'id' => $enregistrement_id,
                        'name' => $enregistrement_name
                    );
                } else {
                    $enregistrements = array();
                }
                $data_module = array(
                    'unique' => 'unique',
                    'type' => '',
                    'condition' => '',
                );
                $module = array(
                    'module_name' => 'Users',
                    'enregistrements' => $enregistrements,
                    'nb_enregistrement' => count($enregistrements),
                );
            } else {
                $data_module = $retour_json_to_array['data'];
                $module = $this->getRelatedModule($data_module['module_name'], $data_module['relation_name'], $data_module['unique'], $data_module['type'], $data_module['condition'],  $value);
            }

            if ($data_module['unique'] == 'unique') {
                if ($module['nb_enregistrement'] > 0) {
                    if (!empty($module['enregistrements'][0]['name'])) {
                        $value_display = $module['enregistrements'][0]['name'];
                    }
                }
            } else {
                foreach ($module['enregistrements'] as $enregistrement) {
                    $value_display = $enregistrement['name'];
                }
            }
        }
        return (!empty($value_display)) ? $value_display : "";
    }

    function getRelatedModule($_module_name, $_relation_name, $unique, $type, $condition, $champ_value)
    {

        $retour_enregistrements = array();

        if ($type == "table") {
            if (!empty($condition)) {
                if (!empty($this->dossier->$condition)) {
                    foreach ($_module_name as $module) {
                        if ($module['value'] == $this->dossier->$condition) {
                            $module_name = $module['name'];
                        }
                    }
                    foreach ($_relation_name as $relation) {
                        if ($relation['value'] == $this->dossier->$condition) {
                            $relation_name = $relation['name'];
                        }
                    }
                    $retour_enregistrements = $this->getRelatedModuleTable($module_name, $relation_name, $unique);
                } else {
                    $GLOBALS['log']->fatal(" view.detail.php :: getRelatedModule() => champs référentiel le champ $condition du dossier est null ");
                }
            } else {
                $module_name = $_module_name;
                $relation_name = $_relation_name;
                $retour_enregistrements = $this->getRelatedModuleTable($_module_name, $_relation_name, $unique);
            }
        }

        if ($type == "parent_id" && !empty($champ_value)) {
            // Avec l'id le parent un seul enregistrement est retourné
            $module_name = $_module_name;
            $retour_enregistrements = $this->getRelatedModuleParentID($_module_name, $champ_value);
        }

        $module = array(
            "module_name" => $module_name,
            "enregistrements" => $retour_enregistrements,
            "nb_enregistrement" => ($unique === true) ? 1 : count($retour_enregistrements),
        );
        return $module;
    }

    /**
     * @access private
     * @name getRelatedModuleTable()
     * Fonction qui génere l'affichage des champs de type relation
     *
     *  @param array			$champ: Champ de type "relation"
     *  @return string      $champ_html: retourne la valeur du champ ( Format html )
     */
    function getRelatedModuleTable($module_name, $relation_name, $unique)
    {

        $retour_enregistrements = array();
        $enregistrements =  $this->dossier->get_linked_beans($relation_name, $module_name);

        if (is_array($enregistrements) && count($enregistrements) > 0) {
            if ($unique === true) {
                if (!empty($enregistrements[0]->id) && !empty($enregistrements[0]->name)) {
                    $retour_enregistrements[0] = array(
                        "id" => $enregistrements[0]->id,
                        "name" => $enregistrements[0]->name,
                    );
                }
            } else {
                foreach ($enregistrements as $key => $enregistrement) {
                    if (!empty($enregistrements[$key]->id) && !empty($enregistrements[$key]->name)) {
                        $retour_enregistrements[$key] = array(
                            "id" => $enregistrements[$key]->id,
                            "name" => $enregistrements[$key]->name,
                        );
                    }
                }
            }
        }

        return $retour_enregistrements;
    }

    /**
     * @access private
     * @name getRelatedModuleParentID()
     * Fonction qui génere l'affichage des champs de type relation
     *
     *  @param array			$champ: Champ de type "relation"
     *  @return string      $champ_html: retourne la valeur du champ ( Format html )
     */
    function getRelatedModuleParentID($module_name, $enregistrement_id)
    {


        $enregistrement = array();
        $module_liste = array_intersect($GLOBALS['moduleList'], array_keys($GLOBALS['beanList']));
        if (in_array($module_name, $module_liste, TRUE)) {
            $obj_module = BeanFactory::getBean($module_name, $enregistrement_id);
            if (!empty($obj_module->id)) {
                $enregistrement[0] = array(
                    "id" => $obj_module->id,
                    "name" => $obj_module->name,
                );
            } else {
                if ($enregistrement_id == "1" || $enregistrement_id == 1) {
                    $enregistrement[0] = array(
                        "id" => "1",
                        "name" => "Administrator",
                    );
                }
            }
        } else {
            $GLOBALS['log']->fatal(" view.detail.php :: getRelatedModuleParentID() => Module $module_name non déclaré dans la liste des modules.");
        }
        return $enregistrement;
    }

    function getChampPourcentage($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        $pourcentage = number_format(floatval($value), 2, ',', ' ');
        return ((float)$pourcentage > 0) ?  $pourcentage . " %" : "0,00 %";
    }

    function getChampListe($champ)
    {

        global $app_list_strings;
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        $json_formated = base64_decode($champ['params']);
        $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);
        if ($retour_json_to_array['statut'] == "ok") {
            $params = $retour_json_to_array['data'];
            if (!empty($params['liste_name'])) {
                $liste_name = $params['liste_name'];
                if (array_key_exists($liste_name, $app_list_strings) && !empty($value)) {
                    $liste = $app_list_strings[$liste_name];
                    if (is_array($liste) && count($liste) > 0) {
                        $liste_value = $liste[$value];
                    }
                }
            }
        }
        return (isset($liste_value) && !empty($liste_value)) ? $liste_value : "";
    }

    function getChampListeChoixSimple($champ)
    {

        $value = $this->getValueChamp($champ['name'], $champ['description']);
        $json_formated = base64_decode($champ['params']);
        $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);
        if ($retour_json_to_array['statut'] == "ok") {
            $params = $retour_json_to_array['data'];
            if (!empty($params['liste'])) {
                $liste = $params['liste'];
                if (is_array($liste) && count($liste) > 0) {
                    if (array_key_exists($value, $liste)) {
                        $liste_value = $liste[$value];
                    } else {
                        $liste_value = "";
                    }
                }
            }
        }
        return (isset($liste_value)) ? $liste_value : "";
    }

    function getChampCheckbox($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);
        return ($value == "0") ? "Non" : "Oui";
    }

    function getValueChamp($champ_name, $description)
    {
        return ($description == "basic") ? $this->getValueChampBasic($champ_name) : $this->getValueChampCustom($champ_name);
    }

    function getValueChampBasic($champ_name)
    {
        return (isset($this->dossier->{$champ_name})) ? $this->dossier->{$champ_name} : "";
    }

    function getValueChampCustom($champ_name)
    {
        $champs_custom = (isset($this->dossier->champs_custom) && !empty($this->dossier->champs_custom)) ? json_decode(base64_decode($this->dossier->champs_custom), true) : array();
        if (is_array($champs_custom) && count($champs_custom) > 0) {
            if (array_key_exists($champ_name, $champs_custom) === true) {
                $value = htmlspecialchars($champs_custom[$champ_name], ENT_COMPAT);
            }
        }
        return (isset($value)) ? $value : "";
    }
}
