<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.edit.php');
use ODE\Model\GenerateurReferentielModel;

class OPS_generateur_formulaireViewEdit extends ViewEdit
{
    
    function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }
    
    public function preDisplay()
    {
        global $current_user;
        parent::preDisplay();
        $this->bean->author    = $current_user->name;
        $this->bean->user_id_c = $current_user->id;
    }
    
    function display()
    {
        global $mod_strings, $app_strings, $app_list_strings, $beanFiles, $current_user;
        
        echo '<link href="modules/OPS_generateur_formulaire/css/tiny.css" rel="stylesheet">';
        // Initialisation de la liste des objets
        $dropdown = '';
        foreach ($app_list_strings['base_module_object'] as $key => $value) {
                $dropdown .= "<option value='" . $key . "'>" . $value . "</option>";
        }
        
        $this->ss->assign("LIST_OBJECT", $dropdown);
        
        // Ajout des champs non présent dans le référentiel 
        $array_champs = $mod_strings['CHAMPS_SUPPLEMENTAIRE'];

        $array_champs_exclus = array('created_by','modified_user_id');

        $obj_dossier = new OPS_dossier(); 
        $mods_strings_dossier = return_module_language("fr", "OPS_dossier");
        
        $dossier_custom_fields = GenerateurReferentielModel::getCustomFieldListe();

        foreach( $obj_dossier->field_defs as $field ) {

            if( $field['type'] != "link"  && $field['type'] != "relate" && !in_array($field['name'], $array_champs_exclus)){

                if( !empty( $mod_strings[$field['vname']] ) || !empty( $mods_strings_dossier[$field['vname']] ) ){

                    if( !empty( $mod_strings[$field['vname']] ) ){
                        $array_champs[$field['name']] = html_entity_decode( $mod_strings[$field['vname']] , ENT_QUOTES , 'UTF-8') ;
                    }
                    else{
                        $array_champs[$field['name']] = html_entity_decode($mods_strings_dossier[$field['vname']], ENT_QUOTES , 'UTF-8') ;
                    }
                }
            }

        }  
        $all_champs = array_merge( $array_champs, $dossier_custom_fields);
        
        asort($all_champs);

        $this->ss->assign("LIST_REFERENTIEL",base64_encode(json_encode($all_champs)) );


        parent::display();
        $this->displayTMCE();
    }
    
    
    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;
        
        $tiny    = new SugarTinyMCE();
        $tinyMCE = '';// $tiny->getConfig();
        
        $js = <<<JS
        <!-- Customized Tiny -->
       <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        let wysiwyg_id = 'description';

        try{ 
            tinymce.execCommand('mceRemoveControl', true, wysiwyg_id);
        }
        catch(Exception){ /**/ }


        tinyMCE.init({
            selector: '#description',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
            content_css: "/modules/OPS_generateur_formulaire/css/cover.custom_content.css",

            table_col_limit : 2,
            table_row_limit : 15,
            table_default_styles: {},
            table_sizing_mode: 'auto',
            table_responsive_width: false,
            table_default_styles: { width: '', height: '', },

            /*
            table_styles : "Table flottante ¼=gru-dossier-cover-25;Table flottante ⅓=gru-dossier-cover-33;Table flottante ½=gru-dossier-cover-50;Table flottante ⅔=gru-dossier-cover-66;Table flottante ¾=gru-dossier-cover-75;Table flottante ⇿=gru-dossier-cover",
            /**/

            table_class_list: "Table flottante ¼=gru-dossier-cover-25;Table flottante ⅓=gru-dossier-cover-33;Table flottante ½=gru-dossier-cover-50;Table flottante ⅔=gru-dossier-cover-66;Table flottante ¾=gru-dossier-cover-75;Table flottante ⇿=gru-dossier-cover",
            table_cell_styles : "Section Dossier=dossier;Section Profil=profil;Section Demandeur=demandeur;Section Bénéficiaire=beneficiaire;Section Documents=documents;Section Justificatifs=justificatifs",

            /*table_inline_editing : true,/**/

        });
        </script>

JS;
        echo $js;
    }
}

?> 