
<?php

use ODE\Helper\OdeArrayHelper;
require_once 'include/utils.php';

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');


class OPS_generateur_ongletController extends SugarController
{

    /**
     * @access public
     * action_generate_uuid()
     * Fonction qui génère un uuid pour l'onglet
     * 
     * @return json     $data
     */
    public function action_generate_uuid()
    {
        $libelle_erreur = "";
        $data_retour = array();

        // La liste des champs à vérifier 
        $champs = array("json" => true);

        // Vérification des données recu en Ajax , on passe en parametre Request et la liste des champs à vérifier
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);

        if ($data_verified['statut'] == 'ok') {
            $onglet = $data_verified['data']['json_array'];

            //$onglet['id'] = Sugarcrm\Sugarcrm\Util\Uuid::uuid1();
            $onglet['id'] = create_guid();

            // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
            $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $onglet) : array('statut' => 'err', 'data' => $libelle_erreur);
        }else{
            $libelle_erreur = "Génération uuid échoué";
        }

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
    /**
     * @access public
     * action_create()
     * Fonction qui crée un onglet
     * 
     * @return json     $data
     */
    public function action_sauvegarder()
    {

        $libelle_erreur = "";
        $data_retour = array();

        // La liste des champs à vérifier 
        $champs = array("json" => true);

        // Vérification des données recu en Ajax , on passe en parametre Request et la liste des champs à vérifier
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {
            $onglet = $data_verified['data']['json_array'];
            // Si l'id vue est vide => on retourne une erreur
            if (!empty($onglet["vue_id"])) {

                if(!empty($onglet["id"]) && $onglet["fake"]){


                    // On récupere la vue 
                    $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $onglet['vue_id']);
                    $obj_onglet = BeanFactory::newBean('OPS_generateur_onglet');
                    $obj_onglet->name = strtolower(str_replace(" ", "_", $onglet['libelle']));
                    $obj_onglet->libelle = $onglet['libelle'];
                    $obj_onglet->cle = $onglet['cle'];
                    $obj_onglet->ordre = $onglet['ordre'];
                    $obj_onglet->conditions = $onglet['conditions'];
                    $obj_onglet->description = $onglet['description'];
                    $obj_onglet->visible = $onglet['visible'];
                    $obj_onglet->modifiable = $onglet['modifiable'];

                    //$obj_onglet->save( [ 'id'=>$onglet['id'] ] );
                    $obj_onglet->new_with_id = true;
                    $obj_onglet->id = $onglet['id'];
                    $obj_onglet->save();

                    $obj_generateur_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
                    $obj_generateur_vue->ops_generateur_vue_ops_generateur_onglet->add($obj_onglet->id);

                    $onglet["nom"] = strtolower(str_replace(" ", "_", $onglet['libelle']));
                }elseif (!empty($onglet["id"])) {

                    $obj_onglet = BeanFactory::getBean('OPS_generateur_onglet', $onglet['id']);
                    if (!empty($obj_onglet->id)) {
                        $obj_onglet->libelle = $onglet['libelle'];
                        $obj_onglet->conditions = $onglet['conditions'];
                        $obj_onglet->description = $onglet['description'];
                        $obj_onglet->visible = $onglet['visible'];
                        $obj_onglet->modifiable = $onglet['modifiable'];
                        $obj_onglet->save();
                    } else {
                        $libelle_erreur = "L'onglet n'a pas pu etre récupérer à la vue";
                    }
                } else {

                    // On récupere la vue 
                    $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $onglet['vue_id']);
                    $obj_onglet = BeanFactory::newBean('OPS_generateur_onglet');
                    $obj_onglet->name = strtolower(str_replace(" ", "_", $onglet['libelle']));
                    $obj_onglet->libelle = $onglet['libelle'];
                    $obj_onglet->cle = $onglet['cle'];
                    $obj_onglet->ordre = $onglet['ordre'];
                    $obj_onglet->conditions = $onglet['conditions'];
                    $obj_onglet->description = $onglet['description'];
                    $obj_onglet->visible = $onglet['visible'];
                    $obj_onglet->modifiable = $onglet['modifiable'];
                    $obj_onglet->save(false);

                    $obj_generateur_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
                    $obj_generateur_vue->ops_generateur_vue_ops_generateur_onglet->add($obj_onglet->id);

                    $onglet["id"] = $obj_onglet->id;
                }
            } else {
                $libelle_erreur = "L'onglet n'a pas pu etre ajouter à la vue";
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $onglet) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_addOnglet()
     * Fonction qui crée un onglet
     * 
     * @return json     $data
     */
    public function action_addOnglet()
    {


        $libelle_erreur = '';
        $data_retour = array();

        // La liste des champs à vérifier 
        $champs = array("json" => true);

        // Vérification des données recu en Ajax , on passe en parametre Request et la liste des champs à vérifier
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, $champs);

        if ($data_verified['statut'] == 'ok') {

            $onglet = $data_verified['data']['json_array'];
            $obj_generateur_vue = BeanFactory::getBean('OPS_generateur_vue', $onglet['vue_id']);
            // Vérification de l'onglet
            $verification_onglet = $this->isOngletValid($obj_generateur_vue, $onglet);

            if ($verification_onglet['statut'] == 'ok') {

                $obj_onglet = BeanFactory::newBean('OPS_generateur_onglet');
                $obj_onglet->name = strtolower(str_replace(" ", "_", $onglet['libelle']));
                $obj_onglet->libelle = $onglet['libelle'];
                $obj_onglet->cle = $onglet['cle'];
                $obj_onglet->conditions = $onglet['conditions'];
                $obj_onglet->description = $onglet['description'];
                $obj_onglet->visible = $onglet['visible'];
                $obj_onglet->modifiable = $onglet['modifiable'];

                if (is_numeric($verification_onglet['data'])) {
                    $obj_onglet->ordre = $verification_onglet['data'];
                }

                $id = $obj_onglet->save(false);

                $obj_generateur_vue->load_relationship('ops_generateur_vue_ops_generateur_onglet');
                $obj_generateur_vue->ops_generateur_vue_ops_generateur_onglet->add($id);

                if (!empty($id)) {

                    $data_retour['onglet'] = array(
                        'id' => $id,
                        'name' => $obj_onglet->name,
                        'libelle' => $obj_onglet->libelle,
                        'cle' => $obj_onglet->cle,
                        'conditions' => $obj_onglet->conditions,
                        'description' => $obj_onglet->description,
                        'visible' => $obj_onglet->visible,
                        'modifiable' => $obj_onglet->modifiable,
                    );
                } else {
                    $libelle_erreur = "Echéc de la création de l'onglet";
                }
            } else {
                $libelle_erreur = $verification_onglet['data'];
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $data_retour) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_editOnglet()
     * Fonction qui modifie un onglet
     *
     * @return json     $data
     */
    function action_editOnglet()
    {


        $libelle_erreur = '';
        $data_retour = array();

        // La liste des champs à vérifier 
        $champs = array("json" => true);


        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $onglet = $data_verified['data']['json_array'];
            $obj_onglet = new OPS_generateur_onglet;
            $obj_onglet->retrieve($onglet['id']);

            if (!empty($obj_onglet->id)) {
                $obj_onglet->name = strtolower(str_replace(" ", "_", $onglet['libelle']));
                $obj_onglet->libelle = $onglet['libelle'];
                $obj_onglet->cle = $onglet['cle'];

                if ($obj_onglet->save()) {

                    $data_retour['onglet'] = array(
                        'id' => $obj_onglet->id,
                        'name' => $obj_onglet->name,
                        'libelle' => $obj_onglet->libelle,
                        'cle' => $obj_onglet->cle,
                    );
                } else {
                    $libelle_erreur = "L'onglet n'a pas été modifié.";
                }
            } else {
                $libelle_erreur = "L'onglet n'a pas pu etre retrouver.";
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $data_retour) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * action_deleteOnglet()
     * Fonction qui supprime un onglet et 
     *
     * @return json     $data
     */
    function action_deleteOnglet()
    {

        $libelle_erreur = '';
        // La liste des champs à vérifier 
        $champs = array("json" => true);

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $donnees = $data_verified['data']['json_array'];
            $obj_onglet = (!empty($donnees['id'])) ? BeanFactory::getBean('OPS_generateur_onglet', $donnees['id']) : false;
            if (!empty($obj_onglet->id)) {
                $liste_champs = $obj_onglet->get_linked_beans("ops_dossier_documents", "OPS_dossier");
                if (is_array($liste_champs) && count($liste_champs) > 0) {
                    foreach ($liste_champs as $champ) {
                        $champ->mark_deleted($champ->id);
                    }
                }
                $data_retour = [
                    'id' => $obj_onglet->id,
                    'libelle' => $obj_onglet->libelle
                ];
                $obj_onglet->mark_deleted($obj_onglet->id);
            } else {
                $libelle_erreur = "Onglet inconnu";
            }
        } else {
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $data_retour) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access private
     * isOngletValid()
     * Fonction qui vérifie 
     *
     */
    private function isOngletValid($obj_generateur_vue, $new_onglet)
    {

        $statut = 'ok';
        $data_retour = "";
        $ordre = 1;

        if (!empty($obj_generateur_vue->id)) {

            $onglets = $obj_generateur_vue->get_linked_beans("ops_generateur_vue_ops_generateur_onglet", "OPS_generateur_onglet");
            foreach ($onglets as $onglet) {

                if (is_numeric($onglet->ordre)) {
                    if ($onglet->ordre >= $ordre) {
                        $ordre = $onglet->ordre + 1;
                    }
                }

                if ($onglet->name === strtolower(str_replace(" ", "_", $new_onglet['libelle']))) {
                    $data_retour = "Un onglet avec meme nom est deja rattaché à la vue";
                    $statut = 'err';
                    break;
                }
            }
        } else {
            $data_retour = "L'id de correspond à aucune vue dans OpenSub";
            $statut = 'err';
        }

        if ($statut == 'ok') {
            $data_retour = $ordre;
        }

        return ['statut' => $statut, 'data' => $data_retour];
    }
}
