<?php


class OPS_generateur_version extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_generateur_version';
    public $object_name = 'OPS_generateur_version';
    public $table_name = 'ops_generateur_version';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $vue_json;
	
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }
    
    /**
     * @access public
     * @name getVersionOptions()
     * Fonction qui retourne les options pour le select lors de la sauvegarde
     * 
     *  @param  string                      $vue_id: l'id de la vue 
     *  @param  string                      $type_retour: "array" ou autre
     *  @return array|string                $options:  si  $type_retour = "array" retourne un tableau d'options
     *                                                  sinon retoune les options en code html
    */
    public function getVersionOptions($vue_id, $type_retour = null){

        
        $vue_versions = array();

        // On récupere les versions rattachées à la vue 
        $vue = BeanFactory::getBean('OPS_generateur_formulaire', $vue_id);
        if( !empty( $vue->id ) ){
            $versions = $vue->get_linked_beans("ops_generateur_version_ops_generateur_formulaire","OPS_generateur_version");
            if( is_array($versions) && count($versions) > 0 ){
                foreach ($versions as $key => $version) {
                    $vue_versions[] = $version->name;
                }
            }
        }

        // On trie les version et on récupere la derniere 
        if( is_array($vue_versions) && count($vue_versions) > 0 ){
            sort($vue_versions);
            $version_courante = end($vue_versions);
        }else{
            $version_courante = 0;
        }

        // On initialise les options selon le $type en param , string ar défaut
        $options = ( $type_retour == "array" ) ? array() : "" ;

        if( $version_courante != 0 ){
            $version_courante_base = floor($version_courante);
            $version_courante_decimal = ( $version_courante - $version_courante_base ) * 10;
            for ( $i = $version_courante_decimal + 1 ; $i < 10 ; $i++) { 

                $value = $version_courante_base.".".$i;
                if( $type_retour == "array" ) $options[$value] = "".$value;
                else $options .= '<option value="'.$value.'">'.$value.'</option>';
    
            }
            $last = $version_courante_base + 1;
            if( $type_retour == "array" ) $options[$last] = $last;
            else $options .= '<option value="'.$last.'.0">'.$last.'.0</option>';
        }else{

            if( $type_retour == "array" ) $options["1.0"] = "1.0";
            else $options = '<option value="1.0">1.0</option>';
        }
        return $options;

    }

    /**
     * @access public
     * @name getVersionMessage()
     * Fonction qui retourne le message afficher dans la modal lors de la sauvegarde
     * 
     *  @param  string                      $vue_id: l'id de la vue 
     *  @param  string                      $type_retour: "array" ou autre
     *  @return array|string                $options:  si  $type_retour = "array" retourne un tableau avec la version, le nom de l'utilisateur qui l'a crée et la date
     *                                                  sinon retoune le message en code html             
    */
    public function getVersionMessage($vue_id, $type_retour = null){

        $message = "";
        $version = "";
        $user_name = "null";
        $date_created = "null";
        $vue_versions = array();

        $vue = new OPS_generateur_formulaire;
        $vue->retrieve($vue_id);

        $versions = $vue->get_linked_beans("ops_generateur_version_ops_generateur_formulaire","OPS_generateur_version");
        if( is_array($versions) && count($versions) > 0 ){
            foreach ($versions as $key => $version) {
                $vue_versions[$version->name] = $version;
            }
        }

        if( is_array($vue_versions) && count($vue_versions) > 0 ){
            ksort($vue_versions);
            foreach ($vue_versions as $key => $value) {
                $version_courante = $key;
            }
        }else{
            $version_courante = 0;
        }
        
        if( $version_courante != 0 ){
            if ( array_key_exists( $version_courante, $vue_versions ) ){

                if ( !empty($vue_versions[$version_courante]->name) ) {
                    $obj_version = $vue_versions[$version_courante]->name;
                    $base = floor($obj_version);
                    $decimal = $obj_version - $base;
                    $version = ( $decimal == 0 ) ? "v".$base.".0"  :  "v".$base.".".$decimal*10 ;
                }

                if ( !empty($vue_versions[$version_courante]->created_by_name) ) {
                    $user_name = $vue_versions[$version_courante]->created_by_name;
                }

                if ( !empty($vue_versions[$version_courante]->date_entered) ) {
                    $date_created = $vue_versions[$version_courante]->date_entered;
                }

            }
        }

        if( $type_retour == "array" ){
            if( !empty( $version ) ){
                $message = array(
                    "version" => $version,
                    "user_name" => $user_name,
                    "date_created" => $date_created,
                );
            }else{
                $message = array();
            }
        }else{
            if( !empty( $version ) ){
                $message = 'Derniere version sauvegardée: '.$version.' par <strong>'.$user_name.'</strong> le <strong>'.$date_created.'</strong>';
            }else{
                $message = 'Aucune version sauvegardée';
            }
        }

        return $message;

    }
}