<?php


class hook_generateur_vue
{

	// Méthode du hook « Cleanup »
	function delete_related_relations( $bean, $event, $arguments = null)
	{
		
		// Bypass if not allowed event in the hook. ( define witch event is used )
		if ( ! in_array( $event , [ 'before_delete' ,  '' ] ) ) {
			return;
		}
   

		$is_erreur = false;


		// On récupere le bean en question.
		$obj_bean = ( !empty( $bean->id )) ? BeanFactory::getBean('OPS_generateur_vue', $bean->id ) : false;


		# On vérifie de disposer véritablement d'un dossier.
		if( $obj_bean === false ){

			$is_erreur = true;

			$GLOBALS['log']->fatal(" hook_generateur_vue :: delete_related_relations => Récupération impossible du Bean Generateur Vue !");
			return;

		}



		// Global context : ODE_CORE

		# OPS_generateur_onglet
		$liste_generateur_onglet = $bean->get_linked_beans("ops_generateur_vue_ops_generateur_onglet","OPS_generateur_onglet");

		foreach ($liste_generateur_onglet as $key => $obj_generateur_onglet) {

			$liste_generateur_champ = $obj_generateur_onglet->get_linked_beans("ops_generateur_onglet_ops_generateur_champ","OPS_generateur_champ");

			foreach ($liste_generateur_champ as $key => $obj_generateur_champ) {

 				$obj_generateur_champ->mark_deleted( $obj_generateur_champ->id );

			}

 			$obj_generateur_onglet->mark_deleted( $obj_generateur_onglet->id );
		}





		# OPS_generateur_version
		$liste_generateur_version	  = $bean->get_linked_beans("ops_generateur_version_ops_generateur_vue","OPS_generateur_version");

		foreach ($liste_generateur_version as $key => $obj_generateur_version) {

 			$obj_generateur_version->mark_deleted( $obj_generateur_version->id );

		}

		

	}


}
