<?php


class OPS_guide_instruction extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_guide_instruction';
    public $object_name = 'OPS_guide_instruction';
    public $table_name = 'ops_guide_instruction';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $statut_initial;
	
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    function liste_etapes( $visible_usager = false, $vue = 'usager' ) {

        global $app_list_strings, $beanFiles;
    
        require_once($beanFiles["OPS_etape"]);

        $etapes = $this->get_linked_beans('ops_guide_instruction_ops_etape' , 'OPS_etape');

         // Création du tableau de récupération des etapes 
        foreach ( $etapes as $etape ) { 
            // Récupération des étapes
            $obj_etape = new OPS_etape();
            $obj_etape->retrieve($etape->id);

            // Ajout de la vérification pour l'affichage en FO / BO 
            if ($vue == 'usager') {
                if( $visible_usager == false || $obj_etape->visible_usager == true  ){

                    $liste_etapes[$obj_etape->ordre]['id'] =  $obj_etape->id;
                    $liste_etapes[$obj_etape->ordre]['name'] = $obj_etape->name;
                    $liste_etapes[$obj_etape->ordre]['libelle_usager'] = ( !empty($obj_etape->libelle_usager)) ? $obj_etape->libelle_usager : $obj_etape->name; 
                    $liste_etapes[$obj_etape->ordre]['instruction'] =  base64_encode(utf8_decode($obj_etape->instruction));
                }
            } else if ($vue == 'partenaire' && isset($app_list_strings['moduleList']['OPS_avis'])) { # Surcharge module partenaire 
                if( $visible_usager == false || $obj_etape->visible_partenaire == true  ){

                    $liste_etapes[$obj_etape->ordre]['id'] =  $obj_etape->id;
                    $liste_etapes[$obj_etape->ordre]['name'] = $obj_etape->name;
                    $liste_etapes[$obj_etape->ordre]['libelle_usager'] = ( !empty($obj_etape->libelle_partenaire)) ? $obj_etape->libelle_partenaire : $obj_etape->name; 
                    $liste_etapes[$obj_etape->ordre]['instruction'] =  base64_encode(utf8_decode($obj_etape->instruction));
                }
            }
        }

        if(!empty($liste_etapes))
            ksort($liste_etapes);
        return $liste_etapes ; 

    }
}