String.prototype.utf8_to_b64=function(){return $.base64.encode(unescape(encodeURIComponent(this)))};
String.prototype.b64_to_utf8=function(){return decodeURIComponent(escape($.base64.decode(this)))};


// Fonction qui ouvert la modal " Exporter JSON "
function openModalExporterJson(){


    //event bouton exporter
    var bouton = document.getElementById("form_export_guide_lot_btn_execute");
    // Ajoutez un écouteur d'événements
    bouton.addEventListener("click", function() {
        execute('exporterJson', 'OPS_guide_instruction');
        $("#modal_exporter_json").dialog("close");

    });
    
    //event bouton annuler
    var bouton_annuler = document.getElementById("form_annuler_export_guide_lot_btn_terminer");
    // Ajoutez un écouteur d'événements
    bouton_annuler.addEventListener("click", function() {
        $("#modal_exporter_json").dialog("close");
    });

    
    var modal_width = window.innerWidth / 1.5;
    var modal_height = window.innerHeight / 1.5;

    $( "#modal_exporter_json" ).dialog({

        resizable: false,
        height: modal_height,
        width: modal_width,
        modal: true,
        dialogClass: "no-close",
        draggable: false,
        autoOpen: false,
        show: {
          effect: "fade",
          duration: 400
        },
        hide: {
          effect: "fade",
          duration: 800
        },
        
    });

    $( "#modal_exporter_json" ).dialog( "open" );
    $(".ui-dialog-titlebar.ui-widget-header.ui-corner-all.ui-helper-clearfix").css("display","none");

    execute( 'initFormulaireExport' , 'OPS_guide_instruction' );

}


function initOnChangeFunctions() {

    var coll = document.getElementsByClassName("collapsible-guide");
    var i;
    
    for (i = 0; i < coll.length; i++) {

        coll[i].addEventListener("click", function(event) {

            this.classList.toggle("active");
            var content = this.nextElementSibling;

            if (content.style.display === "block") {

                content.style.display = "none";
                if( event.target.tagName === "BUTTON" && event.target.getElementsByTagName("SPAN").length > 0 ){
                    event.target.getElementsByTagName("SPAN")[0].className = "glyphicon glyphicon-menu-up";
                } 
                if( event.target.tagName === "SPAN" ){
                    event.target.className = "glyphicon glyphicon-menu-up";
                }

            } else {
            
                content.style.display = "block";
                if(  event.target.tagName === "BUTTON" && event.target.getElementsByTagName("SPAN").length > 0 ){
                    event.target.getElementsByTagName("SPAN")[0].className = "glyphicon glyphicon-menu-down";
                } 
                if( event.target.tagName === "SPAN" ){
                    event.target.className =  "glyphicon glyphicon-menu-down";
                }

            }

        });

    }

    $( "input[role='guide_instruction']" ).change( function() {
        if ( $(this).length > 0 ) {
            $(this).each( function( index, guide ) {
                var guide_id = guide.id;
                var guide_checked = $(guide).is(':checked');
                $('[data-guide-id="'+guide_id+'"]').each( function( index, etape ) {
                    var etape_id = etape.id;
                    $(etape).prop( "checked", guide_checked );
                    $('[data-etape-id="'+etape_id+'"]').each( function( index, statut ) {
                        $(statut).prop( "checked", guide_checked );
                    });
                });
            });
        }
        updateButtonExporter();
    });

    $( "input[role='etape']" ).change( function() {
        if ( $(this).length > 0 ) {
            $(this).each( function( index, etape ) {
                var etape_id = etape.id;
                var etape_checked = $(etape).is(':checked');
                if ( etape_checked === true ) $("#"+ $(etape).attr("data-guide-id") ).prop( "checked", true );
                $('[data-etape-id="'+etape_id+'"]').each( function( index, statut ) {
                    $(statut).prop( "checked", etape_checked );
                });
            });
        }
        updateButtonExporter();
    });

    $( "input[role='statut']" ).change( function() {
        if ( $(this).length > 0 ) {
            $(this).each( function( index, statut ) {
                var statut_checked = $(statut).is(':checked');
                if ( statut_checked === true ){
                    $("#"+ $(statut).attr("data-etape-id") ).prop( "checked", true );
                    $("#"+ $("#"+ $(statut).attr("data-etape-id") ).attr("data-guide-id") ).prop( "checked", true );
                } 
            });
        }
        updateButtonExporter();
    });

}

function updateButtonExporter(){

    var guide_selected = false;
    $('[role="guide_instruction"]').each( function( index, guide ) {
        if( $(guide).is(':checked') === true ){  guide_selected = true; }
    });
    
    if ( guide_selected === false ){
        $("#form_exporter_btn_exporter").addClass( "btn-modal-exporter-disabled" )
        $("#form_exporter_btn_exporter").prop("disabled",true);
    } else {
        $("#form_exporter_btn_exporter").removeClass( "btn-modal-exporter-disabled" )
        $("#form_exporter_btn_exporter").prop("disabled",false);
    }

}

function download(filename, text) {
    var element = document.createElement('a');
    element.setAttribute('href', 'data:application/json;charset=utf-8,' + encodeURIComponent(text));
    element.setAttribute('download', filename);

    element.style.display = 'none';
    document.body.appendChild(element);

    element.click();

    document.body.removeChild(element);
}

/**------------------------------------------------------------------------- Fonctions Ajax ------------------------------------------------------------------- */


// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionExporter = {
    initFormulaireExport: function(data) {

        var guides_html = '';

        if (data) {
            if (data['statut'] == "ok") {

                var guides = data['data'].guides;

                if( Object.size( guides ) > 0 ){
                    Object.keys( guides ).forEach( function(guide_id) {

                        const guide = guides[guide_id];

                        guides_html += '<button type="button" class="collapsible-guide active" >';
                        guides_html +=     '<input type="checkbox" role="guide_instruction" checked="checked" id="' + guide_id + '" style="margin-right: 15px;" onclick="event.stopPropagation();" />';
                        guides_html +=      guide.name;
                        guides_html +=     '<span class="glyphicon glyphicon-menu-up" style="float: right; margin-right: 10px; font-size: 18px;"></span>';
                        guides_html += '</button>';

                        guides_html += '<div class="content-guide" >';

                        if( Object.size( guide.etapes ) > 0 ){
                            Object.keys( guide.etapes ).forEach( function( etape_id ) {

                                const etape = guide.etapes[etape_id];

                                guides_html += '<div class="row" style="padding: 5px;">';
                                guides_html +=     '<div class="col-md-1" style="text-align: center;">';
                                guides_html +=         '<input role="etape" id="' + etape_id + '" data-guide-id="' + guide_id + '" type="checkbox" checked="checked" />';
                                guides_html +=     '</div>';
                                guides_html +=     '<div class="col-md-8" style="font-weight: bold;"> ';
                                guides_html +=         etape.name;
                                guides_html +=     '</div>';
                                guides_html += '</div>';

                                if( Object.size( etape.statuts ) > 0 ){
                                    Object.keys( etape.statuts ).forEach( function( statut_id ) {

                                        const statut = etape.statuts[statut_id];

                                        guides_html += '<div class="row" style="padding: 5px;">';
                                        guides_html +=     '<div class="col-md-1" style="text-align: center;margin-left: 50px;">';
                                        guides_html +=         '<input role="statut" id="' + statut_id + '" type="checkbox" data-etape-id="'+ etape_id + '" checked="checked" onclick="event.stopPropagation();">';
                                        guides_html +=     '</div>';
                                        guides_html +=    '<div class="col-md-8">';
                                        guides_html +=      statut.name;
                                        guides_html +=    '</div>';
                                        guides_html += '</div>';

                                    });
                                }

                            });
                        }

                        guides_html += '</div>';

                    });
                }
             

            } else {
                console.log("initFormulaireExport() => Erreur = ", data['data'] )
            }
        } else {
            console.log("initFormulaireExport() => Erreur AJAX")
        }

        $("#modal_exporter").empty();
        $("#modal_exporter").append( guides_html );

        initOnChangeFunctions();

    },
    exporterJson: function(data) {
        if (data) {
            if (data['statut'] == "ok") {
                if( typeof data['data']['guides'] === "object" && Object.size( data['data']['guides'] ) > 0 ){
                    var guides = JSON.stringify( data['data']['guides'] );
                    download("guide_instructions.json", guides);
                } else {
                    console.log("exporterJson() => Erreur Object guides < 0 ")
                }
            } else {
                console.log("exporterJson() => Erreur = ", data['data'] )
            }
        } else {
            console.log("exporterJson() => Erreur AJAX")
        }
    },
};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionExporter : Object.assign(retourFunction, retourFunctionExporter);

// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionExporter = {
    initFormulaireExport: function() {
        console.log("initFormulaireExport loadingFunction =")
    },
    exporterJson: function() {
        console.log("exporterJson loadingFunction =")
    }
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionExporter : Object.assign(loadingFunction, loadingFunctionExporter);

// Cette variable regroupe les differentes fonctions de récupération des données à envoyer au PHP
var getDataFunctionExporter = {
    initFormulaireExport: function() {
        var data = false;
        var guides = getGuides();
        if( typeof guides === "string" && guides !== "" ){
            data = "guides=" + guides; 
        }
        return data; 
    },
    exporterJson: function() {

        var json = {
            guides: [],
            etapes: [],
            statuts: []
        };
        
        if ( $( "input[role='guide_instruction']" ).length > 0 ) {
            $( "input[role='guide_instruction']" ).each( function( index, guide ) {
                if( $(guide).is(':checked') === true ){
                    json.guides.push(guide.id);
                    $('[data-guide-id="'+guide.id+'"]').each( function( index, etape ) {
                        if( $(etape).is(':checked') === true ){
                            json.etapes.push(etape.id);
                            $('[data-etape-id="'+etape.id+'"]').each( function( index, statut ) {
                                if( $(statut).is(':checked') === true ){
                                    json.statuts.push(statut.id);
                                }
                            });
                        }
                    });
                }
            });
        }

        return ( json.guides.length > 0 ) ? "json=" + utf8_to_b64( JSON.stringify( json ) ) : false; 
    }
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionExporter : Object.assign(getDataFunction, getDataFunctionExporter);
/**-------------------------------------------------------------------------------------------------------------------------------------------------------------- */


function getGuides() {

    var guides = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }

    guides = tabId + '&selectAll=0';

    if (document.MassUpdate.select_entire_list.value == 1) {
        guides = json + '&selectAll=1';
    }

    return guides;

}


