<?php


class hook_individu {

    //
    // Fonction d'initialisation du numéro de la demande
    //
    function set_num_individu(&$bean, $event, $arguments = null) 
    {        
        if($event != 'before_save'){
          return;
        }
        
        if (empty($bean->num_individu)) {
            global $db;
            
            $sql_num = 'SELECT num_individu FROM ops_individu WHERE deleted = 0 AND num_individu != "" ORDER BY num_individu DESC LIMIT 1';
            
            $result_num = $db->query($sql_num);
            if(!$result_num) {
                return $db->lastError();
            }
            
            if ($db->getRowCount($result_num) == 0) {
                $bean->num_individu=1;
            } else {
                $row_num = $db->fetchByAssoc($result_num) ;
                $bean->num_individu=$row_num['num_individu']+1;
            }
        }

        $bean->first_name = mb_convert_case( ucwords( strtolower(html_entity_decode($bean->first_name) ) , "-, \t\r\n\f\v'" ) , MB_CASE_TITLE, "UTF-8");
        $bean->last_name  = mb_convert_case( ucwords( strtolower(html_entity_decode($bean->last_name) ) , "-, \t\r\n\f\v'" ) , MB_CASE_UPPER, "UTF-8");
        $bean->nom_usage  = mb_convert_case( ucwords( strtolower(html_entity_decode($bean->nom_usage) ) , "-, \t\r\n\f\v'" ) , MB_CASE_UPPER, "UTF-8");
    }  
    
    function deleteRelation(&$bean, $event, $arguments = null ){
        global $db;
        
        if($event != 'before_delete' || $_REQUEST['module'] == "MergeRecords"){
            return;
        }

        require_once('modules/OPS_individu/OPS_individu.php');
        require_once('modules/OPS_dossier/OPS_dossier.php');

        // Ajout dans le registre des suppression
        $beanRegistre = BeanFactory::newBean("OPS_registre_suppression_individu");
        $beanRegistre->name = $bean->last_name . ' ' . $bean->first_name;
        $beanRegistre->nom_usage = $bean->nom_usage;
        $beanRegistre->last_name = $bean->last_name;
        $beanRegistre->first_name = $bean->first_name;
        $beanRegistre->date_creation = $bean->date_entered;
        $beanRegistre->salutation = $bean->salutation;

        $beanRegistre->origine_suppression = (is_array($_REQUEST) && empty($_REQUEST)) ? "traitement" : "agent";
        $beanRegistre->save();

    
        // relation a supprimer
        $listeRelation = array();
        $listeRelation['ops_personne_morale_individu'] = $bean->get_linked_beans('ops_individu_ops_personne_morale_individu','OPS_personne_morale_individu');
        $listeRelation['ops_historique_connexion'] = $bean->get_linked_beans('ops_historique_connexion_ops_individu','OPS_historique_connexion');
        $listeRelation['ops_domiciliation']= $bean->get_linked_beans('ops_individu_ops_domiciliation','OPS_domiciliation');
        $listeRelation['documents'] = $bean->get_linked_beans('ops_individu_documents','Documents');
        $listeRelation['ops_appairage'] = $bean->get_linked_beans('ops_individu_ops_appairage','OPS_appairage');

        // suppression des relations
        foreach (array_keys($listeRelation) as $i => $relationship) {
            // Suppression des relations entre OPS_individu et OPS_{$relationship}
            foreach ($listeRelation[$relationship] as $relation) {
                $relation->mark_deleted($relation->id);
            }
        }


        // dossiers a modifier pour integrer le demandeur ou le beneficaire en anonyme
        $dossiersDemandeur = $bean->get_linked_beans('ops_individu_ops_dossier','OPS_dossier');
        $dossiersBeneficiaire = OPS_dossier::getDossiersParBeneficiaireId($bean->id);




        $idAnonyme = OPS_individu::getIdAnonyme();
        if(!$idAnonyme) return;

        // anonymisation des dossiers ou l'individu supprimé est beneficiaire
        foreach($dossiersBeneficiaire as $dossier){
            $dossier->beneficiaire_id = $idAnonyme;
            $dossier->save();
        }

        // anonymisation des dossiers ou l'individu supprimé est demandeur
        foreach($dossiersDemandeur as $dossier){
            $dossier->ops_individu_id = $idAnonyme;
            $dossier->save();
        }


    }
  
    function set_civilite($bean, $event, $arguments = null) 
    {
        if ($event != 'process_record')
        {
            return;
        }

        global $app_list_strings;

        if($bean->type_individu == 'enfant')
        {
            $obj_individu = BeanFactory::getBean('OPS_individu', $bean->id);
            $bean->salutation = $app_list_strings['ops_sexe_list'][$obj_individu->sexe];
        }
    }

}

?>
