var justifId;

$(document).ready(function () {

	if ($('#modal-justificatif').parent().parent().attr('class') === 'subnav') {
		$('#modal-justificatif').insertBefore($('#modal-justificatif').parent().parent());
	}

	$("#notifier_responsable").click(function () {
		$('#titre_modal_justificatif').text('Notifier le profil');
		$('#modal-justificatif-error').text('');
		$('#modal-justificatif-body').empty();
		$('#annuler_modal').text('Annuler');
		$('#envoyer_mail').show();
		$('#save_statut').hide();
		$('#supprimer_justificatif').hide();
		$('#modal-justificatif-body').append(modalMailBody());
		$('#modal-justificatif').modal();
	});

	$("#notifier_demandeur").click(function () {
		$('#titre_modal_justificatif').text('Notifier le demandeur');
		$('#modal-justificatif-error').text('');
		$('#modal-justificatif-body').empty();
		$('#annuler_modal').text('Annuler');
		$('#envoyer_mail').show();
		$('#save_statut').hide();
		$('#supprimer_justificatif').hide();
		$('#modal-justificatif-body').append(modalMailBody());
		$('#modal-justificatif').modal();
	});
});

function modifStatut(id_justificatif, statut) {
	if (id_justificatif) {
		justifId = id_justificatif;

		if($('#' + justifId + '_justificatif_infos').length > 0) {
			var infos_justif = JSON.parse(decodeURIComponent(escape(atob($('#' + justifId + '_justificatif_infos').val()))));
		}

		$('#statut_' + justifId).parent().next().text();
		$('#titre_modal_justificatif').text('Modifier');
		$('#modal-justificatif-error').text('');
		$('#modal-justificatif-body').empty();
		$('#annuler_modal').text('Fermer');
		$('#envoyer_mail').hide();
		$('#supprimer_justificatif').hide();
		$('#save_statut').show();
		const row = $('#statut_' + justifId).closest('tr');
		$('#modal-justificatif-body').append(this.modalStatutBody(row.find('td input[type="checkbox"]').is(':checked'), row.find('td:nth-child(8)').text()));
		$('#modal-justificatif-body').append(`<input id="justificatif_statut_id" name="justificatif_statut_id" type="hidden" value="${justifId}">`);
		if($('#' + justifId + '_justificatif_infos').length > 0) {
			$('#select_type_partenaire_justificatif').val(infos_justif.type_partenaire);
		}
		$('#select_statut_justificatif').val(statut);
		$('#modal-justificatif').modal();

		var visible_partenaire = $('#modal-justificatif-body').find('input[name="visible_partenaire"]');

		if(visible_partenaire.length > 0) {
			showHideTypePartenaireModal(visible_partenaire[0]);
		}
	}
}

function supprimerJustificatif(id_justificatif) {
	if (id_justificatif) {
		$('#statut_' + id_justificatif).parent().next().text();
		$('#titre_modal_justificatif').text('Supprimer le justificatif');
		$('#modal-justificatif-error').text('');
		$('#modal-justificatif-body').empty();
		$('#annuler_modal').text('Annuler');
		$('#envoyer_mail').hide();
		$('#save_statut').hide();
		$('#supprimer_justificatif').show();
		$('#modal-justificatif-body').append(this.modalSupprimerJustificatifBody());
		$('#modal-justificatif-body').append('<input id="justificatif_statut_id" name="justificatif_statut_id" type="hidden" value="' + id_justificatif + '">');
		$('#modal-justificatif').modal();
	}
}

function save_statut() {
	$('#modal-justificatif-error').text('');

	var array_champs = {};
	// Par sécurité, on vérifie que les champs font partie de #modal-justificatif
	array_champs['statut_id'] = $('#justificatif_statut_id').val();
	array_champs['statut_name'] = $('#select_statut_justificatif').val();
	array_champs['obligatoire'] = ($('#obligatoire').is(':checked')) ? 1 : 0;
	array_champs['visible_internet'] = ($('#modal-justificatif #visible_internet').length > 0 && $('#modal-justificatif #visible_internet').is(':checked')) ? 1 : 0;
	array_champs['visible_partenaire'] = ($('#modal-justificatif #visible_partenaire').length > 0 && $('#modal-justificatif #visible_partenaire').is(':checked')) ? 1 : 0;
	array_champs['type_partenaire'] = $('#modal-justificatif #select_type_partenaire_justificatif').length > 0 ? $('#modal-justificatif #select_type_partenaire_justificatif').val() : '';
	array_champs['description'] = $('#commentaire').val();
	$.ajax({
		type: "POST",
		url: 'index.php?module=OPS_justificatif&action=modifier_statut',
		dataType: 'json',
		data: {
			array_champs: array_champs
		}
	})
		.done(function (data) {
			if (typeof (data) != "undefined") {
				var span = $('#statut_' + data.statut_id);

				if (data.obligatoire == 1) {
					span.closest('tr').find('td input[type="checkbox"]').attr('checked', true);
				}
				else {
					span.closest('tr').find('td input[type="checkbox"]').attr('checked', false);
				}

				span.parent().next().text(decodeURIComponent(escape(atob(data.description))));
				span.text(data.statut_name);
				span.css("background-color", data.statut_color);
				$('#modal-justificatif-error').text('Le statut a bien été mis à jour');
				$('#modal-justificatif').modal('toggle');
				showSubPanel('ops_personne_morale_ops_justificatif', null, true)
				showSubPanel('ops_dossier_ops_justificatif', null, true)
			} else {
				$('#modal-justificatif-error').text('Une erreur est survenue lors la mise a jour du statut');
			}
		})
		.fail(function (data) {
			$('#modal-justificatif-error').text('Une erreur est survenue lors la mise a jour du statut');
		});
}

function envoyer_mail() {
	$('#modal-justificatif-error').text('');
	if ($('input[name=radio_mail_justificatif]:checked').val() == '' || $('input[name=radio_mail_justificatif]:checked').val() == undefined) {
		$('#modal-justificatif-error').text('Selectionnez un modèle de mail');
	} else {
		var array_champs = {};
		array_champs['template_id'] = $('input[name=radio_mail_justificatif]:checked').val();
		array_champs['justificatif_id'] = $('#formDetailView input[name="record"]').val();
		array_champs['justificatif_name'] = $('#formDetailView input[name="module"]').val();
		$.ajax({
			type: "POST",
			url: 'index.php?module=OPS_justificatif&action=envoyer_mail',
			dataType: 'json',
			data: {
				array_champs: array_champs
			}
		})
			.done(function (data) {
				if (typeof (data) != "undefined" && data.mail == 'valid') {
					$('#modal-justificatif-error').text('La notification par mail a été envoyée');
					$('#envoyer_mail').hide();
					$('#annuler_modal').text('Fermer');
				}
				else if (data.mail == 'invalid' && data.destinataire == 'invalid') {
					$('#modal-justificatif-error').text(data.message);
				}
				else {
					$('#modal-justificatif-error').text('Une erreur est survenue lors de l\'envoi du mail');
				}
			})
			.fail(function (data) {
				$('#modal-justificatif-error').text('Une erreur est survenue lors de l\'envoi du mail');
			});
	}
}

function supprimer_justificatif() {
	$('#modal-justificatif-error').text('');
	var array_champs = {};
	array_champs['justificatif_id'] = $('#justificatif_statut_id').val();
	array_champs['module_name'] = $('#formDetailView input[name="module"]').val();
	array_champs['module_id'] = $('#formDetailView input[name="record"]').val();
	$.ajax({
		type: "POST",
		url: 'index.php?module=OPS_justificatif&action=supprimer_justificatif',
		dataType: 'json',
		data: {
			array_champs: array_champs
		}
	})
		.done(function (data) {
			if (typeof (data) != "undefined" && data.valid) {
				$('#modal-justificatif-error').text('Le justificatif a bien été supprimé');
				$('#supprimer_justificatif').hide();
				$('#annuler_modal').text('Fermer');
				$('#modal-justificatif').modal('toggle');
				showSubPanel(data.relationship, null, true);
			}
			else {
				$('#modal-justificatif-error').text('Une erreur est survenue lors de la suppression');
			}
		})
		.fail(function (data) {
			$('#modal-justificatif-error').text('Une erreur est survenue lors de la suppression');
		});
}

function modalStatutBody(obligatoire, description) {
	if($('#' + justifId + '_justificatif_infos').length > 0) {
		var infos_justif = JSON.parse(decodeURIComponent(escape(atob($('#' + justifId + '_justificatif_infos').val()))));
	}

	var statut = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
	statut += '<div class="col-xs-12 col-sm-4 label label_justificatif">Statut:</div>';
	statut += '<div class="col-xs-12 col-sm-8 edit-view-field " type="enum" field="statut">';
	statut += decodeURIComponent(escape(atob($('#justificatif_statut').val())));
	statut += '</div></div><br>';

	let checked = '';
	if (
		(infos_justif !== undefined && infos_justif.obligatoire !== undefined && infos_justif.obligatoire == true) 
		|| (obligatoire !== undefined && obligatoire == true)
	) {
		checked = 'checked="checked"';
	}

	let input_obligatoire = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
	input_obligatoire += '<div class="col-xs-12 col-sm-4 label label_justificatif">Obligatoire:</div>';
	input_obligatoire += '<div class="col-xs-12 col-sm-8 edit-view-field " type="bool" field="obligatoire">';
	input_obligatoire += '<input type="checkbox" id="obligatoire" name="obligatoire" value="1" ' + checked + '>';
	input_obligatoire += '</div></div><br>';

	let checked_internet = '';
	let input_visible_internet = '';
	let checked_partenaire = '';
	let input_visible_partenaire = '';
	let select_type_partenaire = '';
	if($('#' + justifId + '_justificatif_infos').length > 0) {
		checked_internet = '';
		if (infos_justif.visible_internet !== undefined && infos_justif.visible_internet == true) {
			checked_internet = 'checked="checked"';
		}
		input_visible_internet = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
		input_visible_internet += '<div class="col-xs-12 col-sm-4 label label_justificatif">Visible internet:</div>';
		input_visible_internet += '<div class="col-xs-12 col-sm-8 edit-view-field " type="bool" field="visible_internet">';
		input_visible_internet += '<input type="checkbox" id="visible_internet" name="visible_internet" ' + checked_internet + '>';
		input_visible_internet += '</div></div><br>';

		checked_partenaire = '';
		if (infos_justif.visible_partenaire !== undefined && infos_justif.visible_partenaire == true) {
			checked_partenaire = 'checked="checked"';
		}
		input_visible_partenaire = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
		input_visible_partenaire += '<div class="col-xs-12 col-sm-4 label label_justificatif">Visible partenaire:</div>';
		input_visible_partenaire += '<div class="col-xs-12 col-sm-8 edit-view-field " type="bool" field="visible_partenaire">';
		input_visible_partenaire += '<input type="checkbox" id="visible_partenaire" name="visible_partenaire" ' + checked_partenaire + ' onclick="showHideTypePartenaireModal(this)"/>';
		input_visible_partenaire += '</div></div><br>';

		select_type_partenaire = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
		select_type_partenaire += '<div class="col-xs-12 col-sm-4 label label_justificatif">Type de partenaire:</div>';
		select_type_partenaire += '<div class="col-xs-12 col-sm-8 edit-view-field " type="enum" field="statut">';
		select_type_partenaire += decodeURIComponent(escape(atob($('#' + justifId + '_justificatif_type_partenaire').val())));
		select_type_partenaire += '</div></div><br>';
	}

	var commentaire = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
	commentaire += '<div class="col-xs-12 col-sm-4 label label_justificatif">Commentaire:</div>';
	commentaire += '<div class="col-xs-12 col-sm-8 edit-view-field " type="text" field="statut">';
	commentaire += '<textarea type="text" id="commentaire" name="commentaire">' + description + '</textarea>';
	commentaire += '</div></div><br>';


	return statut + input_obligatoire + input_visible_internet + input_visible_partenaire + select_type_partenaire + commentaire;
}

function showHideTypePartenaireModal(checkbox) {
	var select_type_partenaire = document.getElementById('select_type_partenaire_justificatif');

	if (checkbox.checked) {
		select_type_partenaire.parentElement.parentElement.style.display = 'block';
	} else {
		select_type_partenaire.parentElement.parentElement.style.display = 'none';
	}

}

function modalMailBody() {
	var mail = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
	mail += '<div class="col-xs-12 col-sm-12 label" style="margin-bottom: 10px;">Voulez-vous notifier maintenant l\'usager pour les justificatifs ?</div>';
	mail += '<div class="col-xs-12 col-sm-4 label">Modèle de mail:</div>';
	mail += '<div class="col-xs-12 col-sm-8 edit-view-field " type="enum" field="statut">';
	mail += decodeURIComponent(escape(atob($('#justificatif_mail').val())));
	mail += '</div></div><br>';
	return mail;
}

function modalSupprimerJustificatifBody() {
	var mail = '<div class="col-xs-12 col-sm-12 edit-view-row-item">';
	mail += '<div class="col-xs-12 col-sm-12 label" style="margin-bottom: 10px;">Voulez-vous réellement supprimer ce justificatif ?</div>';
	mail += '</div></div>';
	return mail;
}