console.log('Test');
let importer = $('#actionMenuSidebar').find('a[href*="action=importer"]');
$(importer).attr('href', '#');

$(importer).on('click', function () {
    console.log('Click');
    showModal();
});

function showModal() {
    let modale = '<div id="modal_import" class="modal" tabindex="-1" role="dialog">';
    modale +=     '<div class="modal-dialog" style="max-width: 800px;">';
    modale +=         '<div class="modal-content">';
    modale +=             '<div class="modal-header">';
    modale +=                 '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
    modale +=                 '<h4 class="modal-title" id="titre_modal_assignation">Importer les jours fériés</h4>';
    modale +=                 '</button>';
    modale +=             '</div>';
    modale +=             '<div id="modal-body" class="modal-body" style="min-height: 78px;">';
    modale +=             '<div>';
    modale +=             '<label for="current" style="margin-right: 10px;">Année courante</label>';
    modale +=             '<input type="radio" name="annee" id="current" value="current">';
    modale +=             '</div>';
    modale +=             '<br >';
    modale +=             '<div>';
    modale +=             '<label for="next" style="margin-right: 10px;">Année suivante</label>';
    modale +=             '<input type="radio" name="annee" id="next" value="next">';
    modale +=             '</div>';
    modale +=             '<div id="modal_importer_loading" data-selected="false" data-name="loading_importer"></div>';
    modale +=             '</div>';
    modale +=             '<div class="modal-footer">';
    modale +=                 '<button id="btn_importer" type="button" class="button button-modal" id="importer_modal" onClick="importerJoursFerie()">Importer maintenant</button>';
    modale +=                 '<button id="btn_terminer" type="button" class="button button-modal" data-dismiss="modal" id="annuler_modal">Fermer</button>';
    modale +=             '</div>';
    modale +=         '</div>';
    modale +=     '</div>';
    modale += '</div>';

    $('#modal_import').remove();
    $('#pagecontent').append(modale);
    $('#modal_import').modal();
}

function importerJoursFerie() {

    $('.msg').remove();

    
    let year = $('input[name="annee"]:checked');
    
    if($(year).length > 0) {
        year = $(year).val();
        
        LoadingImporter.addSpinner($('#modal_importer_loading'));
        $('input[name="annee"]').attr('disabled', 'disabled');
        $('.modal-footer button').attr('disabled', 'disabled');
        
        $.ajax({
            type: "POST",
            url: 'index.php?module=OPS_periode&action=importerJoursFerie',
            dataType: 'json',
            data: {
                year: year
            }
        }).done(function (data) {
            console.log(data)
            $('input[name="annee"]').prop('disabled', '');
            $('.modal-footer button').prop('disabled', '');
            LoadingImporter.removeSpinner($('#modal_importer_loading'));
            $('#modal-body').append('<span style="color:green;" class="msg">Les jours fériés ont été importés</span>');
        }).fail(function (data) {
            $('input[name="annee"]').prop('disabled', '');
            $('.modal-footer button').prop('disabled', '');
            LoadingImporter.removeSpinner($('#modal_importer_loading'));
            console.log('Une erreur s\'est produite ! : ' + data);
        })
    } else {
        $('#modal-body').append('<span style="color:red;" class="msg">Veuillez sélectionner une année</span>');
    }
}

var LoadingImporter = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};