$(document).ready(function() 
{
    // We initialize the modal
    ModalDelete.initialisation( Delete.modal_id );

    if ( ModalDelete.loaded ) 
    {
        // We initialize the onclick function [ Action par lot ]
        Delete.setClickActionLotBtn();
    }

    $('#form_delete_btn_fermer').click(function()
    {
        $.f_modal.close();
    });

    $('#btn_terminer_delete').click(function()
    {
        $.f_modal.close();
        window.location.assign("index.php?module=OPS_personne_morale&action=index&return_module=OPS_personne_morale&return_action=DetailView");
    });
});

// We create an instance of the OdeModal object
const ModalDelete = Object.create(OdeModal);

if( typeof(Delete) == 'undefined' ){ var Delete = { modal_id: 'ode_modal_delete', loaded: false }; }

// We initialize the onclick function
Delete.setClickActionLotBtn = function()
{
    $('[role="ode-modal-delete-btn"]').off().on('click', function () {
        ModalDelete.initialisation( Delete.modal_id );
        ModalDelete.open();
        Delete.initialisation();
    });
}

// The initialization function is the first function triggered when the modal is opened.
Delete.initialisation = function() { 

    ModalDelete.route('loading');

    var loading = function(){
        ModalDelete.loading.setMessage('Récupération');
    };

    var callBack = function() {

        if(typeof this.result.erreur === "string") {
            ModalDelete.route('erreur',this.result.erreur);
            return; 
        }

        var message = `Récupération des données`;

        ModalDelete.loading.setMessage(message);
        ModalDelete.loading.setTotal(this.result.length);

        for(var i = 0; i < this.result.length; i++){
            ModalDelete.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalDelete.route('delete');
            ModalDelete.loading.reset();
            retourFunctionDelete.initFormulaireDelete(this);
        }, 1000);
    };

    var data = Delete.getData();

    var query = OdeQueries.getAjaxActionQuery();

    query.setModule('OPS_personne_morale');
    query.setAction("checkDossier");
    query.setPostData( data );
    OdeAjax.getByAction( query, loading, callBack );
}

Delete.getData = function() {
    let params_string  = window.location.search;
    search_params = new URLSearchParams( params_string );

    var data = {
        record : search_params.get("record")
    };

    return data;
}

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionDelete = {

    initFormulaireDelete: function(data)
    {
        if(data.result.resultat.cloture){
            $("#delete_message").empty();
            $("#delete_message").append('<input type="checkbox" id="valider_suppression" name="valider_suppression"><label for="valider">'+data.result.resultat.message+'</label>');
            $("#delete_message").css('color', 'black');
            $("#valider_suppression").click(function(){
                if($("#valider_suppression").is(':checked')){
                    $("#form_delete_btn_confirme").show();
                    $("#form_delete_btn_confirme").click(function(){
                        var _form = document.getElementById('formDetailView');
                        _form.return_module.value = 'OPS_personne_morale';
                        _form.return_action.value = 'ListView';
                        _form.action.value = 'Delete';
                        SUGAR.ajaxUI.submitForm(_form);
                    });
                }else{
                    $("#form_delete_btn_confirme").hide();
                    $("#form_delete_btn_confirme").off();
                }
            });
        }else{
            $("#form_delete_btn_confirme").off();
            $("#form_delete_btn_confirme").hide();
            $("#valider_suppression").off();
            $("#delete_message").empty();
            $("#delete_message").text(data.result.resultat.message);
            $("#delete_message").css('color', 'red');
        }
        var dossiersHtml = '';
        Object.keys(data.result.resultat.dossiers).forEach(function(dossierId){
            const dossier = data.result.resultat.dossiers[dossierId];
            var cloture = (dossier.cloture == 1)?'oui':'non';
            dossiersHtml += '<tr>';
            dossiersHtml += '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 25%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">';
            dossiersHtml += '<a href="index.php?module=OPS_dossier&action=DetailView&record='+dossierId+'" target="_blank">'+dossier.num_dossier+'</a>';
            dossiersHtml += '</td>';
            dossiersHtml += '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 25%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">'+dossier.brouillon+'</td>';
            dossiersHtml += '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 25%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">'+dossier.dispositif+'</td>';
            dossiersHtml += '<td style="text-align: left; padding: 10px; padding-left: 15px; width: 25%; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; max-width: 1px;">'+cloture+'</td>';
            dossiersHtml += '</tr>';
        });

        $('#tbody_delete').empty();
        $('#tbody_delete').append(dossiersHtml);
        $("#modal_delete_form").show();
        $("#delete_content").show();
        $("#nb_dossier_delete").text(data.result.resultat.length);
    }

};