<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

use ODE\Surcharge\TraitementViewMetadata;

class OPS_personne_moraleViewEdit extends ViewEdit {
    
    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }
    
    function display()
    {
        global $app_list_strings, $mod_strings;

        // On récupere le type_personne initial 
        $type_personne_initial_id = ( !empty($this->bean->ops_type_personne_id) ) ? $this->bean->ops_type_personne_id : "";

        // On récupere la liste des type_tiers
        $type_tiers = array();
        $typeTiersObject = BeanFactory::getBean("OPS_type_personne");
        $liste_type_tiers = $typeTiersObject->get_full_list("name");
        if ( is_array($liste_type_tiers) && count($liste_type_tiers) > 0 ) {
            foreach ( $liste_type_tiers as $typeTiers ) {
                $type_tiers[$typeTiers->id] = array(
                   'name' => $typeTiers->name,
                );
                $libelle_nom_liste = $app_list_strings['ops_tp_libelle_nom_list'];
                if ( !empty($typeTiers->id) && !empty($typeTiers->libelle_nom) && array_key_exists($typeTiers->libelle_nom, $libelle_nom_liste) ) 
                {
                    $type_tiers_libelle[$typeTiers->id] = $libelle_nom_liste[$typeTiers->libelle_nom];
                } 
                else 
                {
                    $type_tiers_libelle[$typeTiers->id] = $mod_strings['LBL_NAME'];
                }
            }
        }

        // On récupere la liste des forme juridiques
        $forme_juridiques = array();
        if ( is_array($liste_type_tiers) && count($liste_type_tiers) > 0 ) {
            foreach ( $liste_type_tiers as $typeTiers ) {
                $forme_juridique_full = str_replace("^","",$typeTiers->forme_juridique_liste);
                $forme_juridique_array = explode(",",$forme_juridique_full);
                $array_juridique = array();
                $array_juridique[''] = '';
                foreach($forme_juridique_array as $forme_juridique){
                    if(!empty($forme_juridique)) $array_juridique[$forme_juridique] =  $app_list_strings['ops_forme_juridique_list'][$forme_juridique];
                }
                asort($array_juridique);
                $forme_juridiques[$typeTiers->id] = array(
                   'label'              => $typeTiers->name,
                   'forme_juridique'    => $array_juridique
                );
            }
            $array_juridique = array(''=>'')+$app_list_strings['ops_forme_juridique_list'];
            asort($array_juridique);
            $forme_juridiques['all'] = array(
                'label'             => 'all',
                'forme_juridique'   => $array_juridique
             );
        }

        // On récupere la liste des effectifs
        $effectifs = array();
        if ( is_array($liste_type_tiers) && count($liste_type_tiers) > 0 ) {
            foreach ( $liste_type_tiers as $typeTiers ) {
                $effectif_full = str_replace("^","",$typeTiers->effectif_liste);
                $effectif_array = explode(",",$effectif_full);
                $array_effectif = array();
                //$array_effectif[''] = '';
                foreach($effectif_array as $effectif){
                    if(!empty($effectif)) $array_effectif[$effectif] =  $app_list_strings['ops_type_profil_effectif_list'][$effectif];
                }
                //asort($array_effectif);
                $effectifs[$typeTiers->id] = array(
                   'label'    => $typeTiers->name,
                   'effectif' => $array_effectif
                );
            }
            $array_effectif = $app_list_strings['ops_type_profil_effectif_list'];
            //asort($array_effectif);
            $effectifs['all'] = array(
                'label'    => 'all',
                'effectif' => $array_effectif
            );
        }

        // On récupere la liste des natures
        $natures = array();
        if ( is_array($liste_type_tiers) && count($liste_type_tiers) > 0 ) {
            foreach ( $liste_type_tiers as $typeTiers ) {
                $nature_full = str_replace("^","",$typeTiers->nature_liste);
                $nature_array = explode(",",$nature_full);
                $array_nature = array();
                foreach($nature_array as $nature){
                    if(!empty($nature)) $array_nature[$nature] =  $app_list_strings['ops_type_profil_nature_list'][$nature];
                }
                $natures[$typeTiers->id] = array(
                   'label'    => $typeTiers->name,
                   'nature' => $array_nature
                );
            }
            $array_nature = $app_list_strings['ops_type_profil_nature_list'];
            $natures['all'] = array(
                'label'    => 'all',
                'nature' => $array_nature
            );
        }

        // On construit le select type_tiers
        $select_type_personne_initial = '<select id="select_type_personne_initial" onchange="onChangeSelectTypeTiers()" style="width: 50%;margin-right: 5%;">';
        $select_type_personne_initial .= '<option>Sélectionner un type</option>';
        if( is_array($type_tiers) && count($type_tiers) > 0 ){
            foreach ( $type_tiers as $type_tiers_id => $typeTiers ) {
                $select_type_personne_initial .= ( $type_tiers_id === $type_personne_initial_id ) ? '<option selected="selected" ' : '<option ';
                $select_type_personne_initial .= 'id="' . $type_tiers_id . '" > ' . $typeTiers['name'] . ' </option>';
            }
        }
        $select_type_personne_initial .='</select> ';
        
        $type_personne_initial =  $select_type_personne_initial;
        $type_personne_initial .= '<input type="hidden" name="ops_type_personne_id" id="ops_type_personne_id" value="' . $type_personne_initial_id . '">';
        $type_personne_initial .= '<input type="hidden" id="personne_morale_type_tiers" value="' . base64_encode ( json_encode( $type_tiers ) ). '">';
        $type_personne_initial .= '<input type="hidden" id="personne_morale_type_tiers_libelle" value="' . base64_encode ( json_encode( $type_tiers_libelle ) ). '">';
        $this->ss->assign("type_personne_initial", $type_personne_initial);


        //On construit le select forme_juridique
        $obj_typeTiers = ( !empty($type_personne_initial_id) ) ? BeanFactory::getBean('OPS_type_personne', $type_personne_initial_id) : false;
        if(!empty($obj_typeTiers->forme_juridique_liste)){
            $forme_juridique_full = str_replace("^","",$obj_typeTiers->forme_juridique_liste);
            $forme_juridique_array = explode(",",$forme_juridique_full);
            asort($forme_juridique_array);
            $select_forme_juridique = '<select name="forme_juridique" id="forme_juridique" title="">';
            $select_forme_juridique .= '<option label="" value=""></option>';
            foreach($forme_juridique_array as $forme_juridique){
                $select_forme_juridique .= ( $this->bean->forme_juridique === $forme_juridique ) ? '<option selected="selected" ' : '<option ';
                $select_forme_juridique .= 'label="'.$app_list_strings['ops_forme_juridique_list'][$forme_juridique].'" value="'.$forme_juridique.'"></option>';
            }
            $select_forme_juridique .= '</select>';
        }else{
            $select_forme_juridique = '<select name="forme_juridique" id="forme_juridique" title="">';
            $select_forme_juridique .= '<option label="" value=""></option>';
            foreach($app_list_strings['ops_forme_juridique_list'] as $value => $label){
                $select_forme_juridique .= ( $this->bean->forme_juridique === $value ) ? '<option selected="selected" ' : '<option ';
                $select_forme_juridique .='label="'.$label.'" value="'.$value.'"></option>';
            }
            $select_forme_juridique .= '</select>';
        }        
        $select_forme_juridique .= '<input type="hidden" id="personne_morale_forme_juridique" value="' . base64_encode ( json_encode( $forme_juridiques ) ). '">';
        $this->ss->assign("select_forme_juridique", $select_forme_juridique);

        //On construit le select effectif
        $obj_typeTiers = ( !empty($type_personne_initial_id) ) ? BeanFactory::getBean('OPS_type_personne', $type_personne_initial_id) : false;
        if(!empty($obj_typeTiers->effectif_liste)){
            $effectif_full = str_replace("^","",$obj_typeTiers->effectif_liste);
            $effectif_array = explode(",",$effectif_full);
            asort($effectif_array);
            $select_effectif = '<select name="effectif" id="effectif" title="">';
            $select_effectif .= '<option label="" value=""></option>';
            foreach($effectif_array as $effectif){
                $select_effectif .= ( $this->bean->effectif === $effectif ) ? '<option selected="selected" ' : '<option ';
                $select_effectif .= 'label="'.$app_list_strings['ops_type_profil_effectif_list'][$effectif].'" value="'.$effectif.'"></option>';
            }
            $select_effectif .= '</select>';
        }else{
            $select_effectif = '<select name="effectif" id="effectif" title="">';
            $select_effectif .= '<option label="" value=""></option>';
            foreach($app_list_strings['ops_type_profil_effectif_list'] as $value => $label){
                $select_effectif .= ( $this->bean->effectif === $value ) ? '<option selected="selected" ' : '<option ';
                $select_effectif .='label="'.$label.'" value="'.$value.'"></option>';
            }
            $select_effectif .= '</select>';
        }        
        $select_effectif .= '<input type="hidden" id="personne_morale_effectif" value="' . base64_encode ( json_encode( $effectifs ) ). '">';
        $this->ss->assign("select_effectif", $select_effectif);

        //On construit le select nature
        $obj_typeTiers = ( !empty($type_personne_initial_id) ) ? BeanFactory::getBean('OPS_type_personne', $type_personne_initial_id) : false;
        if(!empty($obj_typeTiers->nature_liste)){
            $nature_full = str_replace("^","",$obj_typeTiers->nature_liste);
            $nature_array = explode(",",$nature_full);
            asort($nature_array);
            $select_nature = '<select name="nature" id="nature" title="">';
            $select_nature .= '<option label="" value=""></option>';
            foreach($nature_array as $nature){
                $select_nature .= ( $this->bean->nature === $nature ) ? '<option selected="selected" ' : '<option ';
                $select_nature .= 'label="'.$app_list_strings['ops_type_profil_nature_list'][$nature].'" value="'.$nature.'"></option>';
            }
            $select_nature .= '</select>';
        }else{
            $select_nature = '<select name="nature" id="nature" title="">';
            $select_nature .= '<option label="" value=""></option>';
            foreach($app_list_strings['ops_type_profil_nature_list'] as $value => $label){
                $select_nature .= ( $this->bean->nature === $value ) ? '<option selected="selected" ' : '<option ';
                $select_nature .='label="'.$label.'" value="'.$value.'"></option>';
            }
            $select_nature .= '</select>';
        }        
        $select_nature .= '<input type="hidden" id="personne_morale_nature" value="' . base64_encode ( json_encode( $natures ) ). '">';
        $this->ss->assign("select_nature", $select_nature);

        //Champs obligatoires en fonction du type tiers
        $obligatoires = array();
        if ( is_array($liste_type_tiers) && count($liste_type_tiers) > 0 ) {
            foreach ( $liste_type_tiers as $typeTiers ) {
                $obligatoires[$typeTiers->id] = array(
                   'label'                 => $typeTiers->name,
                   'numero_rna'            => $typeTiers->numero_rna,
                   'siret'                 => $typeTiers->siret,
                   'num_tahiti'            => $typeTiers->num_tahiti,
                   'numero_rne'            => $typeTiers->numero_rne,
                   'date_declaration'      => $typeTiers->date_declaration,
                   'code_ape'              => $typeTiers->code_ape,
                   'objet_social'          => $typeTiers->objet_social,
                   'sigle'                 => $typeTiers->sigle,
                   'website'               => $typeTiers->website,
                   'forme_juridique'       => $typeTiers->forme_juridique,
                   'nature'                => $typeTiers->nature,
                   'effectif'              => $typeTiers->effectif,
                   'secteur_activite'      => $typeTiers->secteur_activite,
                   'adresse_date_validite' => $typeTiers->adresse_date_validite,
                   'adresse_hors_commune'  => $typeTiers->adresse_hors_commune,
                   'situation_handicap'    => $typeTiers->situation_handicap,
                   'display_relation'      => $typeTiers->display_relation,
                   'display_annuaire'      => $typeTiers->display_annuaire,
                   'display_formule'       => $typeTiers->display_formule,
                   'display_info_fiscales' => $typeTiers->display_info_fiscales,
                );
            }
            $obligatoires['langue'] = array(
                'LBL_NUMERO_RNA'         => $mod_strings['LBL_NUMERO_RNA'],
                'LBL_SIRET'              => $mod_strings['LBL_SIRET'],
                'LBL_NUMERO_RNE'         => $mod_strings['LBL_NUMERO_RNE'],
                'LBL_CODE_APE'           => $mod_strings['LBL_CODE_APE'],
                'LBL_NUM_TAHITI'         => $mod_strings['LBL_NUM_TAHITI'],
                'LBL_DATE_DECLARATION'   => $mod_strings['LBL_DATE_DECLARATION'],
                'LBL_OBJET_SOCIAL'       => $mod_strings['LBL_OBJET_SOCIAL'],
                'LBL_SIGLE'              => $mod_strings['LBL_SIGLE'],
                'LBL_WEBSITE'            => $mod_strings['LBL_WEBSITE'],
                'LBL_FORME_JURIDIQUE'    => $mod_strings['LBL_FORME_JURIDIQUE'],
                'LBL_EFFECTIF'           => $mod_strings['LBL_EFFECTIF'],
                'LBL_SECTEUR_ACTIVITE'   => $mod_strings['LBL_SECTEUR_ACTIVITE'],
                'LBL_SITUATION_HANDICAP' => $mod_strings['LBL_SITUATION_HANDICAP'],
                'LBL_NATURE'             => $mod_strings['LBL_NATURE'],
                'LBL_ADRESSE_DATE_VALIDITE' => $mod_strings['LBL_ADRESSE_DATE_VALIDITE'],
                'LBL_ADRESSE_HORS_COMMUNE'  => $mod_strings['LBL_ADRESSE_HORS_COMMUNE'],
            );
        }

        $input_code_ape = '<input type="text" name="code_ape" id="code_ape" size="30" maxlength="255" data-mask="9999a"  value="'.$this->bean->code_ape.'" title="">';
        $input_code_ape .= '<input type="hidden" id="personne_morale_obligatoire" value="' . base64_encode ( json_encode( $obligatoires ) ). '">';
        $this->ss->assign("input_code_ape", $input_code_ape);

        $cheminSurcharge = "custom/modules/OPS_personne_morale/Surcharge/views/";
        $fichiers = TraitementViewMetadata::checkDir('view.edit',$cheminSurcharge);

        if(!empty($fichiers) && is_array($fichiers)){
            foreach ($fichiers as $fichier) {
                include("$cheminSurcharge$fichier");
                if(!empty($surchargeClass)){
                    new $surchargeClass($this,$smarty,$contenue);
                }
            }
        }

        parent::display();
        $this->displayTMCE();
    }

    function displayTMCE()
    {
        require_once ("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $js = <<<JS
        <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            selector: '#accroche,#description_annuaire,#activites,#tarifs,#public_beneficiaire',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
        });
        </script>

JS;
        echo $js;

    }
}
