<?php

class hook_personne_morale_individu {

    //
    // Fonction d'initialisation de l'individu pour la RGPD
    //
    function init_individu(&$bean, $event, $arguments = null) 
    {        
        global $sugar_config;

        if($event != 'before_save'){
          return;
        }


        if( $bean->statut_clef == "revoque" ){
            $bean->acces_usager = false;
        }

        if(empty($bean->fetched_row['id']) && !empty($sugar_config['opensocle']['profil_delai_validite_clef'])){
            $dateExpiration = date('Y-m-d', strtotime(date('Y-m-d') . ' + ' . $sugar_config['opensocle']['profil_delai_validite_clef'] . ' days'));
            $bean->date_expiration = $dateExpiration;
        }

        if($bean->fetched_row['statut_clef'] != 'perime' && $bean->statut_clef == 'perime' && empty($bean->date_expiration)){
            $bean->date_expiration = date("Y-m-d");
        }

        if($bean->fetched_row['statut_clef'] != 'revoque' && $bean->statut_clef == 'revoque' && empty($bean->date_revocation)){
            $bean->date_revocation = date("Y-m-d");
        }
        
        if ( ( !empty($bean->ops_individu_ops_personne_morale_individu_name) || !empty($bean->ops_individu_id) ) && empty( $bean->individu_rattache )   ) {

            if( isset($bean->ops_individu_id) && !empty( $bean->ops_individu_id ) && !is_array($bean->ops_individu_id) && !is_object($bean->ops_individu_id) ){
                $obj_individu = BeanFactory::getBean('OPS_individu', $bean->ops_individu_id );
                $name = $obj_individu->full_name;
            }
            else{
                $name = $bean->ops_individu_ops_personne_morale_individu_name; 
            }
            
            $bean->individu_rattache = $name; 

        }
    }

    function delete_relation_calendrier_garde(&$bean, $event, $arguments = null) 
    {        
        if($event != 'before_delete')
        {
          return;
        }
        
        $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
        $bean->load_relationship('ops_personne_morale_individu_2_ops_calendrier_garde');

        $calendarList = $bean->ops_personne_morale_individu_ops_calendrier_garde->get();
        foreach ($calendarList as $calendarId) 
        {
            $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
            if(!empty($calendarBean->id))
            {
                $bean->ops_personne_morale_individu_ops_calendrier_garde->deleted($bean->id, $calendarBean);
            }
        }

        $calendarList = $bean->ops_personne_morale_individu_2_ops_calendrier_garde->get();
        foreach ($calendarList as $calendarId) 
        {
            $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
            if(!empty($calendarBean->id))
            {
                $bean->ops_personne_morale_individu_2_ops_calendrier_garde->delete($bean->id, $calendarBean);
            }
        }
    }

    function change_relation_calendrier_garde(&$bean, $event, $arguments = null) 
    {        
        if($event != 'before_save')
        {
          return;
        }

        if( !in_array($bean->mode_garde, ['alternee', 'partagee']) )
        {
            $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
            $bean->load_relationship('ops_personne_morale_individu_2_ops_calendrier_garde');

            $calendarList = $bean->ops_personne_morale_individu_ops_calendrier_garde->get();
            foreach ($calendarList as $calendarId) 
            {
                $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
                if(!empty($calendarBean->id))
                {
                    $bean->ops_personne_morale_individu_ops_calendrier_garde->delete($bean->id, $calendarBean);
                }
            }

            $calendarList = $bean->ops_personne_morale_individu_2_ops_calendrier_garde->get();
            foreach ($calendarList as $calendarId) 
            {
                $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
                if(!empty($calendarBean->id))
                {
                    $bean->ops_personne_morale_individu_2_ops_calendrier_garde->delete($bean->id, $calendarBean);
                }
            }
        }
    }
}

?>