<?PHP

use BeanFactory;
use TimeDate;

class OPS_plage_ouverture extends Basic
{
	public $new_schema = true;
	public $module_dir = 'OPS_plage_ouverture';
	public $object_name = 'OPS_plage_ouverture';
	public $table_name = 'ops_plage_ouverture';
	public $importable = false;
	public $disable_row_level_security = true; // to ensure that modules created and deployed under CE will continue to function under team security if the instance is upgraded to PRO
	public $id;
	public $name;
	public $date_entered;
	public $date_modified;
	public $modified_user_id;
	public $modified_by_name;
	public $created_by;
	public $created_by_name;
	public $description;
	public $deleted;
	public $created_by_link;
	public $modified_user_link;
	public $assigned_user_id;
	public $assigned_user_name;
	public $assigned_user_link;
	public $jours;
	public $a_partir_de;
	public $jusqu_a;
	public $nb_disponible;

	public function __construct()
	{
		parent::__construct();
	}

	public function bean_implements($interface)
	{
		switch ($interface) {
			case 'ACL':
				return true;
		}
		return false;
	}


	/**
	 * Récupération des creneaux disponibles pour chaque plages d'ouvertures d'un agenda
	 * @param mixed $agenda_id
	 * @param mixed $date_deb ( Format : Y-m-d )
	 * @param mixed $date_fin ( Format : Y-m-d )
	 * @param mixed $duree ( en minutes )
	 * @param mixed $canal internet/gru
	 * @param mixed $lieu_id
	 * @return array
	 */
	public function liste_plage_ouverture($agenda_id, $date_debut = "", $date_fin = "", $duree = "", $canal = "", $lieu_id = "")
	{

		global $beanFiles, $current_user, $db;
		require_once($beanFiles["OPS_agendas"]);
		require_once($beanFiles["OPS_exception"]);
		require_once($beanFiles["OPS_plage_ouverture"]);

		// Récupération de l'objet de l'agenda passé en paramètre
		$obj_agenda = BeanFactory::getBean("OPS_agendas", $agenda_id);

		$tab_plages = $obj_agenda->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_plage_ouverture");

		if (!empty($tab_plages) && count($tab_plages) > 0) {

			// Gestion des dates
			// Récupération de la préférence de l'utilisateur pour l'affichage
			$timzone_user     = $current_user->getPreference('timezone');
			$format           = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');

			$current_user->getPreference('datef');
			date_default_timezone_set($timzone_user);
			// Création de la date du jour au format Y-m-d et timestamp pour découper
			$timedate            = new TimeDate($current_user);
			$date_now            = $timedate->getNow(true);
			$date_now->format("Y-m-d h:s"); /// GMT + 1
			$date_jour_timestamp = $date_now->getTimestamp(); /// UTC-0


			// Mise au timestamp de la date début et date de fin
			$date_format = new TimeDate();

			// Date début
			$date_debut_gmt       = $date_format->fromString($date_debut);
			$date_debut_gmt->format("Y-m-d H:s"); /// GMT + 1
			$date_debut_timestamp = $date_debut_gmt->getTimestamp(); // UTC - 0

			// Date fin
			$date_fin_gmt       = $date_format->fromString($date_fin);

			$date_fin_gmt->format("Y-m-d H:s"); /// GMT + 1
			$date_fin_timestamp = $date_fin_gmt->getTimestamp(); // UTC - 0
			$var = 0;

			// Vérification que la date début soit plus grande que la date du jour pour ne pas récupérer les créneaux passées
			if ($date_jour_timestamp > $date_debut_timestamp) {
				$dateDebut = $date_jour_timestamp;
			} else {
				$dateDebut = $date_debut_timestamp;
			}

			// Pour chaque Plage Ouverture dans l'agenda
			foreach ($tab_plages as $plage) {

				if ((isset($plage->ops_lieux_id) && $plage->ops_lieux_id == $lieu_id) || empty($lieu_id)) {

					$heure_debut = $plage->a_partir_de;
					$heure_fin   = $plage->jusqu_a;


					// Pour i commencant à la date de début de la plage d'ouverture et allant jusqu'à la date de fin de la plage d'ouverture
					for ($i = $dateDebut; $i <= $date_fin_timestamp; $i += 86400) {

						// Initialisation d'une variable servant à définir les créneaux disponibles par jour (Lundi, Mardi, ...)
						$heure_i = $heure_debut;
						$init_heure_i = $heure_debut; // variable servant de référence pour éviter les boucles infinies lorsqu'une durée dépassé l'intervalle de temps d'une plage 

						// Boucle sur le nombre de créneaux disponibles par jour
						for ($j = 1; strtotime($heure_i) < strtotime($heure_fin); $j++) {

							// Récuperation des disponibilités ( fo / bo )
							if ($canal == "gru") {
								$nb_disponible = $plage->nb_disponible_bo;
							} else {
								$nb_disponible = $plage->nb_disponible;
							}

							// Conversion en timestamp
							$time = strtotime($heure_i);

							$heure_d = explode(":", $heure_i);
							$start   = date_time_set(date_create(date("Y-m-d", $i)), $heure_d[0], $heure_d[1]);

							$heure_i = date("H:i", strtotime('+' . $duree + $obj_agenda->espacement . 'minutes', $time));
							$heure_f = explode(":", $heure_i);
							$end     = date_time_set(date_create(date("Y-m-d", $i)), $heure_f[0], $heure_f[1]);

							//  $GLOBALS['log']->fatal('---------------------- start  ' .print_r($start , true) );
							$end->setTimezone(new DateTimeZone('UTC'));
							$start->setTimezone(new DateTimeZone('UTC'));

							if ($init_heure_i > $heure_i) { // si l'heure suivante est plus petite que celle de départ, on sort: Ex: Motif
								break;
							}

							// Préparation de la recherche d'exception sur le créneaux
							$where = " date_exception_deb <= '" . $start->format('Y-m-d H:i') . "' AND date_exception_fin" . " >= '" . $end->format('Y-m-d H:i') . "'";
							$exceptions = $obj_agenda->get_linked_beans("ops_agendas_ops_exception", "OPS_exception", array(), 0, -1, 0, $where);

							$end->setTimezone(new DateTimeZone($timzone_user));
							$start->setTimezone(new DateTimeZone($timzone_user));

							if (count($exceptions) > 0) {

								foreach ($exceptions as $exception) {

									if (empty($exception->ops_lieux_id) || $exception->ops_lieux_id == $plage->ops_lieux_id) {
										if ($canal == "gru" && $nb_disponible > $exception->nb_disponible_bo) {
											$nb_disponible = $exception->nb_disponible_bo;
										} elseif ($nb_disponible > $exception->nb_disponible) {
											$nb_disponible = $exception->nb_disponible;
										}
									}
								}
							}

							if ($nb_disponible > 0) {


								$lieu_final = "";
								$lieu_id_final = "";

								if (!empty($plage->ops_lieux_id)) {

									$cur_lieu = BeanFactory::getBean('OPS_lieux', $plage->ops_lieux_id);
									$lieu_final = $cur_lieu->name;
									$lieu_id_final = $cur_lieu->id;
								}

								$creneau = array(
									'title' => $nb_disponible,
									'date_deb' => $start->format($format),
									'start' => $start->format('Y-m-d\TH:i:s'),
									'date_fin' => $end->format($format),
									'end' => $end->format('Y-m-d\TH:i:s'),
									'lieu' => $lieu_final,
									'lieu_id' => $lieu_id_final
								);

								// Switch sur la colonne jours de OPS_PLAGES_OVERTURE pour remplir correctement les jours disponibles
								switch ($plage->jours) {
									case "lundi":
										// Si le jour de la date contenue dans I est Mon (Lundi)
										if (date("D", $i) == "Mon" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "mardi":
										if (date("D", $i) == "Tue" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "mercredi":
										if (date("D", $i) == "Wed" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "jeudi":
										if (date("D", $i) == "Thu" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "vendredi":
										if (date("D", $i) == "Fri" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "samedi":
										if (date("D", $i) == "Sat" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
									case "dimanche":
										if (date("D", $i) == "Sun" && strtotime($heure_fin) >= strtotime($heure_i) && $dateDebut < $start->format('U')) {
											$list_creneaux_dispo[$var] = $creneau;
											$var++;
										}
										break;
								}
							}
						}
					}
				}
			}

			return $list_creneaux_dispo;
		} else {
			return [];
		}
	}


	/*
	 * Création des exceptions générées par la récurrence sur une plage d'ouverture
	 */
	function init_exceptions_recurrence()
	{

		global $timedate, $current_user;

		$agenda = $this->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_agendas");
		$agenda = $agenda[0];

		$date_fin_agenda = null;
		$possibleFormats = [
			"Y-m-d", // Format standard Y-m-d
			$current_user->getPreference('datef'), // Format basé sur la préférence utilisateur
		];
		$timeZone = TimeDate::userTimezone($current_user);

		if (empty($agenda->date_fin) && $agenda->souhait_glissement_fin == 1) {
			$date_fin_agenda = new DateTime('now', new DateTimeZone($timeZone));
			$date_fin_agenda->modify($agenda->jours_glissement_fin . ' days');
			$date_fin_agenda->setTime(22, 0);
			$date_fin_agenda = $date_fin_agenda->format('Y-m-d H:i');
		} else {

			foreach ($possibleFormats as $format) {

				$dateChecker = DateTime::createFromFormat($format, $agenda->date_fin, new DateTimeZone($timeZone));

				if ($dateChecker !== false && $dateChecker->format($format) === $agenda->date_fin) {

					$date_fin_agenda = $dateChecker;
					$date_fin_agenda->setTime(22, 0);
					$date_fin_agenda = $date_fin_agenda->format('Y-m-d H:i');
					break;
				}
			}
		}

		if ($date_fin_agenda === null) {
			$GLOBALS['log']->debug('Impossible de déterminer le format de la date de fin BASE.');
		} else {
			$GLOBALS['log']->debug('date_fin_agenda', print_r($date_fin_agenda, true));
		}

		/* [mois][semaines][jours] */
		$recurrence = explode(" ", $this->recurrence);
		$semaine = $recurrence[1];


		/* $array_jour_semaine['jour_nom']
		 *  $array_jour_semaine['jour_numero_semaine'])
		 */
		$array_jour_semaine = $this->get_jour_semaine($this->jours);
		$array_recurrences = $this->init_tab_recurrences();
		$jour_numeros = $array_recurrences['jours'];


		// On vérifie les mois qui ne sont pas inclus dans la récurrence pour créer les exceptions
		$k = 0;

		foreach ($array_recurrences['annees'] as $key => $tab_recurrence) {

			$dto = new DateTime();
			$semaine_numeros = $tab_recurrence['semaines'];
			$mois_numeros = $tab_recurrence['mois'];

			$date_deb_recurrence = getdate(strtotime($tab_recurrence['date_debut'] . ' 00:00:00'));
			$date_debut_annee = DateTime::createFromFormat('Y-m-d H:i:s', $tab_recurrence['date_debut'] . ' 00:00:00');
			$mois_debut = $date_debut_annee->format('n');

			// Si la semaine est a cheval sur 2 années, on replace le curseur sur la 1ere semaine (la dernière semaine de l'année sera traitée dans l'année précédente)
			if ($k > 0 && ($date_debut_annee->format('W') != '01' & $date_debut_annee->format('W') != '1')) {
				$numero_semaine_deb = '1';
			} else {
				$numero_semaine_deb = (int) $date_debut_annee->format('W');
			}

			$date_fin_annee = DateTime::createFromFormat('Y-m-d H:i:s', $tab_recurrence['date_fin'] . ' 00:00:00');
			$mois_fin = $date_fin_annee->format('n');

			if (((int) $date_fin_annee->format('W')) == "01"  && $mois_fin == "12") {

				$numero_semaine_fin = '52';
			} else {
				$numero_semaine_fin = (int) $date_fin_annee->format('W');
			}


			if (isset($mois_numeros)) { // Si N° Mois précisé


				for ($i = $mois_debut; $i <= $mois_fin; $i++) {

					if (!in_array($i, $mois_numeros)) { // Si le mois n'est pas inclus dans la récurrence, on créé des exceptions sur le mois

						// On créé les exceptions
						foreach ($this->get_jours_specifiques_mois($date_deb_recurrence['year'], $i, $array_jour_semaine['jour_nom']) as $jour) {

							$date_deb = $timedate->to_db($jour->format('d/m/Y') . " " . $this->a_partir_de);
							$date_fin = $timedate->to_db($jour->format('d/m/Y') . " " . $this->jusqu_a);

							if ($date_deb < $date_fin_agenda) {
								$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
							}
						}
					} else { // Pour les mois inclus, on vérifie les semaines indisponibles

						if (isset($semaine_numeros) && !empty($semaine_numeros) && strstr($semaine, '*/')) { // Si on est sur une paramètre de type "Une semaine sur X"
							for ($j = $numero_semaine_deb; $j <= $numero_semaine_fin; $j++) {
								$dto->setISODate($date_deb_recurrence['year'], $j, $array_jour_semaine['jour_numero_semaine']);
								$date_deb = $timedate->to_db($dto->format('d/m/Y') . " " . $this->a_partir_de);
								$date_fin = $timedate->to_db($dto->format('d/m/Y') . " " . $this->jusqu_a);
								$num_jour = $dto->format('j');

								if (!in_array($j, $semaine_numeros)) {
									$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
								} else if (isset($jour_numeros) && !empty($jour_numeros) && !in_array($num_jour, $jour_numeros)) { // Pour les semaines inclus, on vérifie les récurrences sur les numéros de jours

									$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
								}
							}
						} elseif (isset($semaine_numeros) && (strstr($semaine, '-') || strstr($semaine, ','))) { // Si liste de numéros de semaine (Semaine 4 et 6 du mois, semaine 1 à 3 du mois, ...)

							$semaines_du_mois = $this->nb_semaines_mois($date_deb_recurrence['year'], sprintf("%02d", $i));

							foreach ($semaines_du_mois as $semaine_annee => $semaine_mois) {

								$dto->setISODate($date_deb_recurrence['year'], ltrim($semaine_annee, "0"), $array_jour_semaine['jour_numero_semaine']);
								$mois_jour_courant = $dto->format('m');
								$num_jour = $dto->format('j');
								$date_deb = $timedate->to_db($dto->format('d/m/Y') . " " . $this->a_partir_de);
								$date_fin = $timedate->to_db($dto->format('d/m/Y') . " " . $this->jusqu_a);


								if ($mois_jour_courant == sprintf("%02d", $i) && !in_array($semaine_mois, $semaine_numeros)) {

									$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
								} elseif (isset($jour_numeros) && !empty($jour_numeros) && !in_array($num_jour, $jour_numeros)) {

									$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
								}
							}
						} else { // Sinon, on vérifie les numéros de jours (dans le mois) dans la récurrence

							foreach ($this->get_jours_specifiques_mois($date_deb_recurrence['year'], $i, $array_jour_semaine['jour_nom']) as $jour) {
								if ($jour_numeros && !in_array($jour->format('j'), $jour_numeros)) {
									$date_deb = $timedate->to_db($jour->format('d/m/Y') . " " . $this->a_partir_de);
									$date_fin = $timedate->to_db($jour->format('d/m/Y') . " " . $this->jusqu_a);

									$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
								}
							}
						}
					}
				}
			} else if (isset($semaine_numeros) && !empty($semaine_numeros) && strstr($semaine, '*/')) { // Si Une semaine sur X"

				$semaine_fin_tmp = $numero_semaine_fin;

				for ($j = $numero_semaine_deb; $j <= $semaine_fin_tmp; $j++) {

					$dto->setISODate($date_deb_recurrence['year'], $j, $array_jour_semaine['jour_numero_semaine']);
					$date_deb = $timedate->to_db($dto->format('d/m/Y') . " " . $this->a_partir_de);
					$date_fin = $timedate->to_db($dto->format('d/m/Y') . " " . $this->jusqu_a);

					if ($dto->format('Y') != $date_deb_recurrence['year']) {
						$semaine_debut = '1';
					} else {
						$num_jour = $dto->format('j');

						if (!in_array($j, $semaine_numeros)) {

							$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
						} else if (isset($jour_numeros) && !empty($jour_numeros) && !in_array($num_jour, $jour_numeros)) {   // Pour les semaines inclus, on vérifie les récurrences sur les numéros de jours

							$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
						}
					}
				}
			} elseif (isset($semaine_numeros) && (strstr($semaine, '-') || strstr($semaine, ','))) { // Si une liste de numéros de semaine (Semaine 4 et 6 du mois, semaine 1 à 3 du mois, ...)

				for ($i = $mois_debut; $i <= $mois_fin; $i++) {
					$semaines_du_mois = $this->nb_semaines_mois($date_deb_recurrence['year'], sprintf("%02d", $i));

					foreach ($semaines_du_mois as $semaine_annee => $semaine_mois) {
						$dto->setISODate($date_deb_recurrence['year'], ltrim($semaine_annee, "0"), $array_jour_semaine['jour_numero_semaine']);
						$mois_jour_courant = $dto->format('m');
						$num_jour = $dto->format('j');
						$date_deb = $timedate->to_db($dto->format('d/m/Y') . " " . $this->a_partir_de);
						$date_fin = $timedate->to_db($dto->format('d/m/Y') . " " . $this->jusqu_a);

						if ($mois_jour_courant == sprintf("%02d", $i)) {
							if (!in_array($semaine_mois, $semaine_numeros)) {

								$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
							} elseif (isset($jour_numeros) && !empty($jour_numeros) && !in_array($num_jour, $jour_numeros)) {

								$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
							}
						}
					}
				}
			} else { // Sinon, on vérifie les numéros de jours (dans le mois) dans la récurrence

				for ($i = $mois_debut; $i <= $mois_fin; $i++) {
					foreach ($this->get_jours_specifiques_mois($date_deb_recurrence['year'], $i, $array_jour_semaine['jour_nom']) as $jour) {
						if (!in_array($jour->format('j'), $jour_numeros)) {

							$date_deb = $timedate->to_db($jour->format('d/m/Y') . " " . $this->a_partir_de);
							$date_fin = $timedate->to_db($jour->format('d/m/Y') . " " . $this->jusqu_a);

							$this->date_derniere_occurence($this, $agenda, $date_deb, $date_fin);
						}
					}
				}
			}

			$k++;
		}


		if ($this->date_derniere_occurrence != $this->fetched_row['date_derniere_occurrence']) { // Si la date de dernière occurence a changé, on la sauvegarde dans la plage d'ouverture
			$this->save();
		}

		return true;
	}

	/**
	 * Modification de la date de derniere occurence
	 */
	public function date_derniere_occurence($instance, $agenda, $date_deb, $date_fin)
	{
		$bean_exception = BeanFactory::newBean('OPS_exception');
		$bean_exception->create_exceptions_recurrence($instance, $agenda, $date_deb, $date_fin);
		$this->date_derniere_occurrence = explode(' ', $date_fin)[0];
	}


	/**
	 * Initialistion de l'array contenant les recurrences
	 * @return array $liste_dispos_recurrences
	 */
	public function init_tab_recurrences()
	{
		global $current_user;


		/* [dates][semaine][mois] */
		$recurrence = explode(" ", $this->recurrence);
		$jours = $recurrence[0];
		$semaine = $recurrence[1];
		$mois = $recurrence[2];

		$agenda = $this->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_agendas");
		$agenda = $agenda[0];

		if (empty($agenda)) {
			$GLOBALS['log']->fatal('Plage ouverture sans agenda');
			return;
		}

		//// Gestion de la date de début et de fin de récurrence
		$rec_date_debut = $this->recurrence_date_deb;
		$agenda_date_fin = null;
		$possibleFormats = [
			"Y-m-d", // Format standard Y-m-d
			$current_user->getPreference('datef'), // Format basé sur la préférence utilisateur
		];

		$timeZone = TimeDate::userTimezone($current_user);

		// Détermination de la date de début de récurrence
		foreach ($possibleFormats as $format) {

			$dateChecker = DateTime::createFromFormat($format, $rec_date_debut);

			if ($dateChecker !== false && $dateChecker->format($format) === $rec_date_debut) {
				$rec_date_debut = $dateChecker;
				break;
			}
		}

		if ($rec_date_debut === null) {
			$GLOBALS['log']->debug('Impossible de déterminer le format de la date de début.');
		} else {
			$GLOBALS['log']->debug('date debut == ' . print_r($rec_date_debut, true));
		}


		// Détermination de la date de fin 
		if (empty($agenda->date_fin) && $agenda->souhait_glissement_fin == 1) {

			$agenda_date_fin = new DateTime('now', new DateTimeZone($timeZone));
			$agenda_date_fin->modify($agenda->jours_glissement_fin . ' days');
		} else {

			foreach ($possibleFormats as $format) {

				$dateChecker = DateTime::createFromFormat($format, $agenda->date_fin);

				if ($dateChecker !== false && $dateChecker->format($format) === $agenda->date_fin) {
					$agenda_date_fin = $dateChecker;
					break;
				}
			}
		}

		if ($agenda_date_fin === null) {
			$GLOBALS['log']->debug('Impossible de déterminer le format de la date de fin.');
		} else {
			$GLOBALS['log']->debug('date fin == ' . print_r($agenda_date_fin, true));
		}

		if ($rec_date_debut > $agenda_date_fin) {
			$lst_date_interval = array(
				"debut récurrence" => $rec_date_debut,
				"fin agenda" => $agenda_date_fin
			);
			$GLOBALS['log']->fatal('Erreur OPS_plage_ouverture: Date de début de récurrence > à la date de fin de l\'agenda:' . print_r($lst_date_interval, true));
		}


		$rec_date_debut->format('Y');

		if ($rec_date_debut->format('Y') != $agenda_date_fin->format('Y')) {
			$nb_annee = ($agenda_date_fin->format('Y') - $rec_date_debut->format('Y')) + 1;
			$annee_courante = $rec_date_debut->format('Y');

			for ($i = 0; $i < $nb_annee; $i++) {

				// Calcul des dates
				if ($i == 0) { // Première année 
					$date_debut_courant = $rec_date_debut;
					$date_fin_courant = DateTime::createFromFormat('Y-m-d', $annee_courante . '-12-31');
				} elseif ($i == ($nb_annee - 1)) { // Dernière année 
					$date_debut_courant = DateTime::createFromFormat('Y-m-d', $annee_courante . '-01-01');
					$date_fin_courant = $agenda_date_fin;
				} else {
					$date_debut_courant = DateTime::createFromFormat('Y-m-d', $annee_courante . '-01-01');
					$date_fin_courant = DateTime::createFromFormat('Y-m-d', $annee_courante . '-12-31');
				}

				$list_annees[$annee_courante]['date_debut'] = $date_debut_courant;
				$list_annees[$annee_courante]['date_fin'] = $date_fin_courant;

				$annee_courante = $annee_courante + 1;
			}
		} else {
			$list_annees[$rec_date_debut->format('Y')]['date_debut'] = $rec_date_debut;
			$list_annees[$rec_date_debut->format('Y')]['date_fin'] = $agenda_date_fin;
		}

		$liste_dispos_recurrences = array();

		$jour_numeros = array();
		if ($jours == '*' || strstr($jours, '*/')) { // Si la récurrence est autre chose qu'un numéro de jour, une liste de numéros ou une plage de numéros, on ne traite pas
		} elseif ($jours != '*') { // Si la récurrence est une liste de numéros ou une plage de numéros

			if (strstr($jours, ',')) { // Si la récurrence est une liste de numéros (ex: le 4, 5, 7 et 25 de chaque mois), on créé la liste des jours

				$ex_jours = explode(',', $jours);

				foreach ($ex_jours as $k1 => $jour_groupe) {

					if (strstr($jour_groupe, '-')) {
						$ex_jour_groupe = explode('-', $jour_groupe);

						for ($i = $ex_jour_groupe[0]; $i <= $ex_jour_groupe[1]; $i++) {
							$jour_numeros[] = $i;
						}
					} else {
						$jour_numeros[] = $jour_groupe;
					}
				}
			} elseif (strstr($jours, '-')) { // Sinon si la récurrence est une plage de numéros (ex: du 4 au 19 de chaque mois), on créé la liste des jours

				$ex_jour_groupe = explode('-', $jours);

				for ($i = $ex_jour_groupe[0]; $i <= $ex_jour_groupe[1]; $i++) {
					$jour_numeros[] = $i;
				}
			} else {
				$jour_numeros[] = $jours;
			}
		}

		$liste_dispos_recurrences['jours'] = $jour_numeros;

		$k = 0;
		foreach ($list_annees as $annee => $dates) {
			$liste_dispos_recurrences['annees'][$annee]['date_debut'] = $dates['date_debut']->format('Y-m-d');
			$liste_dispos_recurrences['annees'][$annee]['date_fin'] = $dates['date_fin']->format('Y-m-d');

			if ($semaine == '*') { // Si la récurrence est "Toutes les semaines", inutile de créer d'exception ici
			} elseif (strstr($semaine, '*/')) { // Sinon, si la récurrence est "Une semaine sur X (sur 2, sur 3, ...)" on va créer des exceptions pour les semaines hors récurrence
				$mult = str_replace('*/', '', $semaine);

				// Algorithme permettant le traitement du changement d'année
				if ($k != 0) {
					$j = $mult; // Variable initialisée par défaut par la valeur du multiplicateur
					// On récupère le numéro de la dernière semaine ouverte de l'année précédente
					$annee_prec = $annee - 1;
					$derniere_semaine_annee_prec = end($liste_dispos_recurrences['annees'][$annee_prec]['semaines']);

					/*
					 * Si la dernière semaine de l'année précédente n'est pas la dernière semaine de son année,
					 * On va soustraire à $j le nombre de semaines restantes dans l'année précédente
					 * (Exemple : dernière occurence semaine 52, l'année termine semaine 54, on enlève à $j 2 semaines)
					 */
					if ($derniere_semaine_annee_prec <= $semaine_fin) {
						$j = $j - ($semaine_fin - $derniere_semaine_annee_prec);
						$semaine_debut = $j;
					}
				} else {
					if ($k > 0 && $dates['date_debut']->format('W') != '01') {
						$semaine_debut = '1';
					} else {
						$semaine_debut = (int) $dates['date_debut']->format('W');
					}
				}

				if (((int) $dates['date_fin']->format('W')) == "01") {

					$semaine_fin = '52';
				} else {
					$semaine_fin = (int) $dates['date_fin']->format('W');
				}

				$semaine_numeros = array();
				$semaine_numeros[] = $semaine_debut;
				for ($i = $semaine_debut; $i < $semaine_fin; $i + $mult) {
					if (($i + $mult) <= $semaine_fin) {
						$semaine_numeros[] = $i + $mult;
					}
					$i += $mult;
				}
			} elseif ($semaine != '*') { // Sinon, si la récurrence est un ou des numéro(s) de semaine(s) dans le mois on va créer des exceptions pour la ou les semaine(s) hors récurrence
				$semaine_numeros = array();
				if (strstr($semaine, ',')) { // Si on a une virgule, cela veut dire une addition de semaines (ex: 2,4 veut dire la semaine 2 et la semaine 4 du mois)
					$ex_semaine = explode(',', $semaine);

					foreach ($ex_semaine as $semaine_groupe) {
						if (strstr($semaine_groupe, '-')) { // Si on a un tiret en plus, cela veut dire une série de semaine (ex: 2-4 veut dire de la 2ème à la 4ème semaine du mois)
							$ex_semaine_groupe = explode('-', $semaine_groupe);
							for ($i = $ex_semaine_groupe[0]; $i <= $ex_semaine_groupe[1]; $i++) {
								$semaine_numeros[] = $i;
							}
						} else { // Sinon, on met le numéro de semaine saisi directement
							$semaine_numeros[] = $semaine_groupe;
						}
					}
				} elseif (strstr($semaine, '-')) { // Si on a un tiret, cela veut dire une série de semaine (ex: 2-4 veut dire de la 2ème à la 4ème semaine du mois)

					$ex_semaine_groupe = explode('-', $semaine);

					for ($i = $ex_semaine_groupe[0]; $i <= $ex_semaine_groupe[1]; $i++) {
						$semaine_numeros[] = $i;
					}
				} else { // Sinon, on met le numéro de semaine saisi directement
					$semaine_numeros[] = $semaine;
				}
			}

			$liste_dispos_recurrences['annees'][$annee]['semaines'] = $semaine_numeros;

			$mois_debut = $dates['date_debut']->format('n');
			$mois_fin = $dates['date_fin']->format('n');

			if ($mois == '*') {
			} elseif (strstr($mois, '*/')) {
				$mult = str_replace('*/', '', $mois);

				$mois_numeros = array();
				$mois_numeros[] = $mois_debut;

				for ($i = $mois_debut; $i < $mois_fin; $i + $mult) {

					if (($i + $mult) < $mois_fin) {
						$mois_numeros[] = $i + $mult;
						$i += $mult;
					} else {
						$i = $mois_fin;
					}
				}
			} elseif ($mois != '*') {
				$mois_numeros = array();

				if (strstr($mois, ',')) {
					$ex_mois = explode(',', $mois);

					foreach ($ex_mois as $mois_groupe) {

						if (strstr($mois_groupe, '-')) {
							$ex_mois_groupe = explode('-', $mois_groupe);

							for ($i = $ex_mois_groupe[0]; $i <= $ex_mois_groupe[1]; $i++) {
								$mois_numeros[] = $i;
							}
						} else {
							$mois_numeros[] = $mois_groupe;
						}
					}
				} elseif (strstr($mois, '-')) {

					$ex_mois_groupe = explode('-', $mois);
					for ($i = $ex_mois_groupe[0]; $i <= $ex_mois_groupe[1]; $i++) {
						$mois_numeros[] = $i;
					}
				} else {
					$mois_numeros[] = $mois;
				}
			}

			$liste_dispos_recurrences['annees'][$annee]['mois'] = $mois_numeros;

			$k++;
		}

		return $liste_dispos_recurrences;
	}


	/**
	 * Suppression des exceptions obsolètes
	 * @param string $type_suppression
	 * @return bool
	 */
	public function delete_exceptions_recurrence($type_suppression = null)
	{
		$bean_exception = BeanFactory::newBean('OPS_exception');

		switch ($type_suppression) {
			case 'changement_recurrence': // Si la récurrence à changée, on supprime les exceptions liées à l'ancienne récurrence
			case 'suppression_plage_ouverture': // Suppression de la plage d'ouverture
				$list_exceptions_to_delete = $bean_exception->get_full_list(
					'name',
					'plage_ouverture_id = "' . $this->id . '" AND ops_exception.deleted = 0'
				);
				break;
			case 'exceptions_passees': // Si l'exception est passée de date, on la supprime pour alléger les chargements
				$list_exceptions_to_delete = $bean_exception->get_full_list(
					'name',
					'date_exception_fin < NOW() AND ops_exception.deleted = 0'
				);
				break;
			default:
				break;
		}

		if (isset($list_exceptions_to_delete) && !empty($list_exceptions_to_delete)) {

			$max_iteration = count($list_exceptions_to_delete);
			if ($type_suppression == "exceptions_passees"){
				$max_iteration = 100;
			}


			$i = 0;
			foreach ($list_exceptions_to_delete as $exception) {

				$exception->mark_deleted($exception->id);
				$exception->save();

				$exception->load_relationship('ops_agendas_ops_exception');
				$exception->ops_agendas_ops_exception->delete($exception, "");

				$i++;

				if ($i >= $max_iteration){
					break;
				}
			}

			// On réinitialise la date de dernière occurrence
			$this->date_derniere_occurrence = '';
			$this->save();
		}

		return true;
	}


	/**
	 * Récupération du nombre de semaines et le numéro de chaque semaine dans un mois
	 * @param [type] $annee
	 * @param [type] $mois
	 * @return int[] $array_semaines
	 */
	public function nb_semaines_mois($annee, $mois)
	{
		$date_jour = strtotime("$annee-$mois-01");
		$num_premiere_semaine = date("W", $date_jour);

		// Si on est sur le mois de décembre, on ajoute 1 à l'année et on force le mois à janvier
		if ($mois == 12) {
			$annee++;
			$mois = '01';
		} else {
			// On reformate le mois avec un leading zero pour éviter les effets de bord sur le calcul de la date de fin du mois
			$mois++;
		}
		$mois = sprintf("%02d", $mois);

		$date_jour = strtotime("$annee-$mois-01") - 86400;
		$derniere_semaine = date("W", $date_jour);

		$array_semaines = array();

		$j = 1;
		if ($num_premiere_semaine == 52 || $num_premiere_semaine == 53) {
			$num_premiere_semaine = 1;
		}

		for ($i = $num_premiere_semaine; $i <= $derniere_semaine; $i++) {
			$array_semaines[$i] = $j;
			$j++;
		}
		return $array_semaines;
	}


	/**
	 * Récupération des jours d'un mois, d'un numéro passé en paramètre (ex : Tout les lundis de mai 2022)
	 * @param mixed $annee
	 * @param mixed $mois
	 * @param mixed $jour
	 * @return array $jours
	 */
	public function get_jours_specifiques_mois($annee, $mois, $jour)
	{
		$dateString = 'first ' . $jour . ' of ' . $annee . '-' . $mois;

		if (!strtotime($dateString)) {
			$GLOBALS['log']->fatal('"' . $dateString . '" est invalide.');
		}

		$jourDebut = new \DateTime($dateString);

		$jours = array();

		while ($jourDebut->format('Y-m') <= $annee . '-' . str_pad($mois, 2, 0, STR_PAD_LEFT)) {
			$jours[] = clone ($jourDebut);
			$jourDebut->modify('+ 7 days');
		}

		return $jours;
	}

	/**
	 * Récupération du numéro de semaine d'un jour et de son nom
	 * @param mixed $jour
	 * @return array $ar_jour['jour_numero_semaine'] ['jour_nom']
	 */
	public function get_jour_semaine($jour)
	{

		$ar_jour = array();

		switch ($jour) {
			case "lundi": // Si le jour de la date contenue dans la plage d'ouverture est Monday (Lundi)
				$jour_numero_semaine = 1;
				$jour_nom = 'Monday';
				break;
			case "mardi": // Si le jour de la date contenue dans la plage d'ouverture est Tue (Mardi)
				$jour_numero_semaine = 2;
				$jour_nom = 'Tuesday';
				break;
			case "mercredi": // Si le jour de la date contenue dans la plage d'ouverture est Wed (Mercredi)
				$jour_numero_semaine = 3;
				$jour_nom = 'Wednesday';
				break;
			case "jeudi": // Si le jour de la date contenue dans la plage d'ouverture est Thu (Jeudi)
				$jour_numero_semaine = 4;
				$jour_nom = 'Thursday';
				break;
			case "vendredi": // Si le jour de la date contenue dans la plage d'ouverture est Fri (Vendredi)
				$jour_numero_semaine = 5;
				$jour_nom = 'Friday';
				break;
			case "samedi": // Si le jour de la date contenue dans la plage d'ouverture est Sat (Samedi)
				$jour_numero_semaine = 6;
				$jour_nom = 'Saturday';
				break;
			case "dimanche": // Si le jour de la date contenue dans la plage d'ouverture est Sun (Dimanche)
				$jour_numero_semaine = 7;
				$jour_nom = 'Sunday';
				break;
			default:
				break;
		}

		$ar_jour['jour_numero_semaine'] = $jour_numero_semaine;
		$ar_jour['jour_nom'] = $jour_nom;

		return $ar_jour;
	}
}