<?php

class OPS_type_personne extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_type_personne';
    public $object_name = 'OPS_type_personne';
    public $table_name = 'ops_type_personne';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;

    public $categorie_pes;
    public $nature_juridique_pes;
    public $type_tiers;
    public $imposable;
    public $gestion_interets_moratoires;
    public $gestion_multi_collectivite;
    public $classe_mouvement;
    public $device;
    public $code_pays;
    public $numero_rne;
    public $libelle_nom;
    public $date_declaration;
    public $situation_handicap;
    public $effectif;
    public $effectif_liste;
    public $libelle_effectif;
         
        
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * getChamps
     * @return Tableau des champs du type tiers pour création/modification
    */
    public function getChamps(){

        global $app_list_strings;

        if( !isset($this->id) ){
            return false ; 
        } 
        
        $liste_champs = array(
            'generalites' => [
                'libelle' => 'LBL_ONGLET_10',
                'ordre' => 10,
                'description' => '',
                'champs' => [
                    'name'               => array( "type" => "varchar", "propriete" => "required" ),
                    'nature'             => array( "type" => "liste" , "list_name" => "ops_type_profil_nature_list"),
                    'siret'              => array( "type" => "siret" ),
                    'numero_rna'         => array( "type" => "rna" ),
                    'numero_rne'         => array( "type" => "rne" ),
                    'num_tahiti'         => array( "type" => "num_tahiti" ),
                    'code_ape'           => array( "type" => "code_ape" ),
                    'forme_juridique'    => array( "type" => "liste" , "list_name" => "ops_forme_juridique_list"),
                    'date_declaration'   => array( "type" => "date" ),
                    'sigle'              => array( "type" => "varchar" ),
                    'effectif'           => array( "type" => "liste" , "list_name" => "ops_type_profil_effectif_list"),
                    'website'            => array( "type" => "varchar" ),
                    'objet_social'       => array( "type" => "varchar" ),
                    'situation_handicap' => array( "type" => "bool" ),
                    'secteur_activite'   => array( "type" => "liste" , "list_name" => "ops_profil_secteur_activite_list"),
                    'role'               => array( "type" => "liste" , "list_name" => "ops_role_list", "propriete" => "required"),
                ],
            ],
            'agrements_relations' => [
                'libelle' => 'LBL_ONGLET_20',
                'ordre' => 15,
                'description' => 'Les agréments et relations du profil',
                'champs' => [
                    'agrement_administratif'  => array( "type" => "bool" ),
                    'detail_agrement'         => array( "type" => "text" ),
                    'utilite_publique'        => array( "type" => "bool" ),
                    'date_utilite_publique'   => array( "type" => "date" ),
                    'affiliee_reseau'         => array( "type" => "bool" ),
                    'detail_affiliation'      => array( "type" => "text" ),
                ],
            ],

            'informations_fiscales' => [
                'libelle' => 'LBL_ONGLET_50',
                'ordre' => 25,
                'description' => '',
                'icone' => 'euro',
                'champs' => [
                    'regime_allocataire'  => array( "type" => "liste" , "list_name" => "ops_regime_allocataire_list" ),
                    'numero_allocataire'  => array( "type" => "varchar" ),
                    'qf_caf_actuel'       => array( "type" => "decimal" ),
                    'qf_ville_actuel'     => array( "type" => "decimal" ),
                    'bon_msa'             => array( "type" => "bool" ),
                    'date_application'    => array( "type" => "date" ),
                ],
            ],

            'moyens_contact' => [
                'libelle' => 'LBL_ONGLET_60',
                'ordre' => 40,
                'description' => 'Les moyens de contact du profil (téléphone(s), email(s)...)',
                'icone' => 'letter',
                'champs' => [
                    'email1'                           => array( "type" => "email" ),
                    'phone_office'                     => array( "type" => "phone" ),
                    'title'                            => array( "type" => "title", "libelle" => 'Adresse de domiciliation' ),
                    'skip'                             => array( "type" => "skip" ),
                    'billing_address_number'           => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'billing_address_street'           => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'billing_address_complement'       => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'billing_address_complement_lieu'  => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'billing_address_postalcode'       => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'billing_address_city'             => array( "type" => "varchar", 'group' => 'Adresse de domiciliation' ),
                    'adresse_date_validite'            => array( "type" => "date", 'group' => 'Adresse de domiciliation' ),
                    'adresse_hors_commune'             => array( "type" => "bool", 'group' => 'Adresse de domiciliation' ),
                    'title2'                           => array( "type" => "title", "libelle" => 'Adresse de facturation' ),
                    'skip2'                            => array( "type" => "skip" ),
                    'shipping_address_number'          => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                    'shipping_address_street'          => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                    'shipping_address_complement'      => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                    'shipping_address_complement_lieu' => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                    'shipping_address_postalcode'      => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                    'shipping_address_city'            => array( "type" => "varchar", 'group' => 'Adresse de facturation' ),
                ],
            ],

        );

        if( $this->display_annuaire ){
            

            $liste_champs['annuaire'] = array(
                    'libelle' => 'LBL_ONGLET_30',
                    'ordre' => 15,
                    'description' => 'Les données affichées dans l\'annuaire des tiers',
                    'icone' => 'tiles-list',
                    'champs' => [
                        'publie'                    => array( "type" => "bool" ),
                        'thematique'                => array( "type" => "liste_multi" , "list_name" => "ops_thematique_profil_list"),
                        'accroche'                  => array( "type" => "text_html" ),
                        'description_annuaire'      => array( "type" => "text_html" ),
                        'activites'                 => array( "type" => "text_html" ),
                        'tarifs'                    => array( "type" => "text_html" ),
                        'public_beneficiaire'       => array( "type" => "text_html" ),
                        'image'                     => array( "type" => "image" ),
                    ],
            );
        }

        $libelle_nom_liste = $app_list_strings['ops_tp_libelle_nom_list'];

        foreach ($liste_champs as $onglet_key => $onglet)
        {
            $liste_champs[$onglet_key]['libelle'] = translate($onglet['libelle'], 'OPS_personne_morale');

            foreach ($onglet['champs'] as $key => $champ) 
            {
                $liste_champs[$onglet_key]['champs'][$key]['name'] = $key;

                if( !empty($this->libelle_nom) && array_key_exists($this->libelle_nom, $libelle_nom_liste) && $key == 'name' )
                {
                    $liste_champs[$onglet_key]['champs'][$key]['libelle'] = $libelle_nom_liste[$this->libelle_nom];
                }
                else if($key == 'effectif' && !empty($this->libelle_effectif))
                {
                    $liste_champs[$onglet_key]['champs'][$key]['libelle'] = $this->libelle_effectif;
                }
                else if (!isset($champ['libelle']))
                {
                    $liste_champs[$onglet_key]['champs'][$key]['libelle'] = translate('LBL_'.strtoupper($key),'OPS_personne_morale'); 
                }
                
                if( isset( $this->$key ) ){
                    $liste_champs[$onglet_key]['champs'][$key]['propriete'] = $this->$key; 
                    $liste_champs[$onglet_key]['champs'][$key]['propriete'] = ( $key == "name" ) ? 'required' :  $this->$key; 
                }
                else if( !isset($champ['propriete']) ){
                    $liste_champs[$onglet_key]['champs'][$key]['propriete'] = ""; 
                }
                
                if( $champ['type'] == "liste" || $champ['type'] == "liste_multi" ){

                    if(in_array($key, ['forme_juridique', 'effectif', 'role']))
                    {
                        $valeurs_champs = unencodeMultienum( $this->{$key."_liste"} );

                        foreach ($app_list_strings[$champ['list_name']] as $cle => $libelle ) {
                            if( in_array( $cle, $valeurs_champs) ){
                                $liste_champs[$onglet_key]['champs'][$key]['liste'][$cle ] = $libelle;
                            }
                        }
                    }
                    else
                    {
                        foreach ($app_list_strings[$champ['list_name']] as $cle => $libelle ) {
                            $liste_champs[$onglet_key]['champs'][$key]['liste'][$cle ] = $libelle;
                        }
                        unset($liste_champs[$onglet_key]['champs'][$key]['liste']['']); // Champ vide mis automatiquement au front
                    }
                }
            }
        }
        return $liste_champs;
    }
}